/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ComponentElementProperties;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0014\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u001cH\u0014J\b\u0010$\u001a\u00020\u001aH\u0014J\b\u0010%\u001a\u00020\nH\u0014J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020\u001aH\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/configurationStore/ChooseComponentsToExportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "fileToComponents", "", "Ljava/nio/file/Path;", "", "Lcom/intellij/configurationStore/ExportableItem;", "isShowFilePath", "", "title", "", "description", "(Ljava/util/Map;ZLjava/lang/String;Ljava/lang/String;)V", "chooser", "Lcom/intellij/ide/util/ElementsChooser;", "Lcom/intellij/configurationStore/ComponentElementProperties;", "exportFile", "getExportFile$intellij_platform_configurationStore_impl", "()Ljava/nio/file/Path;", "exportableComponents", "", "getExportableComponents$intellij_platform_configurationStore_impl", "()Ljava/util/Set;", "pathPanel", "Lcom/intellij/ui/FieldPanel;", "browse", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createNorthPanel", "Ljavax/swing/JLabel;", "createSouthPanel", "doOKAction", "getDimensionServiceKey", "getPreferredFocusedComponent", "Ljavax/swing/JTextField;", "updateControls", "intellij.platform.configurationStore.impl"})
public final class ChooseComponentsToExportDialog
extends DialogWrapper {
    private final ElementsChooser<ComponentElementProperties> chooser;
    private final FieldPanel pathPanel;
    private final boolean isShowFilePath;
    private final String description;

    @NotNull
    public final Set<ExportableItem> getExportableComponents$intellij_platform_configurationStore_impl() {
        THashSet components = new THashSet();
        for (ComponentElementProperties elementProperties : this.chooser.getMarkedElements()) {
            components.addAll((Collection)elementProperties.getItems());
        }
        return (Set)components;
    }

    @NotNull
    public final Path getExportFile$intellij_platform_configurationStore_impl() {
        Path path = Paths.get(this.pathPanel.getText(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(pathPanel.text)");
        return path;
    }

    private final void browse() {
        String string = this.pathPanel.getText();
        Component component = this.getWindow();
        String string2 = ConfigurationStoreBundle.message("title.export.file.location", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ConfigurationStoreBundle\u2026le.export.file.location\")");
        String string3 = ConfigurationStoreBundle.message("prompt.choose.export.settings.file.path", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ConfigurationStoreBundle\u2026port.settings.file.path\")");
        ChooseComponentsToExportDialogKt.chooseSettingsFile(string, component, string2, string3).onSuccess((Consumer)new Consumer<VirtualFile>(this){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public final void accept(VirtualFile file) {
                String string;
                VirtualFile virtualFile = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                if (virtualFile.isDirectory()) {
                    string = file.getPath() + "/settings.zip";
                } else {
                    String string2 = file.getPath();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
                }
                String path = string;
                ChooseComponentsToExportDialog.access$getPathPanel$p(this.this$0).setText(FileUtil.toSystemDependentName((String)path));
            }
            {
                this.this$0 = chooseComponentsToExportDialog;
            }
        });
    }

    private final void updateControls() {
        CharSequence charSequence = this.pathPanel.getText();
        ChooseComponentsToExportDialog chooseComponentsToExportDialog = this;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        chooseComponentsToExportDialog.setOKActionEnabled(!bl3);
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction selectAll2 = new AbstractAction(this, "Select &All"){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(true);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        AbstractAction selectNone2 = new AbstractAction(this, "Select &None"){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(false);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        AbstractAction invert2 = new AbstractAction(this, "&Invert"){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).invertSelection();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        return new Action[]{selectAll2, selectNone2, invert2};
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue("export.settings.path", this.pathPanel.getText(), ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        StringBuilder builder = new StringBuilder();
        if (this.chooser.hasUnmarkedElements()) {
            List list = this.chooser.getElements(true);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"chooser.getElements(true)");
            List marked = list;
            for (ComponentElementProperties element : marked) {
                builder.append(element.getFileName());
                builder.append("|");
            }
        }
        CharSequence charSequence = builder;
        String string = "export.settings.marked";
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        boolean bl = false;
        boolean bl2 = charSequence.length() == 0;
        propertiesComponent.setValue(string, bl2 ? null : builder.toString());
        super.doOKAction();
    }

    @Nullable
    public JTextField getPreferredFocusedComponent() {
        return this.pathPanel.getTextField();
    }

    @NotNull
    protected JLabel createNorthPanel() {
        return new JLabel(this.description);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.chooser;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent buttons = super.createSouthPanel();
        if (!this.isShowFilePath) {
            JComponent jComponent = buttons;
            Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"buttons");
            return jComponent;
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)this.pathPanel);
        panel.add(buttons);
        return panel;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.ChooseComponentsToExportDialog";
    }

    public ChooseComponentsToExportDialog(@NotNull Map<Path, ? extends List<ExportableItem>> fileToComponents, boolean isShowFilePath, @NotNull String title, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull(fileToComponents, (String)"fileToComponents");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        super(false);
        this.isShowFilePath = isShowFilePath;
        this.description = description;
        this.pathPanel = new FieldPanel(ConfigurationStoreBundle.message("editbox.export.settings.to", new Object[0]), null, new ActionListener(this){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public final void actionPerformed(ActionEvent it) {
                ChooseComponentsToExportDialog.access$browse(this.this$0);
            }
            {
                this.this$0 = chooseComponentsToExportDialog;
            }
        }, (Runnable)null);
        LinkedHashMap componentToContainingListElement = new LinkedHashMap();
        for (List<ExportableItem> list : fileToComponents.values()) {
            for (ExportableItem item : list) {
                if (ChooseComponentsToExportDialogKt.access$addToExistingListElement(item, componentToContainingListElement, fileToComponents)) continue;
                ComponentElementProperties componentElementProperties = new ComponentElementProperties();
                componentElementProperties.getItems().add((Object)item);
                ((Map)componentToContainingListElement).put(item, componentElementProperties);
            }
        }
        this.chooser = new ElementsChooser(true);
        this.chooser.setColorUnmarkedElements(false);
        Set set = ChooseComponentsToExportDialogKt.access$getMarkedElementNames$p();
        for (ComponentElementProperties componentElementProperty : new LinkedHashSet(componentToContainingListElement.values())) {
            this.chooser.addElement((Object)componentElementProperty, set.isEmpty() || set.contains(componentElementProperty.getFileName()), (MultiStateElementsChooser.ElementProperties)componentElementProperty);
        }
        this.chooser.sort(Comparator.comparing(1.INSTANCE));
        String string = PropertiesComponent.getInstance().getValue("export.settings.path", ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PropertiesComponent.getI\u2026ings.path\", DEFAULT_PATH)");
        String exportPath = string;
        this.pathPanel.setText(exportPath);
        this.pathPanel.setChangeListener(new Runnable(){

            @Override
            public final void run() {
                this.updateControls();
            }
        });
        this.updateControls();
        this.setTitle(title);
        this.init();
    }

    public static final /* synthetic */ FieldPanel access$getPathPanel$p(ChooseComponentsToExportDialog $this) {
        return $this.pathPanel;
    }

    public static final /* synthetic */ ElementsChooser access$getChooser$p(ChooseComponentsToExportDialog $this) {
        return $this.chooser;
    }

    public static final /* synthetic */ void access$browse(ChooseComponentsToExportDialog $this) {
        $this.browse();
    }
}

