/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.problems.FwOutputSettings;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeBackgroundTaskConsumer
extends BackgroundTaskConsumer {
    private final FileType myFileType;

    protected FileTypeBackgroundTaskConsumer(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeBackgroundTaskConsumer.$$$reportNull$$$0(0);
        }
        this.myFileType = fileType;
    }

    @Override
    public boolean isAvailable(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            FileTypeBackgroundTaskConsumer.$$$reportNull$$$0(1);
        }
        if ((virtualFile = psiFile.getVirtualFile()) != null) {
            return this.isAvailable(virtualFile, EnvironmentVariablesData.DEFAULT);
        }
        return false;
    }

    public boolean isAvailable(@NotNull VirtualFile file, @NotNull EnvironmentVariablesData data) {
        if (file == null) {
            FileTypeBackgroundTaskConsumer.$$$reportNull$$$0(2);
        }
        if (data == null) {
            FileTypeBackgroundTaskConsumer.$$$reportNull$$$0(3);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, this.myFileType);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            FileTypeBackgroundTaskConsumer.$$$reportNull$$$0(4);
        }
        return fileType;
    }

    @Nullable
    public String getTrackOnlyRootFilesLabel() {
        return null;
    }

    @NotNull
    public FwOutputSettings getOutputSettings() {
        FwOutputSettings fwOutputSettings = FwOutputSettings.DEFAULT;
        if (fwOutputSettings == null) {
            FileTypeBackgroundTaskConsumer.$$$reportNull$$$0(5);
        }
        return fwOutputSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

