/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.StatusText;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.ExternalOptionHelper;
import com.maddyhome.idea.copyright.ui.CopyrightConfigurable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CopyrightProfilesPanel
extends MasterDetailsComponent
implements SearchableConfigurable {
    private final Project myProject;
    private final AtomicBoolean myInitialized = new AtomicBoolean(false);
    private Runnable myUpdate;

    CopyrightProfilesPanel(Project project) {
        this.myProject = project;
        this.initTree();
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> (String)ObjectUtils.doIfNotNull((Object)((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()), c -> c.getDisplayName()), true);
        StatusText emptyText = this.myTree.getEmptyText();
        emptyText.setText(CopyrightBundle.message("copyright.profiles.empty", new Object[0]));
        emptyText.appendSecondaryText(CopyrightBundle.message("copyright.profiles.add.profile", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, __ -> this.doAddProfile());
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        if (!shortcutText.isEmpty()) {
            emptyText.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
        }
    }

    void setUpdate(Runnable update) {
        this.myUpdate = update;
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    protected String getComponentStateKey() {
        return "Copyright.UI";
    }

    protected void processRemovedItems() {
        Map<String, CopyrightProfile> profiles = this.getAllProfiles();
        CopyrightManager manager = CopyrightManager.getInstance(this.myProject);
        for (CopyrightProfile profile : new ArrayList<CopyrightProfile>(manager.getCopyrights())) {
            if (profiles.containsValue((Object)profile)) continue;
            manager.removeCopyright(profile);
        }
    }

    protected boolean wasObjectStored(Object o) {
        return CopyrightManager.getInstance(this.myProject).getCopyrights().contains((Object)((CopyrightProfile)((Object)o)));
    }

    public String getDisplayName() {
        return CopyrightBundle.message("configurable.CopyrightProfilesPanel.display.name", new Object[0]);
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        return "copyright.profiles";
    }

    protected void reloadAvailableProfiles() {
        if (this.myUpdate != null) {
            this.myUpdate.run();
        }
    }

    public void apply() throws ConfigurationException {
        HashSet<String> profiles = new HashSet<String>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            String profileName = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject().getName();
            if (profiles.contains(profileName)) {
                this.selectNodeInTree(profileName);
                throw new ConfigurationException("Duplicate copyright profile name: '" + profileName + "'");
            }
            profiles.add(profileName);
        }
        super.apply();
    }

    Map<String, CopyrightProfile> getAllProfiles() {
        HashMap<String, CopyrightProfile> profiles = new HashMap<String, CopyrightProfile>();
        if (!this.myInitialized.get()) {
            for (CopyrightProfile profile : CopyrightManager.getInstance(this.myProject).getCopyrights()) {
                profiles.put(profile.getName(), profile);
            }
        } else {
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
                CopyrightProfile copyrightProfile = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject();
                profiles.put(copyrightProfile.getName(), copyrightProfile);
            }
        }
        return profiles;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myInitialized.set(false);
    }

    private void doAddProfile() {
        String name = this.askForProfileName("Create Copyright Profile", "");
        if (name != null) {
            this.addProfileNode(new CopyrightProfile(name));
        }
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add((AnAction)new DumbAwareAction(CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.text.add", new Object[0]), CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.description.add", new Object[0]), IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD), (JComponent)CopyrightProfilesPanel.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                CopyrightProfilesPanel.this.doAddProfile();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$1", "actionPerformed"));
            }
        });
        result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        result.add((AnAction)new DumbAwareAction(CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.text.copy", new Object[0]), CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.description.copy", new Object[0]), PlatformIcons.COPY_ICON){
            {
                this.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), (JComponent)CopyrightProfilesPanel.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                String profileName;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((profileName = CopyrightProfilesPanel.this.askForProfileName("Copy Copyright Profile", "")) == null) {
                    return;
                }
                CopyrightProfile clone = new CopyrightProfile();
                clone.copyFrom((CopyrightProfile)((Object)CopyrightProfilesPanel.this.getSelectedObject()));
                clone.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(clone);
            }

            public void update(@NotNull AnActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.update(event);
                event.getPresentation().setEnabled(CopyrightProfilesPanel.this.getSelectedObject() != null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        result.add((AnAction)new DumbAwareAction(CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.text.import", new Object[0]), CopyrightBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.description.import", new Object[0]), PlatformIcons.IMPORT_ICON){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> {
                    FileType fileType = file.getFileType();
                    return fileType != PlainTextFileType.INSTANCE && (fileType == StdFileTypes.IDEA_MODULE || fileType == StdFileTypes.XML);
                }).withTitle(CopyrightBundle.message("dialog.file.chooser.title.choose.file.containing.copyright.notice", new Object[0]));
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)CopyrightProfilesPanel.this.myProject, null, file -> {
                    List<CopyrightProfile> profiles = ExternalOptionHelper.loadOptions(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                    if (profiles == null) {
                        return;
                    }
                    if (!profiles.isEmpty()) {
                        if (profiles.size() == 1) {
                            this.importProfile(profiles.get(0));
                        } else {
                            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<CopyrightProfile>(CopyrightBundle.message("popup.title.choose.profile.to.import", new Object[0]), profiles){

                                public PopupStep onChosen(CopyrightProfile selectedValue, boolean finalChoice) {
                                    return this.doFinalStep(() -> this.importProfile(selectedValue));
                                }

                                @NotNull
                                public String getTextFor(CopyrightProfile value) {
                                    String string = value.getName();
                                    if (string == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return string;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$3$1", "getTextFor"));
                                }
                            }).showUnderneathOf((Component)CopyrightProfilesPanel.this.myNorthPanel);
                        }
                    } else {
                        Messages.showWarningDialog((Project)CopyrightProfilesPanel.this.myProject, (String)CopyrightBundle.message("dialog.message.the.selected.file.copyright.settings", new Object[0]), (String)CopyrightBundle.message("dialog.title.import.failure", new Object[0]));
                    }
                });
            }

            private void importProfile(CopyrightProfile copyrightProfile) {
                String profileName = CopyrightProfilesPanel.this.askForProfileName("Import copyright profile", copyrightProfile.getName());
                if (profileName == null) {
                    return;
                }
                copyrightProfile.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(copyrightProfile);
                Messages.showInfoMessage((Project)CopyrightProfilesPanel.this.myProject, (String)CopyrightBundle.message("dialog.message.the.copyright.settings.imported", new Object[0]), (String)CopyrightBundle.message("dialog.title.import.complete", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$3", "actionPerformed"));
            }
        });
        return result;
    }

    @Nullable
    private String askForProfileName(String title, String initialName) {
        return Messages.showInputDialog((String)CopyrightBundle.message("dialog.message.new.copyright.profile.name", new Object[0]), (String)title, (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)new InputValidator(){

            public boolean checkInput(String s) {
                return !CopyrightProfilesPanel.this.getAllProfiles().containsKey(s) && s.length() > 0;
            }

            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    private void addProfileNode(@NotNull CopyrightProfile copyrightProfile) {
        if (copyrightProfile == null) {
            CopyrightProfilesPanel.$$$reportNull$$$0(0);
        }
        CopyrightConfigurable copyrightConfigurable = new CopyrightConfigurable(this.myProject, copyrightProfile, this.TREE_UPDATER);
        copyrightConfigurable.setModified(true);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)copyrightConfigurable);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node);
        this.reloadAvailableProfiles();
    }

    protected void removePaths(TreePath ... paths) {
        super.removePaths(paths);
        this.reloadAvailableProfiles();
    }

    private void reloadTree() {
        this.myRoot.removeAllChildren();
        Collection<CopyrightProfile> collection = CopyrightManager.getInstance(this.myProject).getCopyrights();
        for (CopyrightProfile profile : collection) {
            CopyrightProfile clone = new CopyrightProfile();
            clone.copyFrom(profile);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new CopyrightConfigurable(this.myProject, clone, this.TREE_UPDATER)), this.myRoot);
        }
        this.myInitialized.set(true);
    }

    public void reset() {
        this.reloadTree();
        super.reset();
    }

    protected String getEmptySelectionString() {
        return CopyrightBundle.message("copyright.profiles.select.profile", new Object[0]);
    }

    void addItemsChangeListener(final Runnable runnable) {
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                ApplicationManager.getApplication().invokeLater(runnable);
            }

            public void itemsExternallyChanged() {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
        });
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            CopyrightProfilesPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyrightProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addProfileNode";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

