/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.dnd;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class UmlDnDSupport
implements DropTargetListener {
    private final DiagramBuilder myBuilder;
    private final DiagramDnDProvider myProvider;
    final DiagramDataModel myDataModel;

    public UmlDnDSupport(DiagramBuilder builder) {
        this.myBuilder = builder;
        DiagramExtras extras = builder.getProvider().getExtras();
        this.myProvider = extras.getDnDProvider();
        this.myDataModel = builder.getDataModel();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Object[] values;
        if (this.myProvider == null || (values = this.getValues(dtde.getTransferable())).length == 0) {
            dtde.rejectDrag();
            return;
        }
        for (Object value : values) {
            if (this.myProvider.isAcceptedForDnD(value, this.myBuilder.getProject())) continue;
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(3);
    }

    private Object[] getValues(Transferable transferable) {
        try {
            TreeNode[] treeNodes = AbstractProjectViewPane.getTransferedTreeNodes((Transferable)transferable);
            if (treeNodes != null) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (TreeNode treeNode : treeNodes) {
                    Object userObject;
                    if (!(treeNode instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof AbstractTreeNode)) continue;
                    values.add(((AbstractTreeNode)userObject).getValue());
                }
                return ArrayUtil.toObjectArray(values);
            }
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof Object[]) {
                return (Object[])transferData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point loc = dtde.getLocation();
        Object[] values = this.getValues(dtde.getTransferable());
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object value : values) {
            Object[] element;
            Project project = this.myBuilder.getProject();
            if (!this.myProvider.isAcceptedForDnD(value, project) || (element = this.myProvider.wrapToModelObject(value, project)) == null || element.length <= 0) continue;
            elements.addAll(Arrays.asList(element));
        }
        if (!elements.isEmpty()) {
            Runnable addElements = () -> {
                boolean setCoord = false;
                for (Object element : elements) {
                    DiagramNode umlNode = this.myDataModel.addElement(element);
                    if (setCoord || umlNode == null) continue;
                    umlNode.putUserData(Utils.GRAPH_BUILDER, (Object)this.myBuilder);
                    Node node = NodeFactory.getInstance().createDraggedNode((GraphBuilder)((UmlGraphBuilder)this.myBuilder), (Object)umlNode, umlNode.getTooltip(), new Point(0, 0));
                    if (node == null) continue;
                    Graph2DView view = this.myBuilder.getView();
                    this.myBuilder.getGraph().getRealizer(node).setLocation(view.toWorldCoordX((int)loc.getX()), view.toWorldCoordY((int)loc.getY()));
                    setCoord = true;
                }
                this.myDataModel.refreshDataModel();
                this.myBuilder.updateGraph();
            };
            DiagramAction.performCommand((DiagramBuilder)this.myBuilder, (Runnable)addElements, (String)DiagramBundle.message((String)"command.add.elements", (Object[])new Object[0]), null, (PsiElement[])new PsiElement[0]);
        }
    }
}

