/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Graph2DViewActions;
import com.intellij.uml.core.actions.ChangeCreationEdgeMode;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.core.actions.MoveSelectionWrapper;
import com.intellij.uml.core.actions.UmlAddNodeAction;
import com.intellij.uml.core.actions.UmlCategorySwitcher;
import com.intellij.uml.core.actions.UmlShowDependencies;
import com.intellij.uml.core.actions.scopes.UmlScopesActionGroup;
import com.intellij.uml.core.actions.visibility.UmlVisibilityActionGroup;
import com.intellij.uml.utils.DiagramBundle;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class UmlActions {
    @NonNls
    private static final String FOCUS_TOP_NODE = "FOCUS_TOP_NODE";
    @NonNls
    private static final String FOCUS_BOTTOM_NODE = "FOCUS_BOTTOM_NODE";
    @NonNls
    private static final String FOCUS_LEFT_NODE = "FOCUS_LEFT_NODE";
    @NonNls
    private static final String FOCUS_RIGHT_NODE = "FOCUS_RIGHT_NODE";
    @NonNls
    private static final String DELETE_SELECTION = "DELETE_SELECTION";
    @NonNls
    private static final String EDIT_NODE = "EDIT_NODE";
    @NonNls
    private static final String ADD_NODE = "ADD_NODE";
    private static final Map<String, MoveSelectionWrapper.Keys> MOVE_KEYS = new HashMap<String, MoveSelectionWrapper.Keys>();

    private UmlActions() {
    }

    public static void install(DiagramBuilder myBuilder) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Graph2DView view = myBuilder.getView();
        Graph2DViewActions actions = GraphManager.getGraphManager().createGraph2DViewActions(view);
        ActionMap actionMap = actions.createActionMap();
        InputMap inputMap = actions.createDefaultInputMap(actionMap);
        inputMap.put(KeyStroke.getKeyStroke(113, 0, false), EDIT_NODE);
        UmlActions.setMoveActions(actionMap, myBuilder, FOCUS_TOP_NODE, FOCUS_BOTTOM_NODE, FOCUS_LEFT_NODE, FOCUS_RIGHT_NODE);
        UmlActions.wrapDeleteAction(actionMap, myBuilder);
        DiagramAddElementAction gotoAction = myBuilder.getProvider().getExtras().getAddElementHandler();
        if (gotoAction != null) {
            UmlAddNodeAction addNodeAction = new UmlAddNodeAction((GotoActionBase)gotoAction, myBuilder);
            actionMap.put(ADD_NODE, addNodeAction);
            inputMap.put(KeyStroke.getKeyStroke(32, 0, false), ADD_NODE);
        }
        view.getCanvasComponent().setActionMap(actionMap);
        view.getCanvasComponent().setInputMap(1, inputMap);
    }

    private static void setMoveActions(ActionMap aMap, DiagramBuilder builder, String ... actions) {
        for (String actionName : actions) {
            Action action = aMap.get(actionName);
            if (!(action instanceof AbstractAction)) continue;
            aMap.put(actionName, new MoveSelectionWrapper(MOVE_KEYS.get(actionName), builder));
        }
    }

    private static void wrapDeleteAction(ActionMap aMap, DiagramBuilder builder) {
        AbstractAction action = (AbstractAction)aMap.get(DELETE_SELECTION);
        DeleteSelectionWrapper wrapper = new DeleteSelectionWrapper(action, builder);
        aMap.put(DELETE_SELECTION, (Action)((Object)wrapper));
    }

    public static DefaultActionGroup createToolbarActions(DiagramBuilder builder) {
        DiagramScopeManager scopeManager;
        UmlVisibilityActionGroup visibilityActionGroup;
        DefaultActionGroup group = new DefaultActionGroup();
        DiagramProvider provider = builder.getProvider();
        if (builder.getPresentationModel().allowChangeVisibleCategories()) {
            DiagramCategory[] categories;
            for (DiagramCategory category : categories = provider.getNodeContentManager().getContentCategories()) {
                group.add((AnAction)new UmlCategorySwitcher(category, builder));
            }
        }
        if ((visibilityActionGroup = new UmlVisibilityActionGroup(builder)).getChildrenCount() > 0) {
            group.add((AnAction)visibilityActionGroup);
        }
        if ((scopeManager = builder.getDataModel().getScopeManager()) != null) {
            group.add((AnAction)new UmlScopesActionGroup(builder, scopeManager));
        }
        if (provider.getEdgeCreationPolicy() != null) {
            group.add((AnAction)new ChangeCreationEdgeMode());
        }
        group.addSeparator();
        if (builder.getDataModel().isDependencyDiagramSupported()) {
            group.add((AnAction)new UmlShowDependencies());
            group.add((AnAction)new Separator());
        }
        group.add((AnAction)GraphViewUtil.getCommonToolbarActions());
        return group;
    }

    public static DefaultActionGroup getCategoriesActions(DiagramBuilder builder) {
        DiagramCategory[] categories = builder.getProvider().getNodeContentManager().getContentCategories();
        DefaultActionGroup group = DefaultActionGroup.createPopupGroup((Supplier)DiagramBundle.messagePointer((String)"show.categories.title", (Object[])new Object[0]));
        for (DiagramCategory category : categories) {
            group.add((AnAction)new UmlCategorySwitcher(category, builder));
        }
        return group;
    }

    public static void registerCustomShortcuts(DiagramBuilder graphBuilder) {
        String[] actions;
        JComponent comp = graphBuilder.getView().getCanvasComponent();
        ActionManager am = ActionManager.getInstance();
        for (String action : actions = new String[]{"Uml.CollapseNodes", "Uml.ExpandNodes", "Uml.NodeIntentions", "UML.ShowStructure", "UML.Find", "Uml.NewElement"}) {
            am.getAction(action).registerCustomShortcutSet(comp, (Disposable)graphBuilder);
        }
    }

    static {
        MOVE_KEYS.put(FOCUS_TOP_NODE, MoveSelectionWrapper.Keys.UP);
        MOVE_KEYS.put(FOCUS_BOTTOM_NODE, MoveSelectionWrapper.Keys.DOWN);
        MOVE_KEYS.put(FOCUS_LEFT_NODE, MoveSelectionWrapper.Keys.LEFT);
        MOVE_KEYS.put(FOCUS_RIGHT_NODE, MoveSelectionWrapper.Keys.RIGHT);
    }
}

