/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GPlumJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern GPLUM_VERSION_PATTERN = Pattern.compile("greenplum database\\s+" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN, 2);

    public GPlumJdbcHelper() {
        this(null, null);
    }

    private GPlumJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("GREENPLUM", version, connection);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return GPlumJdbcHelper.extractVersion(version);
    }

    @NotNull
    static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String version) {
        return new GPlumJdbcHelper(GPlumJdbcHelper.extractVersion(version), delegate);
    }

    @Nullable
    private static String extractVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, GPLUM_VERSION_PATTERN);
    }
}

