/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.sql.ScriptumResource;
import com.intellij.database.remote.jdba.sql.ScriptumResourceFromJava;
import com.intellij.database.remote.jdba.sql.SqlCommand;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.sql.SqlScript;
import com.intellij.database.remote.jdba.sql.SqlScriptBuilder;
import com.intellij.database.remote.jdba.sql.TextFileFragment;
import com.intellij.database.remote.jdba.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scriptum {
    @NotNull
    private final ScriptumResource[] myResources;
    @Nullable
    private final String myDialect;
    private static final Pattern STRIP_SINGLE_STATEMENT_PATTERN = Pattern.compile("((\\;\\s*)+|(\\n\\/\\s*\\n?)+)$", 32);

    @NotNull
    public static Scriptum of(@NotNull Class clazz) {
        if (clazz == null) {
            Scriptum.$$$reportNull$$$0(0);
        }
        ClassLoader classLoader = clazz.getClassLoader();
        String className = clazz.getName();
        String path = className.replace('.', '/');
        String resourceName = path + ".sql";
        return Scriptum.of(classLoader, resourceName);
    }

    @NotNull
    public static Scriptum of(@NotNull Class clazz, @NotNull String name) {
        if (clazz == null) {
            Scriptum.$$$reportNull$$$0(1);
        }
        if (name == null) {
            Scriptum.$$$reportNull$$$0(2);
        }
        ClassLoader classLoader = clazz.getClassLoader();
        String packageName = clazz.getPackage().getName();
        String path = packageName.replace('.', '/');
        String fileName = name;
        if (!fileName.contains(".")) {
            fileName = fileName + ".sql";
        }
        String resourceName = path + '/' + fileName;
        return Scriptum.of(classLoader, resourceName);
    }

    @NotNull
    public static Scriptum dialectOf(@NotNull Class clazz, @Nullable String dialect) {
        String name2;
        boolean exist2;
        if (clazz == null) {
            Scriptum.$$$reportNull$$$0(3);
        }
        ClassLoader classLoader = clazz.getClassLoader();
        String className = clazz.getName();
        String path = className.replace('.', '/');
        ArrayList<ScriptumResourceFromJava> sr = new ArrayList<ScriptumResourceFromJava>(2);
        if (dialect != null) {
            boolean exist1;
            String name1 = path + '+' + dialect + ".sql";
            boolean bl = exist1 = classLoader.getResource(name1) != null;
            if (exist1) {
                ScriptumResourceFromJava r1 = new ScriptumResourceFromJava(classLoader, name1);
                sr.add(r1);
            }
        }
        boolean bl = exist2 = classLoader.getResource(name2 = path + ".sql") != null;
        if (exist2) {
            ScriptumResourceFromJava r2 = new ScriptumResourceFromJava(classLoader, name2);
            sr.add(r2);
        }
        if (sr.isEmpty()) {
            throw new IllegalArgumentException(String.format("Resources for class %s not found", className));
        }
        ScriptumResource[] resources = sr.toArray(new ScriptumResource[sr.size()]);
        return new Scriptum(resources, dialect);
    }

    @NotNull
    public static Scriptum dialectOf(@NotNull Scriptum parentScriptum, @Nullable String dialect) {
        if (parentScriptum == null) {
            Scriptum.$$$reportNull$$$0(4);
        }
        if (Strings.eq(parentScriptum.myDialect, dialect)) {
            Scriptum scriptum = parentScriptum;
            if (scriptum == null) {
                Scriptum.$$$reportNull$$$0(5);
            }
            return scriptum;
        }
        return new Scriptum(parentScriptum.myResources, dialect);
    }

    @NotNull
    public static Scriptum of(ClassLoader classLoader, String resourceName) {
        boolean exists;
        ArrayList<ScriptumResourceFromJava> sr = new ArrayList<ScriptumResourceFromJava>(2);
        boolean bl = exists = classLoader.getResource(resourceName) != null;
        if (!exists) {
            throw new IllegalArgumentException(String.format("Resources for class %s not found", resourceName));
        }
        ScriptumResourceFromJava r2 = new ScriptumResourceFromJava(classLoader, resourceName);
        sr.add(r2);
        ScriptumResource[] resources = sr.toArray(new ScriptumResource[sr.size()]);
        return new Scriptum(resources, null);
    }

    private Scriptum(@NotNull ScriptumResource[] resources, @Nullable String dialect) {
        if (resources == null) {
            Scriptum.$$$reportNull$$$0(6);
        }
        this.myResources = resources;
        this.myDialect = dialect;
    }

    @Nullable
    public final TextFileFragment findText(@NotNull String name) {
        if (name == null) {
            Scriptum.$$$reportNull$$$0(7);
        }
        String nameWithDialect = this.myDialect == null ? null : name + '+' + this.myDialect;
        for (int i = this.myResources.length - 1; i >= 0; --i) {
            TextFileFragment fragment;
            ScriptumResource r = this.myResources[i];
            if (nameWithDialect != null && (fragment = r.find(nameWithDialect)) != null) {
                return fragment;
            }
            fragment = r.find(name);
            if (fragment == null) continue;
            return fragment;
        }
        return null;
    }

    @NotNull
    public final TextFileFragment getText(@NotNull String name) throws ScriptNotFoundException {
        TextFileFragment fragment;
        if (name == null) {
            Scriptum.$$$reportNull$$$0(8);
        }
        if ((fragment = this.findText(name)) != null) {
            TextFileFragment textFileFragment = fragment;
            if (textFileFragment == null) {
                Scriptum.$$$reportNull$$$0(9);
            }
            return textFileFragment;
        }
        StringBuilder b = new StringBuilder();
        b.append("No such script with name: ").append(name).append('\n');
        boolean was = false;
        for (ScriptumResource r : this.myResources) {
            for (String existentName : r.getExistentNames()) {
                if (!was) {
                    b.append("There are scripts: ");
                    was = true;
                } else {
                    b.append(", ");
                }
                b.append(existentName);
            }
        }
        if (!was) {
            b.append("There are no scripts at all");
        }
        throw new ScriptNotFoundException(b.toString());
    }

    @NotNull
    public final List<String> listFragmentNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ScriptumResource resource : this.myResources) {
            names.addAll(Arrays.asList(resource.getExistentNames()));
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            Scriptum.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public final List<TextFileFragment> listFragments() {
        ArrayList<TextFileFragment> fragments = new ArrayList<TextFileFragment>();
        for (ScriptumResource resource : this.myResources) {
            resource.loadIfNeeded();
            fragments.addAll(Arrays.asList(resource.myFragments));
        }
        ArrayList<TextFileFragment> arrayList = fragments;
        if (arrayList == null) {
            Scriptum.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public final <S> SqlQuery<S> query(@NotNull String name, @NotNull ResultLayout<S> layout) {
        if (name == null) {
            Scriptum.$$$reportNull$$$0(12);
        }
        if (layout == null) {
            Scriptum.$$$reportNull$$$0(13);
        }
        TextFileFragment fragment = this.getText(name);
        fragment = this.stripSingleStatement(fragment);
        SqlQuery<S> query = new SqlQuery<S>(fragment, layout);
        query.setDisplayName(fragment.getFragmentName());
        SqlQuery<S> sqlQuery = query;
        if (sqlQuery == null) {
            Scriptum.$$$reportNull$$$0(14);
        }
        return sqlQuery;
    }

    @NotNull
    public final SqlCommand command(@NotNull String name) {
        if (name == null) {
            Scriptum.$$$reportNull$$$0(15);
        }
        TextFileFragment fragment = this.getText(name);
        fragment = this.stripSingleStatement(fragment);
        return new SqlCommand(fragment);
    }

    @NotNull
    public final SqlScript script(@NotNull String name) {
        if (name == null) {
            Scriptum.$$$reportNull$$$0(16);
        }
        TextFileFragment fragment = this.getText(name);
        SqlScriptBuilder b = new SqlScriptBuilder();
        b.parse(fragment.text);
        return new SqlScript(b.build());
    }

    @NotNull
    private TextFileFragment stripSingleStatement(@NotNull TextFileFragment fragment) {
        Matcher m;
        if (fragment == null) {
            Scriptum.$$$reportNull$$$0(17);
        }
        if ((m = STRIP_SINGLE_STATEMENT_PATTERN.matcher(fragment.text)).find()) {
            int n = fragment.text.length();
            String text = Strings.rtrim(fragment.text.substring(0, n -= m.group(1).length()));
            return new TextFileFragment(text, fragment.getTextName(), fragment.row, fragment.pos, fragment.getFragmentName());
        }
        TextFileFragment textFileFragment = fragment;
        if (textFileFragment == null) {
            Scriptum.$$$reportNull$$$0(18);
        }
        return textFileFragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentScriptum";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/sql/Scriptum";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/sql/Scriptum";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dialectOf";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "listFragmentNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "listFragments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stripSingleStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dialectOf";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "query";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "command";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "script";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripSingleStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ScriptNotFoundException
    extends RuntimeException {
        private ScriptNotFoundException(String message) {
            super(message);
        }
    }
}

