/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.exceptions.OracleTimezoneRegionNotFoundException;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.OracleIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.pooling.SimpleDataSource;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;

public class OracleIntermediateFacade
extends JdbcIntermediateFacade {
    private Boolean myCompatibility1882;
    private static final String CONNECTION_INFO_QUERY = "select sys_context('userenv', 'db_name') as database_name,      \n       sys_context('userenv', 'current_schema') as schema_name, \n       user as user_name                                        \nfrom dual                                                       \n";

    public OracleIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(1);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    public synchronized void connect() {
        while (true) {
            try {
                super.connect();
            }
            catch (OracleTimezoneRegionNotFoundException otr) {
                if (this.myCompatibility1882 != null) break;
                Object originalDataSource = this.myPool.getOriginalDataSource();
                if (originalDataSource instanceof SimpleDataSource) {
                    SimpleDataSource sds = (SimpleDataSource)originalDataSource;
                    sds.setConnectionProperty("oracle.jdbc.timezoneAsRegion", "false");
                    this.myCompatibility1882 = Boolean.TRUE;
                    continue;
                }
                this.myCompatibility1882 = Boolean.FALSE;
            }
            break;
        }
    }

    @Override
    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            OracleIntermediateFacade.$$$reportNull$$$0(2);
        }
        return new OracleIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        return this.getConnectionInfoSmartly(CONNECTION_INFO_QUERY, SIMPLE_VERSION_PATTERN, 1, SIMPLE_VERSION_PATTERN, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/OracleIntermediateFacade";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "instantiateSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

