/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.MysqlIntermediateSession;
import com.intellij.database.remote.jdba.util.Version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class MysqlIntermediateFacade
extends JdbcIntermediateFacade {
    private byte myFetchStrategy;
    private static final String CONNECTION_INFO_QUERY = "select database(), schema(), left(user(),instr(concat(user(),'@'),'@')-1), @@version_comment";

    public MysqlIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            MysqlIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            MysqlIntermediateFacade.$$$reportNull$$$0(1);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
        this.myFetchStrategy = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        Version serverVersion = null;
        JdbcIntermediateSession session = this.openSession();
        try {
            String rdbmsName;
            String driverVersionStr;
            String serverVersionStr;
            String verComment;
            String[] env = session.queryOneRow(CONNECTION_INFO_QUERY, 4, String.class);
            String string = verComment = env == null ? null : env[3];
            if (verComment != null) {
                verComment = verComment.toLowerCase(Locale.ENGLISH);
            }
            if (env == null) {
                env = new String[]{null, null, null};
            }
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                serverVersionStr = md.getDatabaseProductVersion();
                driverVersionStr = md.getDriverVersion();
                rdbmsName = md.getDatabaseProductName();
                if (rdbmsName == null) {
                    rdbmsName = session.getConnection().getClass().getName();
                }
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
            if (rdbmsName.equals("MySQL")) {
                int pos = serverVersionStr.indexOf("MARIADB");
                if (pos != -1) {
                    serverVersion = MysqlIntermediateFacade.extractMariaVersionImpl(pos, serverVersionStr);
                    if (serverVersion != Version.ZERO) {
                        rdbmsName = "MARIADB";
                    } else {
                        serverVersion = null;
                    }
                } else if (verComment != null) {
                    if (verComment.startsWith("memsql")) {
                        rdbmsName = "MEMSQL";
                        String[] memVer = session.queryOneRow("select @@memsql_version", 1, String.class);
                        if (memVer != null && memVer[0] != null) {
                            serverVersion = MysqlIntermediateFacade.extractVersion(memVer[0], SIMPLE_VERSION_PATTERN, 1);
                        }
                    } else if (verComment.startsWith("mariadb")) {
                        rdbmsName = "MARIADB";
                    }
                }
            }
            if (serverVersion == null) {
                serverVersion = MysqlIntermediateFacade.extractVersion(serverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            }
            Version driverVersion = MysqlIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
            return connectionInfo;
        }
        finally {
            session.close();
        }
    }

    @NotNull
    private static Version extractMariaVersionImpl(int pos, String serverVersionStr) {
        Version serverVersion = MysqlIntermediateFacade.extractVersion(serverVersionStr.substring(0, pos), SIMPLE_VERSION_PATTERN, 1);
        if (serverVersion == Version.ZERO) {
            serverVersion = MysqlIntermediateFacade.extractVersion(serverVersionStr.substring(pos + "MARIADB".length()), SIMPLE_VERSION_PATTERN, 1);
        }
        Version version = serverVersion;
        if (version == null) {
            MysqlIntermediateFacade.$$$reportNull$$$0(2);
        }
        return version;
    }

    @NotNull
    public static Version parseServerVersion(String serverVersionStr) {
        int pos = serverVersionStr.indexOf("MARIADB");
        if (pos != -1) {
            return MysqlIntermediateFacade.extractMariaVersionImpl(pos, serverVersionStr);
        }
        Version version = MysqlIntermediateFacade.extractVersion(serverVersionStr, SIMPLE_VERSION_PATTERN, 1);
        if (version == null) {
            MysqlIntermediateFacade.$$$reportNull$$$0(3);
        }
        return version;
    }

    @Override
    @NotNull
    protected MysqlIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            MysqlIntermediateFacade.$$$reportNull$$$0(4);
        }
        return new MysqlIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    public byte getFetchStrategy() {
        return this.myFetchStrategy;
    }

    public void setFetchStrategy(byte fetchStrategy) {
        this.myFetchStrategy = fetchStrategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/dialects/MysqlIntermediateFacade";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/MysqlIntermediateFacade";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMariaVersionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseServerVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

