/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinLexer;
import org.jetbrains.plugins.cucumber.psi.GherkinParser;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCellImpl;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureHeaderImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPystringImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinRuleImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepParameterImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTagImpl;

public class GherkinParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITESPACE = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        return new GherkinLexer(JsonGherkinKeywordProvider.getKeywordProvider(true));
    }

    public PsiParser createParser(Project project) {
        return new GherkinParser();
    }

    public IFileElementType getFileNodeType() {
        return GherkinElementTypes.GHERKIN_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITESPACE;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENTS;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            GherkinParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() == GherkinElementTypes.FEATURE) {
            return new GherkinFeatureImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.FEATURE_HEADER) {
            return new GherkinFeatureHeaderImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO) {
            return new GherkinScenarioImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.STEP) {
            return new GherkinStepImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO_OUTLINE) {
            return new GherkinScenarioOutlineImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.RULE) {
            return new GherkinRuleImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.EXAMPLES_BLOCK) {
            return new GherkinExamplesBlockImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE) {
            return new GherkinTableImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_ROW) {
            return new GherkinTableRowImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_CELL) {
            return new GherkinTableCellImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_HEADER_ROW) {
            return new GherkinTableHeaderRowImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.TAG) {
            return new GherkinTagImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.STEP_PARAMETER) {
            return new GherkinStepParameterImpl(node);
        }
        if (node.getElementType() == GherkinElementTypes.PYSTRING) {
            return new GherkinPystringImpl(node);
        }
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            GherkinParserDefinition.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new GherkinFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        IElementType leftElementType = left.getElementType();
        if (leftElementType == GherkinTokenTypes.COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (right.getElementType() == GherkinTokenTypes.EXAMPLES_KEYWORD) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

