/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.nodeJs.NodeConsoleInspectorMessagesFilter;
import com.jetbrains.nodeJs.NodeConsoleInspectorMessagesFilterKt;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\rH\u0002J<\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\b\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/nodeJs/NodeConsoleInspectorMessagesFilter;", "Ljava/util/function/UnaryOperator;", "", "()V", "skipDebuggerListeningMessages", "Ljava/util/concurrent/atomic/AtomicInteger;", "skipInspectorHelpMessages", "apply", "text", "getAndDecrementIfPositive", "", "value", "prefixMatches", "", "line", "", "startIndex", "prefix", "checkOnlyFirstLetter", "skipToEndOfLine", "", "i", "lines", "", "Lcom/intellij/openapi/util/TextRange;", "excludeRanges", "", "startIndexInLine", "intellij.javascript.chrome.connector"})
public final class NodeConsoleInspectorMessagesFilter
implements UnaryOperator<String> {
    private final AtomicInteger skipInspectorHelpMessages = new AtomicInteger(0);
    private final AtomicInteger skipDebuggerListeningMessages = new AtomicInteger(0);

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String apply(@Nullable String text) {
        if (text == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(text);
        List list = StringUtil.getWordIndicesIn((String)text, Collections.singleton(Character.valueOf('\n')));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"StringUtil.getWordIndice\u2026lections.singleton('\\n'))");
        List lines = list;
        List excludeRanges = (List)new SmartList();
        boolean bl = false;
        Iterator iterator = ((Iterable)lines).iterator();
        while (iterator.hasNext()) {
            void i;
            TextRange lineRange;
            TextRange textRange = lineRange = (TextRange)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"lineRange");
            CharBuffer charBuffer2 = charBuffer.subSequence(textRange.getStartOffset(), lineRange.getEndOffset());
            Intrinsics.checkExpressionValueIsNotNull((Object)charBuffer2, (String)"charBuffer.subSequence(l\u2026set, lineRange.endOffset)");
            CharSequence line = charBuffer2;
            int startIndexInLine = StringsKt.indexOfAny$default((CharSequence)line, (Collection)NodeConsoleInspectorMessagesFilterKt.access$getPREFIXES$p(), (int)0, (boolean)false, (int)6, null);
            if (startIndexInLine != -1) {
                boolean skipPrefixMatched = false;
                if (line.charAt(startIndexInLine) == "[IntelliJ is searching for port] ".charAt(0)) {
                    TextRange textRange2 = TextRange.from((int)startIndexInLine, (int)"[IntelliJ is searching for port] ".length());
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"TextRange.from(startInde\u2026Line, SKIP_PREFIX.length)");
                    excludeRanges.add(textRange2);
                    startIndexInLine += "[IntelliJ is searching for port] ".length();
                    this.skipInspectorHelpMessages.incrementAndGet();
                    this.skipDebuggerListeningMessages.incrementAndGet();
                    skipPrefixMatched = true;
                }
                if (this.prefixMatches(line, startIndexInLine, "Debugger listening on", !skipPrefixMatched) && this.getAndDecrementIfPositive(this.skipDebuggerListeningMessages) > 0) {
                    this.skipToEndOfLine((int)i, lines, text, excludeRanges, startIndexInLine);
                } else if (this.prefixMatches(line, startIndexInLine, "For help", !skipPrefixMatched) && StringsKt.contains$default((CharSequence)line, (CharSequence)"https://nodejs.org/en/docs/inspector", (boolean)false, (int)2, null) && this.getAndDecrementIfPositive(this.skipInspectorHelpMessages) > 0) {
                    this.skipToEndOfLine((int)i, lines, text, excludeRanges, startIndexInLine);
                }
            }
            ++i;
        }
        if (excludeRanges.isEmpty()) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int prevRangeEndOffset = 0;
        for (TextRange excludeRange : excludeRanges) {
            result.append(charBuffer.subSequence(prevRangeEndOffset, excludeRange.getStartOffset()));
            prevRangeEndOffset = excludeRange.getEndOffset();
        }
        result.append(charBuffer.subSequence(prevRangeEndOffset, text.length()));
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean prefixMatches(CharSequence line, int startIndex, String prefix, boolean checkOnlyFirstLetter) {
        if (startIndex >= line.length()) return false;
        if (checkOnlyFirstLetter) {
            if (line.charAt(startIndex) != prefix.charAt(0)) return false;
            return true;
        }
        boolean bl = StringsKt.startsWith$default((CharSequence)line, (CharSequence)prefix, (int)startIndex, (boolean)false, (int)4, null);
        if (!bl) return false;
        return true;
    }

    private final void skipToEndOfLine(int i, List<? extends TextRange> lines, String text, List<TextRange> excludeRanges, int startIndexInLine) {
        int endIndex = i < lines.size() - 1 ? lines.get(i + 1).getStartOffset() : text.length();
        TextRange textRange = TextRange.create((int)(lines.get(i).getStartOffset() + startIndexInLine), (int)endIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"TextRange.create(lines[i\u2026artIndexInLine, endIndex)");
        excludeRanges.add(textRange);
    }

    private final int getAndDecrementIfPositive(AtomicInteger value) {
        return value.getAndUpdate(getAndDecrementIfPositive.1.INSTANCE);
    }
}

