/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.WipConsoleAPICalled$WhenMappings;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J,\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/debugger/wip/WipConsoleAPICalled;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;Lorg/jetbrains/wip/WipVm;)V", "hasFormat", "", "remoteObjectValue", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "isSpecifier", "c", "", "print", "", "printer", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "printFormatted", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printParameters", "startFrom", "", "xmlView", "intellij.javascript.chrome.connector"})
public final class WipConsoleAPICalled
implements ConsoleMessage {
    private final ConsoleAPICalledEventData message;
    private final WipVm vm;

    public void print(@NotNull ConsoleMessageBuilder printer) {
        CallFrameValue callFrame;
        ConsoleViewContentType contentType;
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        StackTraceValue stackTrace = this.message.getStackTrace();
        switch (WipConsoleAPICalled$WhenMappings.$EnumSwitchMapping$0[this.message.type().ordinal()]) {
            case 1: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                break;
            }
            case 2: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_WARNING_OUTPUT;
                break;
            }
            case 3: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_INFO_OUTPUT;
                break;
            }
            case 4: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                break;
            }
            default: {
                ConsoleViewContentType consoleViewContentType = contentType = ConsoleViewContentType.NORMAL_OUTPUT;
            }
        }
        if (this.message.type() == ConsoleAPICalledEventData.EventType.END_GROUP) {
            printer.groupEnd();
            return;
        }
        ConsoleViewContentType consoleViewContentType = contentType;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
        ConsoleMessageBuilder.startMessage$default((ConsoleMessageBuilder)printer, (ConsoleViewContentType)consoleViewContentType, null, (int)2, null);
        Object object = stackTrace;
        CallFrameValue callFrameValue = object != null && (object = object.callFrames()) != null ? (CallFrameValue)CollectionsKt.firstOrNull((List)object) : (callFrame = null);
        if (callFrame != null) {
            CharSequence charSequence = callFrame.url();
            boolean bl = false;
            if (!(charSequence.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)callFrame.url(), (int)callFrame.getLineNumber(), (int)callFrame.getColumnNumber(), (String)callFrame.functionName(), (boolean)true, null, (int)32, null);
            }
        }
        switch (WipConsoleAPICalled$WhenMappings.$EnumSwitchMapping$1[this.message.type().ordinal()]) {
            case 1: 
            case 2: {
                String string;
                RemoteObjectValue remoteObjectValue = this.message.args().get(0);
                if (remoteObjectValue.type() == RemoteObjectValue.Type.STRING) {
                    Object object2 = remoteObjectValue.value();
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)object2;
                } else {
                    string = remoteObjectValue.getDescription();
                    if (string == null) {
                        string = "console.group()";
                    }
                }
                String groupName = string;
                printer.groupStart(groupName, this.message.type() == ConsoleAPICalledEventData.EventType.START_GROUP_COLLAPSED);
                break;
            }
            case 3: 
            case 4: {
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, this.message.type() != ConsoleAPICalledEventData.EventType.DIR, 4, null);
                break;
            }
            case 5: {
                printer.clear();
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.getConsoleViewType((Key)ConsolePrinter.Companion.getCONSOLE_INFO_KEY());
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.g\u2026Printer.CONSOLE_INFO_KEY)");
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"Console was cleared", (ConsoleViewContentType)consoleViewContentType2, null, (int)4, null);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, false, 12, null);
                printer.printStackTrace(contentType, stackTrace);
                break;
            }
            case 9: {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"Assertion failed: ", (ConsoleViewContentType)contentType, null, (int)4, null);
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, false, 12, null);
                break;
            }
            default: {
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, false, 12, null);
            }
        }
        printer.endMessage();
    }

    /*
     * WARNING - void declaration
     */
    private final void printParameters(ConsoleMessageBuilder printer, ConsoleViewContentType contentType, int startFrom, boolean xmlView) {
        if (startFrom == 0 && this.message.args().size() > 1 && this.hasFormat(this.message.args().get(0))) {
            this.printFormatted(printer, contentType);
            return;
        }
        int n = startFrom;
        int n2 = this.message.args().size();
        while (n < n2) {
            void i;
            RemoteObjectValue objectValue = this.message.args().get((int)i);
            if (i != false) {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)" ", (ConsoleViewContentType)contentType, null, (int)4, null);
            }
            CharSequence charSequence = objectValue.getObjectId();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                EvaluateContext evaluateContext2 = this.vm.getEvaluateContext();
                if (evaluateContext2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
                }
                ValueManager valueManager = ((EvaluateContextBase)evaluateContext2).getValueManager();
                if (valueManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
                }
                WipValueManager valueManager2 = (WipValueManager)valueManager;
                Value value = valueManager2.createValue(objectValue);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                printer.printAndStoreValueToInspect(value, null, contentType, xmlView);
            } else if (objectValue.value() != null) {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)String.valueOf(objectValue.value()), (ConsoleViewContentType)contentType, null, (int)4, null);
            } else if (!StringUtil.isEmpty((String)objectValue.getDescription())) {
                String string = objectValue.getDescription();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)string, (ConsoleViewContentType)contentType, null, (int)4, null);
            } else if (Intrinsics.areEqual((Object)objectValue.type().name(), (Object)"UNDEFINED")) {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getKEYWORD_KEY());
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026ctionHandler.KEYWORD_KEY)");
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"undefined", (ConsoleViewContentType)consoleViewContentType, null, (int)4, null);
            }
            ++i;
        }
    }

    static /* synthetic */ void printParameters$default(WipConsoleAPICalled wipConsoleAPICalled, ConsoleMessageBuilder consoleMessageBuilder, ConsoleViewContentType consoleViewContentType, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        wipConsoleAPICalled.printParameters(consoleMessageBuilder, consoleViewContentType, n, bl);
    }

    private final void printFormatted(ConsoleMessageBuilder printer, ConsoleViewContentType contentType) {
        String string;
        ConsoleMessageBuilder consoleMessageBuilder;
        String string2;
        String formatString = String.valueOf(this.message.args().get(0).value());
        int currentArgument = 1;
        int currentIndex = 0;
        int lastIndex = 0;
        String style = null;
        while (currentIndex + 1 < formatString.length() && currentArgument < this.message.args().size()) {
            while (!(currentIndex + 1 >= formatString.length() || formatString.charAt(currentIndex) == '%' && this.isSpecifier(formatString.charAt(currentIndex + 1)))) {
                ++currentIndex;
            }
            if (currentIndex + 1 == formatString.length()) break;
            string2 = formatString;
            consoleMessageBuilder = printer;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(lastIndex, currentIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            consoleMessageBuilder.append(string, contentType, style);
            RemoteObjectValue argument = this.message.args().get(currentArgument);
            switch (formatString.charAt(currentIndex + 1)) {
                case 's': {
                    String string4 = argument.getDescription();
                    if (string4 == null) {
                        string4 = String.valueOf(argument.value());
                    }
                    String text = string4;
                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)text, null, (String)style, (int)2, null);
                    ++currentArgument;
                    break;
                }
                case 'd': 
                case 'i': {
                    ConsoleViewContentType numberContentType;
                    String string5;
                    String string6 = argument.getDescription();
                    if (string6 == null) {
                        string6 = String.valueOf(argument.value());
                    }
                    String text = string6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ConsoleViewContentType.getConsoleViewType((Key)JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getNUMBER_KEY()), (String)"ConsoleViewContentType.g\u2026nsoleViewType(NUMBER_KEY)");
                    try {
                        string5 = String.valueOf(Integer.parseInt(text, 10));
                    }
                    catch (Exception e) {
                        string5 = "NaN";
                    }
                    String num = string5;
                    printer.append(num, numberContentType, style);
                    ++currentArgument;
                    break;
                }
                case 'f': {
                    ConsoleViewContentType numberContentType;
                    String string5;
                    String string7 = argument.getDescription();
                    if (string7 == null) {
                        string7 = String.valueOf(argument.value());
                    }
                    String text = string7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ConsoleViewContentType.getConsoleViewType((Key)JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getNUMBER_KEY()), (String)"ConsoleViewContentType.g\u2026nsoleViewType(NUMBER_KEY)");
                    try {
                        string5 = String.valueOf(Float.parseFloat(text));
                    }
                    catch (Exception e) {
                        string5 = "NaN";
                    }
                    String num = string5;
                    printer.append(num, numberContentType, style);
                    ++currentArgument;
                    break;
                }
                case 'O': 
                case 'o': {
                    EvaluateContext evaluateContext2 = this.vm.getEvaluateContext();
                    if (evaluateContext2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
                    }
                    ValueManager valueManager = ((EvaluateContextBase)evaluateContext2).getValueManager();
                    if (valueManager == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
                    }
                    WipValueManager valueManager2 = (WipValueManager)valueManager;
                    Value value = valueManager2.createValue(argument);
                    if (value != null) {
                        printer.printAndStoreValueToInspect(value, null, contentType, false);
                    } else {
                        String string8 = argument.getDescription();
                        if (string8 == null) {
                            string8 = String.valueOf(argument.value());
                        }
                        String text = string8;
                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)text, null, (String)style, (int)2, null);
                    }
                    ++currentArgument;
                    break;
                }
                case 'c': {
                    style = String.valueOf(argument.value());
                    ++currentArgument;
                    break;
                }
                default: {
                    String string9 = formatString;
                    int n = currentIndex + 2;
                    consoleMessageBuilder = printer;
                    boolean bl2 = false;
                    String string10 = string9;
                    if (string10 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string11 = string10.substring(currentIndex, n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = string11;
                    consoleMessageBuilder.append(string, contentType, style);
                }
            }
            lastIndex = currentIndex + 2;
            currentIndex += 2;
        }
        string2 = formatString;
        int n = formatString.length();
        consoleMessageBuilder = printer;
        boolean bl = false;
        String string12 = string2;
        if (string12 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string13 = string12.substring(lastIndex, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string13;
        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)consoleMessageBuilder, (String)string, null, (String)style, (int)2, null);
        WipConsoleAPICalled.printParameters$default(this, printer, contentType, currentArgument, false, 8, null);
    }

    private final boolean isSpecifier(char c) {
        return c == 's' || c == 'f' || c == 'i' || c == 'd' || c == 'o' || c == 'O' || c == 'c';
    }

    private final boolean hasFormat(RemoteObjectValue remoteObjectValue) {
        if (remoteObjectValue.type() != RemoteObjectValue.Type.STRING) {
            return false;
        }
        String s = String.valueOf(remoteObjectValue.value());
        return StringsKt.contains$default((CharSequence)s, (CharSequence)"%s", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%f", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%i", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%d", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%o", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%O", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%c", (boolean)false, (int)2, null);
    }

    public WipConsoleAPICalled(@NotNull ConsoleAPICalledEventData message, @NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.message = message;
        this.vm = vm;
    }
}

