/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogCommitDetailsListPanel
extends CommitDetailsListPanel<CommitPanel>
implements Disposable {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private List<Integer> mySelection;
    @Nullable
    private ProgressIndicator myResolveIndicator;

    public VcsLogCommitDetailsListPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Disposable parent) {
        if (logData == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(2);
        }
        super(parent);
        this.mySelection = ContainerUtil.emptyList();
        this.myResolveIndicator = null;
        this.myLogData = logData;
        this.myColorManager = colorManager;
        logData.getProject().getMessageBus().connect((Disposable)this).subscribe(CommitMessageInspectionProfile.TOPIC, () -> this.update());
        this.setStatusText(VcsLogBundle.message((String)"vcs.log.commit.details.status", (Object[])new Object[0]));
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void installCommitSelectionListener(@NotNull VcsLogGraphTable graphTable) {
        if (graphTable == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(3);
        }
        graphTable.getSelectionModel().addListSelectionListener(new CommitSelectionListenerForDetails(graphTable));
    }

    public void branchesChanged() {
        this.forEachPanelIndexed((i, panel2) -> {
            panel2.updateBranches();
            return Unit.INSTANCE;
        });
    }

    private void resolveHashes(@NotNull List<? extends CommitId> ids, @NotNull List<? extends CommitPresentationUtil.CommitPresentation> presentations, @NotNull Set<String> unResolvedHashes, @NotNull Condition<Object> expired) {
        if (ids == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(4);
        }
        if (presentations == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(5);
        }
        if (unResolvedHashes == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(6);
        }
        if (expired == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(7);
        }
        if (!unResolvedHashes.isEmpty()) {
            this.myResolveIndicator = BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
                MultiMap resolvedHashes = MultiMap.createSmart();
                HashSet fullHashes = new HashSet(ContainerUtil.filter((Collection)unResolvedHashes, h -> h.length() == 40));
                for (String fullHash : fullHashes) {
                    Hash hash = HashImpl.build(fullHash);
                    for (VirtualFile root : this.myLogData.getRoots()) {
                        CommitId id = new CommitId(hash, root);
                        if (!this.myLogData.getStorage().containsCommit(id)) continue;
                        resolvedHashes.putValue((Object)fullHash, (Object)id);
                    }
                }
                unResolvedHashes.removeAll(fullHashes);
                if (!unResolvedHashes.isEmpty()) {
                    this.myLogData.getStorage().iterateCommits((Function<? super CommitId, Boolean>)((Function)commitId -> {
                        for (String hashString : unResolvedHashes) {
                            if (!StringUtil.startsWithIgnoreCase((String)commitId.getHash().asString(), (String)hashString)) continue;
                            resolvedHashes.putValue((Object)hashString, commitId);
                        }
                        return false;
                    }));
                }
                List resolvedPresentations = ContainerUtil.map2List((Collection)presentations, presentation -> presentation.resolve((MultiMap<String, CommitId>)resolvedHashes));
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myResolveIndicator = null;
                    this.setPresentations(ids, resolvedPresentations);
                }, Conditions.or(o -> this.myResolveIndicator != indicator, (Condition)expired));
            });
        }
    }

    private void cancelResolve() {
        if (this.myResolveIndicator != null) {
            this.myResolveIndicator.cancel();
            this.myResolveIndicator = null;
        }
    }

    private void setPresentations(@NotNull List<? extends CommitId> ids, @NotNull List<? extends CommitPresentationUtil.CommitPresentation> presentations) {
        if (ids == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(8);
        }
        if (presentations == null) {
            VcsLogCommitDetailsListPanel.$$$reportNull$$$0(9);
        }
        this.forEachPanelIndexed((i, panel2) -> {
            panel2.setCommit((CommitId)ids.get((int)i), (CommitPresentationUtil.CommitPresentation)presentations.get((int)i));
            return Unit.INSTANCE;
        });
    }

    public void dispose() {
        this.cancelResolve();
    }

    @Override
    @NotNull
    protected CommitPanel getCommitDetailsPanel() {
        return new CommitPanel(this.myLogData, this.myColorManager, (Consumer<? super CommitId>)((Consumer)this::navigate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphTable";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unResolvedHashes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogCommitDetailsListPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installCommitSelectionListener";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveHashes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setPresentations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CommitSelectionListenerForDetails
    extends CommitSelectionListener<VcsCommitMetadata> {
        CommitSelectionListenerForDetails(VcsLogGraphTable graphTable) {
            super(graphTable, VcsLogCommitDetailsListPanel.this.myLogData.getMiniDetailsGetter());
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<? extends VcsCommitMetadata> detailsList) {
            if (detailsList == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(0);
            }
            List ids = ContainerUtil.map(detailsList, detail -> new CommitId((Hash)detail.getId(), detail.getRoot()));
            HashSet unResolvedHashes = new HashSet();
            List presentations = ContainerUtil.map(detailsList, detail -> CommitPresentationUtil.buildPresentation(VcsLogCommitDetailsListPanel.this.myLogData.getProject(), detail, unResolvedHashes));
            VcsLogCommitDetailsListPanel.this.setPresentations(ids, presentations);
            List currentSelection = VcsLogCommitDetailsListPanel.this.mySelection;
            VcsLogCommitDetailsListPanel.this.resolveHashes(ids, presentations, unResolvedHashes, (Condition<Object>)o -> currentSelection != VcsLogCommitDetailsListPanel.this.mySelection);
        }

        @Override
        protected void onSelection(int @NotNull [] selection) {
            if (selection == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(1);
            }
            VcsLogCommitDetailsListPanel.this.cancelResolve();
            int shownPanelsCount = VcsLogCommitDetailsListPanel.this.rebuildPanel(selection.length);
            VcsLogCommitDetailsListPanel.this.mySelection = Ints.asList((int[])Arrays.copyOf(selection, shownPanelsCount));
            List currentSelection = VcsLogCommitDetailsListPanel.this.mySelection;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                ArrayList<List<VcsRef>> result2 = new ArrayList<List<VcsRef>>();
                for (Integer row2 : currentSelection) {
                    result2.add(this.myGraphTable.getModel().getRefsAtRow(row2));
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (currentSelection == VcsLogCommitDetailsListPanel.this.mySelection) {
                        VcsLogCommitDetailsListPanel.this.forEachPanelIndexed((i, panel2) -> {
                            panel2.setRefs((Collection)result2.get((int)i));
                            return Unit.INSTANCE;
                        });
                    }
                });
            });
        }

        @Override
        protected void onEmptySelection() {
            VcsLogCommitDetailsListPanel.this.cancelResolve();
            this.setEmpty(VcsLogBundle.message((String)"vcs.log.changes.details.no.commits.selected.status", (Object[])new Object[0]));
        }

        @Override
        @NotNull
        protected List<Integer> getSelectionToLoad() {
            List list = VcsLogCommitDetailsListPanel.this.mySelection;
            if (list == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        protected void startLoading() {
            VcsLogCommitDetailsListPanel.this.startLoadingDetails();
        }

        @Override
        protected void stopLoading() {
            VcsLogCommitDetailsListPanel.this.stopLoadingDetails();
        }

        @Override
        protected void onError(@NotNull Throwable error) {
            if (error == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(3);
            }
            this.setEmpty(VcsLogBundle.message((String)"vcs.log.error.loading.status", (Object[])new Object[0]));
        }

        private void setEmpty(@Nls @NotNull String text2) {
            if (text2 == null) {
                CommitSelectionListenerForDetails.$$$reportNull$$$0(4);
            }
            VcsLogCommitDetailsListPanel.this.setStatusText(text2);
            VcsLogCommitDetailsListPanel.this.mySelection = ContainerUtil.emptyList();
            VcsLogCommitDetailsListPanel.this.setCommits(ContainerUtil.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogCommitDetailsListPanel$CommitSelectionListenerForDetails";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogCommitDetailsListPanel$CommitSelectionListenerForDetails";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectionToLoad";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "onDetailsLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "onSelection";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onError";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setEmpty";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

