/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.util.Function;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreatePatchFromHistoryActionProvider
implements AnActionExtensionProvider {
    private final boolean mySilentClipboard;

    private CreatePatchFromHistoryActionProvider(boolean silentClipboard) {
        this.mySilentClipboard = silentClipboard;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromHistoryActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromHistoryActionProvider.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        FileHistoryUi ui2 = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        if (project == null || ui2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        List selectedCommits = ui2.getVcsLog().getSelectedCommits();
        String commitMessage2 = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        e.getPresentation().setEnabled(!selectedCommits.isEmpty() && commitMessage2 != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromHistoryActionProvider.$$$reportNull$$$0(2);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileHistoryUi ui2 = (FileHistoryUi)e.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        String commitMessage2 = (String)e.getRequiredData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        ui2.getVcsLog().requestSelectedDetails(detailsList -> {
            List<Change> changes = VcsLogUtil.collectChanges(detailsList, (Function<? super VcsFullCommitDetails, ? extends Collection<Change>>)((Function)VcsFullCommitDetails::getChanges));
            CreatePatchFromChangesAction.createPatch(project, commitMessage2, changes, this.mySilentClipboard);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryActionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Clipboard
    extends CreatePatchFromHistoryActionProvider {
        public Clipboard() {
            super(true);
        }
    }

    public static class Dialog
    extends CreatePatchFromHistoryActionProvider {
        public Dialog() {
            super(false);
        }
    }
}

