/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.actions.TextFieldWithProgress;
import com.intellij.vcs.log.ui.actions.VcsRefCompletionProvider;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcsUtil.VcsImplUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToHashOrRefPopup {
    private static final Logger LOG = Logger.getInstance(GoToHashOrRefPopup.class);
    @NotNull
    private final TextFieldWithProgress myTextField;
    @NotNull
    private final Function<? super String, ? extends Future> myOnSelectedHash;
    @NotNull
    private final Function<? super VcsRef, ? extends Future> myOnSelectedRef;
    @NotNull
    private final JBPopup myPopup;
    @Nullable
    private Future myFuture;
    @Nullable
    private VcsRef mySelectedRef;

    public GoToHashOrRefPopup(@NotNull Project project, @NotNull VcsLogRefs variants, @NotNull Collection<? extends VirtualFile> roots, @NotNull Function<? super String, ? extends Future> onSelectedHash, @NotNull Function<? super VcsRef, ? extends Future> onSelectedRef, @NotNull VcsLogColorManager colorManager, @NotNull Comparator<? super VcsRef> comparator) {
        if (project == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(0);
        }
        if (variants == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(2);
        }
        if (onSelectedHash == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(3);
        }
        if (onSelectedRef == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(4);
        }
        if (colorManager == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(5);
        }
        if (comparator == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(6);
        }
        this.myOnSelectedHash = onSelectedHash;
        this.myOnSelectedRef = onSelectedRef;
        VcsRefDescriptor vcsRefDescriptor = new VcsRefDescriptor(project, colorManager, comparator, roots);
        VcsRefCompletionProvider completionProvider = new VcsRefCompletionProvider(variants, roots, (TextCompletionValueDescriptor<VcsRef>)vcsRefDescriptor);
        this.myTextField = new TextFieldWithProgress(project, (TextCompletionProvider)completionProvider){

            @Override
            public void onOk() {
                if (GoToHashOrRefPopup.this.myFuture == null) {
                    Future future2 = GoToHashOrRefPopup.this.mySelectedRef == null || !GoToHashOrRefPopup.this.mySelectedRef.getName().equals(this.getText().trim()) ? (Future)GoToHashOrRefPopup.this.myOnSelectedHash.fun((Object)this.getText().trim()) : (Future)GoToHashOrRefPopup.this.myOnSelectedRef.fun((Object)GoToHashOrRefPopup.this.mySelectedRef);
                    GoToHashOrRefPopup.this.myFuture = future2;
                    this.showProgress();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            future2.get();
                            GoToHashOrRefPopup.this.okPopup();
                        }
                        catch (InterruptedException | CancellationException ex) {
                            GoToHashOrRefPopup.this.cancelPopup();
                        }
                        catch (ExecutionException ex) {
                            LOG.error((Throwable)ex);
                            GoToHashOrRefPopup.this.cancelPopup();
                        }
                    });
                }
            }
        };
        this.myTextField.setAlignmentX(0.0f);
        this.myTextField.setBorder(JBUI.Borders.empty((int)3));
        JBLabel label = new JBLabel(VcsLogBundle.message((String)"vcs.log.go.to.hash.popup.label", (Object[])new Object[0]));
        label.setFont(UIUtil.getLabelFont().deriveFont(1));
        label.setAlignmentX(0.0f);
        JPanel panel2 = new JPanel();
        BoxLayout layout = new BoxLayout(panel2, 3);
        panel2.setLayout(layout);
        panel2.add((Component)label);
        panel2.add(this.myTextField);
        panel2.setBorder(JBUI.Borders.empty((int)2));
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, this.myTextField.getPreferableFocusComponent()).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(true).setRequestFocus(true).createPopup();
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!event.isOk() && GoToHashOrRefPopup.this.myFuture != null) {
                    GoToHashOrRefPopup.this.myFuture.cancel(true);
                }
                GoToHashOrRefPopup.this.myFuture = null;
                GoToHashOrRefPopup.this.myTextField.hideProgress();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$2", "onClosed"));
            }
        });
    }

    private void cancelPopup() {
        ApplicationManager.getApplication().invokeLater(() -> this.myPopup.cancel());
    }

    private void okPopup() {
        ApplicationManager.getApplication().invokeLater(() -> this.myPopup.closeOk(null));
    }

    public void show(@NotNull JComponent anchor) {
        if (anchor == null) {
            GoToHashOrRefPopup.$$$reportNull$$$0(7);
        }
        this.myPopup.showInCenterOf((Component)anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelectedHash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelectedRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class VcsRefDescriptor
    extends DefaultTextCompletionValueDescriptor<VcsRef> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsLogColorManager myColorManager;
        @NotNull
        private final Comparator<? super VcsRef> myReferenceComparator;
        @NotNull
        private final Map<VirtualFile, String> myCachedRootNames;

        private VcsRefDescriptor(@NotNull Project project, @NotNull VcsLogColorManager manager, @NotNull Comparator<? super VcsRef> comparator, Collection<? extends VirtualFile> roots) {
            if (project == null) {
                VcsRefDescriptor.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                VcsRefDescriptor.$$$reportNull$$$0(1);
            }
            if (comparator == null) {
                VcsRefDescriptor.$$$reportNull$$$0(2);
            }
            if (roots == null) {
                VcsRefDescriptor.$$$reportNull$$$0(3);
            }
            this.myCachedRootNames = new HashMap<VirtualFile, String>();
            this.myProject = project;
            this.myColorManager = manager;
            this.myReferenceComparator = comparator;
            for (VirtualFile virtualFile : roots) {
                String text2 = VcsImplUtil.getShortVcsRootName(this.myProject, virtualFile);
                this.myCachedRootNames.put(virtualFile, text2);
            }
        }

        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(4);
            }
            LookupElementBuilder lookupBuilder = super.createLookupBuilder((Object)item);
            if (this.myColorManager.hasMultiplePaths()) {
                ColorIcon icon = (ColorIcon)JBUI.scale((JBUI.JBIcon)new ColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(item.getRoot(), this.myColorManager)));
                lookupBuilder = lookupBuilder.withTypeText(this.getTypeText(item), (Icon)icon, true).withTypeIconRightAligned(true);
            }
            LookupElementBuilder lookupElementBuilder = lookupBuilder;
            if (lookupElementBuilder == null) {
                VcsRefDescriptor.$$$reportNull$$$0(5);
            }
            return lookupElementBuilder;
        }

        @NotNull
        public String getLookupString(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(6);
            }
            String string = item.getName();
            if (string == null) {
                VcsRefDescriptor.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(8);
            }
            if (!this.myColorManager.hasMultiplePaths()) {
                return null;
            }
            return "";
        }

        @Nullable
        protected String getTypeText(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(9);
            }
            if (!this.myColorManager.hasMultiplePaths()) {
                return null;
            }
            String text2 = this.myCachedRootNames.get(item.getRoot());
            if (text2 == null) {
                return VcsImplUtil.getShortVcsRootName(this.myProject, item.getRoot());
            }
            return text2;
        }

        public int compare(VcsRef item1, VcsRef item2) {
            return this.myReferenceComparator.compare((VcsRef)item1, (VcsRef)item2);
        }

        @Nullable
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(10);
            }
            return (context, item1) -> {
                GoToHashOrRefPopup.this.mySelectedRef = (VcsRef)item1.getObject();
                ApplicationManager.getApplication().invokeLater(() -> GoToHashOrRefPopup.this.myTextField.onOk());
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/actions/GoToHashOrRefPopup$VcsRefDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupBuilder";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupBuilder";
                    break;
                }
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createInsertHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

