/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcs.log.impl.VcsFileStatusInfoMerger;
import com.intellij.vcs.log.impl.VcsStatusMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class VcsChangesLazilyParsedDetails
extends VcsCommitMetadataImpl
implements VcsFullCommitDetails {
    private static final Logger LOG = Logger.getInstance(VcsChangesLazilyParsedDetails.class);
    protected static final Changes EMPTY_CHANGES = new EmptyChanges();
    @NotNull
    private final ChangesParser myChangesParser;
    @NotNull
    private final AtomicReference<Changes> myChanges;

    /*
     * WARNING - void declaration
     */
    public VcsChangesLazilyParsedDetails(@NotNull Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<List<VcsFileStatusInfo>> list, @NotNull ChangesParser changesParser) {
        void reportedChanges;
        void changesParser2;
        if (project == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(0);
        }
        if (hash == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(1);
        }
        if (parents == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(2);
        }
        if (root == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(3);
        }
        if (subject == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(4);
        }
        if (author == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(5);
        }
        if (message == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(6);
        }
        if (committer == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(7);
        }
        if (list == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(8);
        }
        if (changesParser == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(9);
        }
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime);
        this.myChanges = new AtomicReference();
        this.myChangesParser = changesParser2;
        this.myChanges.set(reportedChanges.isEmpty() ? EMPTY_CHANGES : new UnparsedChanges(project, (List<List<VcsFileStatusInfo>>)reportedChanges, (sources, parent) -> this.myChangesParser.parseStatusInfo(project, this, (List<VcsFileStatusInfo>)sources, (int)parent)));
    }

    @NotNull
    public Collection<Change> getChanges() {
        Collection<Change> collection = this.myChanges.get().getMergedChanges();
        if (collection == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public Collection<Change> getChanges(int parent) {
        Collection<Change> collection = this.myChanges.get().getChanges(parent);
        if (collection == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(11);
        }
        return collection;
    }

    public int size() {
        return this.myChanges.get().size();
    }

    @NotNull
    protected Changes getChangesObject() {
        Changes changes = this.myChanges.get();
        if (changes == null) {
            VcsChangesLazilyParsedDetails.$$$reportNull$$$0(12);
        }
        return changes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedChanges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesParser";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChangesParser {
        public List<Change> parseStatusInfo(@NotNull Project var1, @NotNull VcsShortCommitDetails var2, @NotNull List<VcsFileStatusInfo> var3, int var4);
    }

    protected static class ParsedChanges
    implements Changes {
        @NotNull
        private final Collection<Change> myMergedChanges;
        @NotNull
        private final List<? extends Collection<Change>> myChanges;

        ParsedChanges(@NotNull Collection<Change> mergedChanges, @NotNull List<? extends Collection<Change>> changes) {
            if (mergedChanges == null) {
                ParsedChanges.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                ParsedChanges.$$$reportNull$$$0(1);
            }
            this.myMergedChanges = mergedChanges;
            this.myChanges = changes;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            Collection<Change> collection = this.myMergedChanges;
            if (collection == null) {
                ParsedChanges.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            Collection<Change> collection = this.myChanges.get(parent);
            if (collection == null) {
                ParsedChanges.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Override
        public int size() {
            int size = 0;
            for (Collection<Change> collection : this.myChanges) {
                size += collection.size();
            }
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergedChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$ParsedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$ParsedChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedChanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyMergedChange
    extends MergedChange {
        @NotNull
        private final Supplier<List<Change>> mySourceChanges;

        MyMergedChange(@NotNull Change change, @NotNull VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> statusInfo, @NotNull BiFunction<List<VcsFileStatusInfo>, Integer, List<Change>> parser) {
            if (change == null) {
                MyMergedChange.$$$reportNull$$$0(0);
            }
            if (statusInfo == null) {
                MyMergedChange.$$$reportNull$$$0(1);
            }
            if (parser == null) {
                MyMergedChange.$$$reportNull$$$0(2);
            }
            super(change);
            this.mySourceChanges = Suppliers.memoize(() -> {
                ArrayList sourceChanges = new ArrayList();
                for (int parent = 0; parent < statusInfo.getMergedStatusInfos().size(); ++parent) {
                    List statusInfos = Collections.singletonList(statusInfo.getMergedStatusInfos().get(parent));
                    sourceChanges.addAll((Collection)parser.apply(statusInfos, parent));
                }
                return sourceChanges;
            });
        }

        @Override
        public List<Change> getSourceChanges() {
            return (List)this.mySourceChanges.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "change";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statusInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parser";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$MyMergedChange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class UnparsedChanges
    implements Changes {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final List<List<VcsFileStatusInfo>> myChangesOutput;
        @NotNull
        private final VcsStatusMerger<VcsFileStatusInfo> myStatusMerger;
        @NotNull
        private final BiFunction<List<VcsFileStatusInfo>, Integer, List<Change>> myParser;

        public UnparsedChanges(@NotNull Project project, @NotNull List<List<VcsFileStatusInfo>> changesOutput, BiFunction<List<VcsFileStatusInfo>, Integer, List<Change>> parser) {
            if (project == null) {
                UnparsedChanges.$$$reportNull$$$0(0);
            }
            if (changesOutput == null) {
                UnparsedChanges.$$$reportNull$$$0(1);
            }
            if (parser == null) {
                UnparsedChanges.$$$reportNull$$$0(2);
            }
            this.myStatusMerger = new VcsFileStatusInfoMerger();
            this.myProject = project;
            this.myChangesOutput = changesOutput;
            this.myParser = parser;
        }

        @NotNull
        protected ParsedChanges parseChanges() {
            List<Change> mergedChanges = this.parseMergedChanges();
            List<Collection<Change>> changes = this.computeChanges(mergedChanges);
            ParsedChanges parsedChanges = new ParsedChanges(mergedChanges, changes);
            VcsChangesLazilyParsedDetails.this.myChanges.compareAndSet(this, parsedChanges);
            ParsedChanges parsedChanges2 = parsedChanges;
            if (parsedChanges2 == null) {
                UnparsedChanges.$$$reportNull$$$0(3);
            }
            return parsedChanges2;
        }

        @NotNull
        private List<Change> parseMergedChanges() {
            List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> statuses = this.getMergedStatusInfo();
            List<Change> changes = this.myParser.apply(ContainerUtil.map(statuses, VcsStatusMerger.MergedStatusInfo::getStatusInfo), 0);
            if (changes.size() != statuses.size()) {
                LOG.error("Incorrectly parsed statuses " + statuses + " to changes " + changes);
            }
            if (VcsChangesLazilyParsedDetails.this.getParents().size() <= 1) {
                List<Change> list = changes;
                if (list == null) {
                    UnparsedChanges.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<Change> wrappedChanges = new ArrayList<Change>(statuses.size());
            for (int i = 0; i < statuses.size(); ++i) {
                wrappedChanges.add(new MyMergedChange(changes.get(i), statuses.get(i), this.myParser));
            }
            ArrayList<Change> arrayList = wrappedChanges;
            if (arrayList == null) {
                UnparsedChanges.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            Collection<Change> collection = this.parseChanges().getMergedChanges();
            if (collection == null) {
                UnparsedChanges.$$$reportNull$$$0(6);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            Collection<Change> collection = this.parseChanges().getChanges(parent);
            if (collection == null) {
                UnparsedChanges.$$$reportNull$$$0(7);
            }
            return collection;
        }

        @Override
        public int size() {
            int size = 0;
            for (List<VcsFileStatusInfo> changesToParent : this.myChangesOutput) {
                size += changesToParent.size();
            }
            return size;
        }

        @NotNull
        private List<Collection<Change>> computeChanges(@NotNull Collection<Change> mergedChanges) {
            if (mergedChanges == null) {
                UnparsedChanges.$$$reportNull$$$0(8);
            }
            if (this.myChangesOutput.size() == 1) {
                List<Collection<Change>> list = Collections.singletonList(mergedChanges);
                if (list == null) {
                    UnparsedChanges.$$$reportNull$$$0(9);
                }
                return list;
            }
            ArrayList<Collection<Change>> changes = new ArrayList<Collection<Change>>(this.myChangesOutput.size());
            for (int i = 0; i < this.myChangesOutput.size(); ++i) {
                ProgressManager.checkCanceled();
                changes.add(this.myParser.apply(this.myChangesOutput.get(i), i));
            }
            ArrayList<Collection<Change>> arrayList = changes;
            if (arrayList == null) {
                UnparsedChanges.$$$reportNull$$$0(10);
            }
            return arrayList;
        }

        @NotNull
        private List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> getMergedStatusInfo() {
            List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> list = this.myStatusMerger.merge(this.myChangesOutput);
            if (list == null) {
                UnparsedChanges.$$$reportNull$$$0(11);
            }
            return list;
        }

        @ApiStatus.Internal
        @NotNull
        public Collection<VcsFileStatusInfo> getMergedStatuses() {
            HashSet<VcsFileStatusInfo> result2 = new HashSet<VcsFileStatusInfo>();
            for (VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> mergedStatusInfo : this.getMergedStatusInfo()) {
                result2.add(mergedStatusInfo.getStatusInfo());
            }
            HashSet<VcsFileStatusInfo> hashSet = result2;
            if (hashSet == null) {
                UnparsedChanges.$$$reportNull$$$0(12);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesOutput";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$UnparsedChanges";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$UnparsedChanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseChanges";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseMergedChanges";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedChanges";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeChanges";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedStatusInfo";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedStatuses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "computeChanges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class EmptyChanges
    implements Changes {
        protected EmptyChanges() {
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                EmptyChanges.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                EmptyChanges.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        public int size() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails$EmptyChanges";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergedChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected static interface Changes {
        @NotNull
        public Collection<Change> getMergedChanges();

        @NotNull
        public Collection<Change> getChanges(int var1);

        public int size();
    }
}

