/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllVcses
implements AllVcsesI,
Disposable {
    private final Logger LOG = Logger.getInstance(AllVcses.class);
    private final Map<String, AbstractVcs> myVcses;
    private final Object myLock;
    private final Project myProject;
    private final Map<String, VcsEP> myExtensions;
    private final AtomicBoolean unbundledVcsNotificationShown = new AtomicBoolean();

    private AllVcses(Project project) {
        this.myProject = project;
        this.myVcses = new HashMap<String, AbstractVcs>();
        this.myLock = new Object();
        VcsEP[] vcsEPs = (VcsEP[])VcsEP.EP_NAME.getExtensions((AreaInstance)this.myProject);
        HashMap<String, VcsEP> map2 = new HashMap<String, VcsEP>();
        for (VcsEP vcsEP : vcsEPs) {
            map2.put(vcsEP.name, vcsEP);
        }
        this.myExtensions = Collections.unmodifiableMap(map2);
    }

    public static AllVcsesI getInstance(Project project) {
        return (AllVcsesI)ServiceManager.getService((Project)project, AllVcsesI.class);
    }

    private void addVcs(AbstractVcs vcs) {
        this.registerVcs(vcs);
        this.myVcses.put(vcs.getName(), vcs);
    }

    private void registerVcs(AbstractVcs vcs) {
        try {
            vcs.loadSettings();
            vcs.doStart();
        }
        catch (VcsException e) {
            this.LOG.warn((Throwable)e);
        }
        vcs.getProvidedStatuses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.addVcs(vcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.unregisterVcs(vcs);
            this.myVcses.remove(vcs.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVcs getByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs vcs = this.myVcses.get(name);
            if (vcs != null) {
                return vcs;
            }
        }
        VcsEP ep = this.myExtensions.get(name);
        if (ep == null) {
            ObsoleteVcs obsoleteVcs = ObsoleteVcs.findByName(name);
            if (obsoleteVcs != null && this.unbundledVcsNotificationShown.compareAndSet(false, true)) {
                this.proposeToInstallPlugin(obsoleteVcs);
            }
            return null;
        }
        AbstractVcs vcs1 = ep.getVcs(this.myProject);
        this.LOG.assertTrue(vcs1 != null, (Object)name);
        Object object2 = this.myLock;
        synchronized (object2) {
            if (!this.myVcses.containsKey(name)) {
                this.addVcs(vcs1);
            }
            return vcs1;
        }
    }

    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        VcsEP ep = this.myExtensions.get(name);
        return ep == null ? null : ep.createDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            for (AbstractVcs vcs : this.myVcses.values()) {
                this.unregisterVcs(vcs);
            }
        }
    }

    private void unregisterVcs(AbstractVcs vcs) {
        try {
            vcs.doShutdown();
        }
        catch (VcsException e) {
            this.LOG.warn((Throwable)e);
        }
    }

    public boolean isEmpty() {
        return this.myExtensions.isEmpty();
    }

    public VcsDescriptor[] getAll() {
        ArrayList<VcsDescriptor> result2 = new ArrayList<VcsDescriptor>(this.myExtensions.size());
        for (VcsEP vcsEP : this.myExtensions.values()) {
            result2.add(vcsEP.createDescriptor());
        }
        Collections.sort(result2);
        return result2.toArray(new VcsDescriptor[0]);
    }

    private void proposeToInstallPlugin(@NotNull ObsoleteVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(2);
        }
        String message = "The " + (Object)((Object)vcs) + " plugin was unbundled and needs to be installed manually";
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("", message, NotificationType.WARNING, null);
        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.AllVcses.text.install", (Object[])new Object[0]), () -> {
            notification.expire();
            this.installPlugin(vcs);
        }));
        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.AllVcses.text.read.more", (Object[])new Object[0]), () -> BrowserUtil.browse((String)"https://blog.jetbrains.com/idea/2019/02/unbundling-tfs-and-cvs-integration-plugins/")));
        VcsNotifier.getInstance(this.myProject).notify(notification);
    }

    private void installPlugin(final @NotNull ObsoleteVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(3);
        }
        new Task.Backgroundable(this.myProject, "Installing Plugin"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    List plugins = RepositoryHelper.loadPlugins((ProgressIndicator)indicator);
                    IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)ContainerUtil.find((Iterable)plugins, d -> d.getPluginId() == vcs.pluginId);
                    if (descriptor != null) {
                        PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor);
                        if (downloader.prepareToInstall(indicator)) {
                            downloader.install();
                            PluginManager.getInstance().enablePlugins(Collections.singletonList(descriptor), true);
                            PluginManagerMain.notifyPluginsUpdated((Project)this.myProject);
                        }
                    } else {
                        this.showErrorNotification(vcs, "Couldn't find the plugin " + vcs.pluginId);
                    }
                }
                catch (IOException e) {
                    AllVcses.this.LOG.warn((Throwable)e);
                    this.showErrorNotification(vcs, e.getMessage());
                }
            }

            private void showErrorNotification(@NotNull ObsoleteVcs vcs2, @NotNull String message) {
                if (vcs2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(2);
                }
                String title2 = "Failed to Install Plugin";
                Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title2, message, NotificationType.ERROR, null);
                notification.addAction((AnAction)NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.AllVcses.text.open.plugin.page", (Object[])new Object[0]), () -> BrowserUtil.browse((String)vcs2.pluginUrl)));
                VcsNotifier.getInstance(this.myProject).notify(notification);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "vcs";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showErrorNotification";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "vcs";
        objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerManually";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterManually";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "proposeToInstallPlugin";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installPlugin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ObsoleteVcs {
        CVS("CVS", "CVS", "https://plugins.jetbrains.com/plugin/10746-cvs-integration"),
        TFS("TFS", "TFS", "https://plugins.jetbrains.com/plugin/4578-tfs");

        @NotNull
        private final String vcsName;
        @NotNull
        private final PluginId pluginId;
        @NotNull
        private final String pluginUrl;

        private ObsoleteVcs(@NotNull String vcsName, String pluginId, String pluginUrl) {
            if (vcsName == null) {
                ObsoleteVcs.$$$reportNull$$$0(0);
            }
            if (pluginId == null) {
                ObsoleteVcs.$$$reportNull$$$0(1);
            }
            if (pluginUrl == null) {
                ObsoleteVcs.$$$reportNull$$$0(2);
            }
            this.vcsName = vcsName;
            this.pluginId = PluginId.getId((String)pluginId);
            this.pluginUrl = pluginUrl;
        }

        @Nullable
        public static ObsoleteVcs findByName(@NotNull String name) {
            if (name == null) {
                ObsoleteVcs.$$$reportNull$$$0(3);
            }
            return (ObsoleteVcs)((Object)ContainerUtil.find((Object[])ObsoleteVcs.values(), vcs -> vcs.vcsName.equals(name)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginUrl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses$ObsoleteVcs";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findByName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

