/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsEP
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance(VcsEP.class);
    public static final ExtensionPointName<VcsEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.vcs");
    @Attribute(value="name")
    public String name;
    @Attribute(value="vcsClass")
    public String vcsClass;
    @Attribute(value="displayName")
    public String displayName;
    @Attribute(value="administrativeAreaName")
    public String administrativeAreaName;
    @Attribute(value="crawlUpToCheckUnderVcs")
    public boolean crawlUpToCheckUnderVcs;
    @Attribute(value="areChildrenValidMappings")
    public boolean areChildrenValidMappings;
    private AbstractVcs myVcs;
    private final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcs(@NotNull Project project) {
        if (project == null) {
            VcsEP.$$$reportNull$$$0(0);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myVcs != null) {
                return this.myVcs;
            }
        }
        AbstractVcs vcs = this.getInstance(project, this.vcsClass);
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (this.myVcs == null && vcs != null) {
                vcs.setupEnvironments();
                this.myVcs = vcs;
            }
            return this.myVcs;
        }
    }

    @Nullable
    private AbstractVcs getInstance(@NotNull Project project, @NotNull String vcsClass) {
        if (project == null) {
            VcsEP.$$$reportNull$$$0(1);
        }
        if (vcsClass == null) {
            VcsEP.$$$reportNull$$$0(2);
        }
        try {
            Class<?>[] interfaces;
            Class foundClass = this.findExtensionClass(vcsClass);
            for (Class<?> anInterface : interfaces = foundClass.getInterfaces()) {
                if (!BaseComponent.class.isAssignableFrom(anInterface)) continue;
                return (AbstractVcs)project.getComponent(foundClass);
            }
            return (AbstractVcs)this.instantiateClass(vcsClass, project.getPicoContainer());
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            LOG.error((Throwable)new PluginException((Throwable)e, this.getPluginId()));
            return null;
        }
    }

    @NotNull
    public VcsDescriptor createDescriptor() {
        return new VcsDescriptor(this.administrativeAreaName, this.displayName, this.name, this.crawlUpToCheckUnderVcs, this.areChildrenValidMappings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsEP";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

