/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class BlobIndexUtil {
    public static final String NOT_COMMITTED_HASH = StringUtil.repeat((String)"0", (int)40);

    @NotNull
    public static String getSha1(@NotNull File file) throws IOException {
        if (file == null) {
            BlobIndexUtil.$$$reportNull$$$0(0);
        }
        return BlobIndexUtil.getSha1(Files.toByteArray((File)file));
    }

    @NotNull
    public static String getSha1(byte @NotNull [] bytes) {
        if (bytes == null) {
            BlobIndexUtil.$$$reportNull$$$0(1);
        }
        String prefix = "blob " + bytes.length + '\u0000';
        String string = Hashing.sha1().newHasher().putBytes(prefix.getBytes(Charsets.UTF_8)).putBytes(bytes).hash().toString();
        if (string == null) {
            BlobIndexUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Couple<String> getBeforeAfterSha1(@NotNull Change change) throws VcsException {
        if (change == null) {
            BlobIndexUtil.$$$reportNull$$$0(3);
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        Charset detectCharset = ((ContentRevision)ObjectUtils.chooseNotNull((Object)afterRevision, (Object)beforeRevision)).getFile().getCharset();
        String before = beforeRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(beforeRevision, detectCharset));
        String after = afterRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(afterRevision, detectCharset));
        return new Couple((Object)before, (Object)after);
    }

    private static byte @NotNull [] getContentBytes(@NotNull ContentRevision revision, @NotNull Charset charset) throws VcsException {
        String stringContent;
        if (revision == null) {
            BlobIndexUtil.$$$reportNull$$$0(4);
        }
        if (charset == null) {
            BlobIndexUtil.$$$reportNull$$$0(5);
        }
        byte[] binaryContent = revision instanceof ByteBackedContentRevision ? ((ByteBackedContentRevision)revision).getContentAsBytes() : ((stringContent = revision.getContent()) != null ? stringContent.getBytes(charset) : ArrayUtilRt.EMPTY_BYTE_ARRAY);
        byte[] byArray = binaryContent != null ? binaryContent : ArrayUtilRt.EMPTY_BYTE_ARRAY;
        if (byArray == null) {
            BlobIndexUtil.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSha1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSha1";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeAfterSha1";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContentBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

