/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDeltaListener;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandler;
import com.intellij.vcs.commit.SingleChangeListCommitter;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ChangeListOwner,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ChangeListManagerImpl.class);
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    private final Project myProject;
    private final ChangesViewI myChangesViewManager;
    private final ChangelistConflictTracker myConflictTracker;
    private final Scheduler myScheduler;
    private final EventDispatcher<ChangeListListener> myListeners;
    private final DelayedNotificator myDelayedNotificator;
    private final Object myDataLock;
    private final UpdateRequestsQueue myUpdater;
    private final Modifier myModifier;
    private FileHolderComposite myComposite;
    private final ChangeListWorker myWorker;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private volatile boolean myShowLocalChangesInvalidated;
    @NotNull
    private ProgressIndicator myUpdateChangesProgressIndicator;
    private volatile String myFreezeName;
    @NotNull
    private final Set<String> myListsToBeDeletedSilently;
    @NotNull
    private final Set<String> myListsToBeDeleted;
    private boolean myEmptyListDeletionScheduled;
    private boolean myModalNotificationsBlocked;
    private final List<CommitExecutor> myRegisteredCommitExecutors;
    private static final IgnoredFileBean[] EMPTY_ARRAY = new IgnoredFileBean[0];

    public static ChangeListManagerImpl getInstanceImpl(@NotNull Project project) {
        if (project == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(0);
        }
        return (ChangeListManagerImpl)ChangeListManagerImpl.getInstance((Project)project);
    }

    public ChangeListManagerImpl(@NotNull Project project) {
        if (project == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(1);
        }
        this.myScheduler = new Scheduler();
        this.myListeners = EventDispatcher.create(ChangeListListener.class);
        this.myDataLock = new Object();
        this.myUpdateChangesProgressIndicator = ChangeListManagerImpl.createProgressIndicator();
        this.myListsToBeDeletedSilently = new HashSet<String>();
        this.myListsToBeDeleted = new HashSet<String>();
        this.myRegisteredCommitExecutors = new ArrayList<CommitExecutor>();
        this.myProject = project;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myConflictTracker = new ChangelistConflictTracker(project, this);
        this.myComposite = FileHolderComposite.create(project);
        this.myDelayedNotificator = new DelayedNotificator(this.myProject, this, this.myScheduler);
        this.myWorker = new ChangeListWorker(this.myProject, this.myDelayedNotificator);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, this.myScheduler, () -> this.updateImmediately());
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myProject.getMessageBus().connect().subscribe(ChangeListListener.TOPIC, (Object)this.myListeners.getMulticaster());
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (automatic || oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                ChangeListManagerImpl.this.scheduleAutomaticEmptyChangeListDeletion(oldList);
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project == ChangeListManagerImpl.this.myProject) {
                        ChangeListManagerImpl.this.waitEverythingDoneInTestMode();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$2", "projectClosing"));
                }
            });
        }
    }

    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList list) {
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(2);
        }
        this.scheduleAutomaticEmptyChangeListDeletion(list, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList oldList, boolean silently) {
        if (oldList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(3);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Schedule empty changelist deletion: %s, silently = %s", oldList.getName(), silently));
            }
            if (silently) {
                this.myListsToBeDeletedSilently.add(oldList.getId());
            } else {
                this.myListsToBeDeleted.add(oldList.getId());
            }
            if (!this.myEmptyListDeletionScheduled) {
                this.myEmptyListDeletionScheduled = true;
                this.invokeAfterUpdate(() -> this.deleteEmptyChangeLists(), InvokeAfterUpdateMode.SILENT, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEmptyChangeLists() {
        List listsToBeDeleted;
        List listsToBeDeletedSilently;
        VcsConfiguration config = VcsConfiguration.getInstance((Project)this.myProject);
        Function toDeleteMapping = id -> {
            LocalChangeList list = this.getChangeList((String)id);
            if (list == null || list.isDefault() || list.isReadOnly() || !list.getChanges().isEmpty()) {
                return null;
            }
            return list;
        };
        Object object = this.myDataLock;
        synchronized (object) {
            boolean askLater;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, scheduled:\nsilently: %s\nasking: %s", this.myListsToBeDeletedSilently, this.myListsToBeDeleted));
            }
            this.myListsToBeDeleted.removeAll(this.myListsToBeDeletedSilently);
            listsToBeDeletedSilently = ContainerUtil.mapNotNull(this.myListsToBeDeletedSilently, (Function)toDeleteMapping);
            this.myListsToBeDeletedSilently.clear();
            boolean bl = askLater = this.myModalNotificationsBlocked && config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
            if (!askLater) {
                listsToBeDeleted = ContainerUtil.mapNotNull(this.myListsToBeDeleted, (Function)toDeleteMapping);
                this.myListsToBeDeleted.clear();
            } else {
                listsToBeDeleted = Collections.emptyList();
            }
            this.myEmptyListDeletionScheduled = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, to be deleted:\nsilently: %s\nasking: %s", listsToBeDeletedSilently, listsToBeDeleted));
            }
        }
        if (config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY || config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && ApplicationManager.getApplication().isUnitTestMode()) {
            listsToBeDeleted.clear();
        }
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeletedSilently, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> true));
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeleted, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> config.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(this.myProject, config, toAsk)));
    }

    public static boolean showRemoveEmptyChangeListsProposal(@NotNull Project project, final @NotNull VcsConfiguration config, @NotNull Collection<? extends ChangeList> lists) {
        if (project == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(4);
        }
        if (config == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(5);
        }
        if (lists == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(6);
        }
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, list -> StringUtil.first((String)list.getName(), (int)30, (boolean)true), (String)"<br/>"));
        VcsConfirmationDialog dialog = new VcsConfirmationDialog(project, "Remove Empty Changelist", "Remove", "Cancel", new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, "&Remember my choice");
        return dialog.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists();
    }

    private void projectOpened() {
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                VcsDirtyScopeManager.getInstance((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdater.initialized();
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        } else {
            ProjectLevelVcsManagerImpl.getInstanceImpl(this.myProject).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, () -> {
                this.myUpdater.initialized();
                this.broadcastStateAfterLoad();
                this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
            });
            this.myConflictTracker.startTracking();
        }
    }

    private void broadcastStateAfterLoad() {
        List listCopy = this.getChangeListsCopy();
        if (!this.myProject.isDisposed()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(7);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(8);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.registerChangeTracker(filePath, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(9);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(10);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.unregisterChangeTracker(filePath, tracker);
        }
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title2, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(11);
        }
        if (mode == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(12);
        }
        this.invokeAfterUpdate(afterUpdate, mode, title2, null, state);
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title2, @Nullable Consumer<? super VcsDirtyScopeManager> dirtyScopeManagerFiller, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(13);
        }
        if (mode == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(14);
        }
        if (dirtyScopeManagerFiller != null && !this.myProject.isDisposed()) {
            dirtyScopeManagerFiller.consume((Object)VcsDirtyScopeManager.getInstance((Project)this.myProject));
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title2, state);
    }

    @Override
    public void freeze(@NotNull String reason) {
        if (reason == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(15);
        }
        assert (ApplicationManager.getApplication().isHeadlessEnvironment() || !ApplicationManager.getApplication().isDispatchThread());
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore();
        sem.down();
        this.invokeAfterUpdate(() -> {
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName = reason;
            sem.up();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.defaultModalityState());
        boolean free = false;
        while (!free) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                pi.checkCanceled();
            }
            free = sem.waitFor(500L);
        }
    }

    @Override
    public void unfreeze() {
        this.myUpdater.go();
        this.myFreezeName = null;
    }

    @Override
    public void waitForUpdate(@Nullable String operationName) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        CountDownLatch waiter = new CountDownLatch(1);
        this.invokeAfterUpdate(() -> waiter.countDown(), InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, operationName, ModalityState.NON_MODAL);
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
    }

    public String isFreezed() {
        return this.myFreezeName;
    }

    public void executeOnUpdaterThread(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(16);
        }
        this.myScheduler.submit(r);
    }

    public void executeUnderDataLock(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                r.run();
            }
        });
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately() {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!vcsManager2.hasActiveVcss()) {
            return;
        }
        ProgressIndicator indicator = ChangeListManagerImpl.createProgressIndicator();
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator = indicator;
        }
        ProgressManager.getInstance().runProcess(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
            VcsInvalidated invalidated = dirtyScopeManager.retrieveScopes();
            if (ChangeListManagerImpl.checkScopeIsEmpty(invalidated)) {
                LOG.debug("[update] - dirty scope is empty");
                dirtyScopeManager.changesProcessed();
                return;
            }
            boolean wasEverythingDirty = invalidated.isEverythingDirty();
            List scopes = invalidated.getScopes();
            try {
                boolean takeChanges;
                DataHolder dataHolder;
                if (this.myUpdater.isStopped()) {
                    return;
                }
                Object object = this.myDataLock;
                synchronized (object) {
                    dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), wasEverythingDirty);
                    this.myModifier.enterUpdate();
                    if (wasEverythingDirty) {
                        this.myUpdateException = null;
                        this.myAdditionalInfo = null;
                    }
                    if (LOG.isDebugEnabled()) {
                        String scopeInString = StringUtil.join((Collection)scopes, scope -> scope.toString(), (String)"->\n");
                        LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\nignored: " + this.myComposite.getIgnoredFileHolder().values().size() + "\nunversioned: " + this.myComposite.getUnversionedFileHolder().getFiles().size() + "\ncurrent changes: " + this.myWorker);
                    }
                }
                dataHolder.notifyStart();
                this.myChangesViewManager.scheduleRefresh();
                this.iterateScopes(dataHolder, scopes, indicator);
                Iterator iterator = this.myDataLock;
                synchronized (iterator) {
                    takeChanges = this.myUpdateException == null;
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    this.clearCurrentRevisionsCache(invalidated);
                    Object object = this.myDataLock;
                    synchronized (object) {
                        dataHolder.notifyEnd();
                        if (takeChanges) {
                            ChangeListWorker updatedWorker = dataHolder.getChangeListUpdater().finish();
                            this.myModifier.finishUpdate(updatedWorker);
                            this.myWorker.applyChangesFromUpdate(updatedWorker, new MyChangesDeltaForwarder(this.myProject, this.myScheduler));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getUnversionedFileHolder().getFiles().size() + "\nchanges: " + this.myWorker);
                            }
                            boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                            this.myComposite = dataHolder.getComposite();
                            if (statusChanged) {
                                this.myDelayedNotificator.unchangedFileStatusChanged();
                            }
                            LOG.debug("[update] - success");
                        } else {
                            this.myModifier.finishUpdate(null);
                            LOG.debug("[update] - aborted");
                        }
                        this.myShowLocalChangesInvalidated = false;
                    }
                });
                for (VcsDirtyScope scope2 : scopes) {
                    if (!scope2.getVcs().isTrackingUnchangedContent()) continue;
                    scope2.iterateExistingInsideScope(file -> {
                        LastUnchangedContentTracker.markUntouched(file);
                        return true;
                    });
                }
            }
            catch (ProcessCanceledException dataHolder) {
            }
            catch (AssertionError | Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                dirtyScopeManager.changesProcessed();
                this.myDelayedNotificator.changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }, indicator);
    }

    private static boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null) {
            return true;
        }
        if (invalidated.isEverythingDirty()) {
            return false;
        }
        return invalidated.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<? extends VcsDirtyScope> scopes, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(18);
        }
        ChangeListWorker.ChangeListUpdater updater = dataHolder.getChangeListUpdater();
        Getter disposedGetter = () -> this.myProject.isDisposed() || this.myUpdater.isStopped();
        UpdatingChangeListBuilder builder = new UpdatingChangeListBuilder(updater, dataHolder.getComposite(), (Getter<Boolean>)disposedGetter);
        for (VcsDirtyScope vcsDirtyScope : scopes) {
            indicator.checkCanceled();
            this.myChangesViewManager.setBusy(true);
            this.actualUpdate(builder, vcsDirtyScope, vcsDirtyScope.getVcs(), dataHolder, updater, indicator);
            Object object = this.myDataLock;
            synchronized (object) {
                if (this.myUpdateException != null) {
                    break;
                }
            }
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        return new EmptyProgressIndicator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder, @NotNull VcsDirtyScope scope, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate, @NotNull ProgressIndicator indicator) {
        if (builder == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(20);
        }
        if (vcs == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(21);
        }
        if (gate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(22);
        }
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(23);
        }
        if (dataHolder == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(24);
        }
        dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope);
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                builder.setCurrent(scope);
                changeProvider.getChanges(scope, (ChangelistBuilder)builder, indicator, gate);
            }
        }
        catch (VcsException e) {
            this.handleUpdateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrow((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                return;
            }
            e.printStackTrace();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateException = e;
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after != null && scope.belongsTo(after.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list = this.myWorker.getChangeLists();
        // MONITOREXIT : object
        if (list != null) return list;
        ChangeListManagerImpl.$$$reportNull$$$0(25);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<File> list = this.myWorker.getAffectedPaths();
        // MONITOREXIT : object
        if (list != null) return list;
        ChangeListManagerImpl.$$$reportNull$$$0(26);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list = this.myWorker.getAffectedFiles();
        // MONITOREXIT : object
        if (list != null) return list;
        ChangeListManagerImpl.$$$reportNull$$$0(27);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getAllChanges();
        // MONITOREXIT : object
        if (collection != null) return collection;
        ChangeListManagerImpl.$$$reportNull$$$0(28);
        return collection;
    }

    @Deprecated
    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        List list = ContainerUtil.mapNotNull(this.getUnversionedFilesPaths(), FilePath::getVirtualFile);
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public List<FilePath> getUnversionedFilesPaths() {
        List list = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getUnversionedFileHolder().getFiles();
            }
        });
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getModifiedWithoutEditing() {
        List list = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getModifiedWithoutEditingFileHolder().getFiles();
            }
        });
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Deprecated
    @NotNull
    public List<VirtualFile> getIgnoredFiles() {
        List list = ContainerUtil.mapNotNull(this.getIgnoredFilePaths(), FilePath::getVirtualFile);
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public List<FilePath> getIgnoredFilePaths() {
        List list = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new ArrayList<FilePath>(this.myComposite.getIgnoredFileHolder().values());
            }
        });
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(33);
        }
        return list;
    }

    boolean isIgnoredInUpdateMode() {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
            }
        });
    }

    public List<VirtualFile> getLockedFolders() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLockedFileHolder().getFiles();
            }
        });
    }

    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new HashMap<VirtualFile, LogicalLock>(this.myComposite.getLogicallyLockedFileHolder().getMap());
            }
        });
    }

    public boolean isLogicallyLocked(VirtualFile file) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLogicallyLockedFileHolder().containsKey(file);
            }
        });
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().isContainedInLocallyDeleted(filePath);
            }
        });
    }

    public List<LocallyDeletedChange> getDeletedFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().getFiles();
            }
        });
    }

    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        return (MultiMap)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchToFileMap();
            }
        });
    }

    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getRootSwitchFileHolder().getFilesMapCopy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(34);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getChangeList(@Nullable String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListById(id);
        }
    }

    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(35);
        }
        return this.addChangeList(name, comment, null);
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(36);
        }
        LocalChangeList localChangeList = (LocalChangeList)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name, comment, data);
                this.myChangesViewManager.scheduleRefresh();
                return changeList;
            }
        });
        if (localChangeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(37);
        }
        return localChangeList;
    }

    public void removeChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(38);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name);
                this.myChangesViewManager.scheduleRefresh();
            }
        });
    }

    public void removeChangeList(@NotNull LocalChangeList list) {
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(39);
        }
        this.removeChangeList(list.getName());
    }

    public void setDefaultChangeList(@NotNull String name, boolean automatic) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(name, automatic);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    public void setDefaultChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(41);
        }
        this.setDefaultChangeList(name, false);
    }

    public void setDefaultChangeList(@NotNull LocalChangeList list) {
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(42);
        }
        this.setDefaultChangeList(list, false);
    }

    @Override
    public void setDefaultChangeList(@NotNull LocalChangeList list, boolean automatic) {
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(43);
        }
        this.setDefaultChangeList(list.getName(), automatic);
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(44);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name, value);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(45);
        }
        if (toName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(46);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public String editComment(@NotNull String name, String newComment) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(47);
        }
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(name, StringUtil.notNullize((String)newComment));
                this.myChangesViewManager.scheduleRefresh();
                return oldComment;
            }
        });
    }

    @Override
    public boolean editChangeListData(@NotNull String name, @Nullable ChangeListData newData) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(48);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editData(name, newData);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    @Override
    public void moveChangesTo(@NotNull LocalChangeList list, Change ... changes) {
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(49);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(50);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list.getName(), changes);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        LocalChangeList localChangeList = this.myWorker.getDefaultList();
        // MONITOREXIT : object
        if (localChangeList != null) return localChangeList;
        ChangeListManagerImpl.$$$reportNull$$$0(51);
        return localChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getDefaultListName() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        String string = this.myWorker.getDefaultList().getName();
        // MONITOREXIT : object
        if (string != null) return string;
        ChangeListManagerImpl.$$$reportNull$$$0(52);
        return string;
    }

    public void notifyChangelistsChanged(@NotNull FilePath path2, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(53);
        }
        if (beforeChangeListsIds == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(54);
        }
        if (afterChangeListsIds == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(55);
        }
        this.myWorker.notifyChangelistsChanged(path2, beforeChangeListsIds, afterChangeListsIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getAffectedLists(Arrays.asList(changes));
            return lists.size() == 1 ? lists.get(0).getName() : null;
        }
    }

    @Override
    public boolean isInUpdate() {
        return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
    }

    @Nullable
    public Change getChange(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(56);
        }
        return this.getChange(VcsUtil.getFilePath((VirtualFile)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(57);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list = this.myWorker.getAffectedLists(changes);
        // MONITOREXIT : object
        if (list != null) return list;
        ChangeListManagerImpl.$$$reportNull$$$0(58);
        return list;
    }

    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(59);
        }
        Collection collection = this.getAffectedLists(Collections.singletonList(change));
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(60);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(61);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        Change change = this.myWorker.getChangeForPath(VcsUtil.getFilePath((VirtualFile)file));
        if (change == null) {
            List<LocalChangeList> list = Collections.emptyList();
            // MONITOREXIT : object
            if (list != null) return list;
            ChangeListManagerImpl.$$$reportNull$$$0(62);
            return list;
        }
        List<LocalChangeList> list = this.getChangeLists(change);
        // MONITOREXIT : object
        if (list != null) return list;
        ChangeListManagerImpl.$$$reportNull$$$0(63);
        return list;
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(64);
        }
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(change));
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(65);
        }
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file);
        }
    }

    public boolean isUnversioned(VirtualFile file) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getUnversionedFileHolder().containsFile(VcsUtil.getFilePath((VirtualFile)file));
            }
        });
    }

    @NotNull
    public FileStatus getStatus(@NotNull FilePath path2) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(66);
        }
        return this.getStatus(path2, path2.getVirtualFile());
    }

    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(67);
        }
        return this.getStatus(VcsUtil.getFilePath((VirtualFile)file), file);
    }

    @NotNull
    private FileStatus getStatus(@NotNull FilePath path2, @Nullable VirtualFile file) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(68);
        }
        FileStatus fileStatus = (FileStatus)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean switched;
                if (this.myComposite.getUnversionedFileHolder().containsFile(path2)) {
                    return FileStatus.UNKNOWN;
                }
                if (file != null && this.myComposite.getModifiedWithoutEditingFileHolder().containsFile(file)) {
                    return FileStatus.HIJACKED;
                }
                if (this.myComposite.getIgnoredFileHolder().containsFile(path2)) {
                    return FileStatus.IGNORED;
                }
                FileStatus status = (FileStatus)ObjectUtils.notNull((Object)this.myWorker.getStatus(path2), (Object)FileStatus.NOT_CHANGED);
                if (file != null && FileStatus.NOT_CHANGED.equals(status) && (switched = this.myComposite.getSwitchedFileHolder().containsFile(file))) {
                    return FileStatus.SWITCHED;
                }
                return status;
            }
        });
        if (fileStatus == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(69);
        }
        return fileStatus;
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull VirtualFile dir) {
        if (dir == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(70);
        }
        Collection<Change> collection = this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(71);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (vf == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(72);
        }
        if (vf.isValid() && vf.isDirectory()) {
            Object object = this.myDataLock;
            // MONITORENTER : object
            ThreeState threeState = this.myWorker.haveChangesUnder(vf);
            // MONITOREXIT : object
            if (threeState != null) return threeState;
            ChangeListManagerImpl.$$$reportNull$$$0(74);
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState != null) return threeState;
        ChangeListManagerImpl.$$$reportNull$$$0(73);
        return threeState;
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(75);
        }
        Collection collection = this.getAllChanges().stream().filter(change -> ChangeListManagerImpl.isChangeUnder(dirPath, change)).collect(Collectors.toSet());
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(76);
        }
        return collection;
    }

    private static boolean isChangeUnder(@NotNull FilePath parent, @NotNull Change change) {
        if (parent == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(77);
        }
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(78);
        }
        FilePath after = ChangesUtil.getAfterPath((Change)change);
        FilePath before = ChangesUtil.getBeforePath((Change)change);
        return after != null && after.isUnder(parent, false) || !Comparing.equal((Object)before, (Object)after) && before != null && before.isUnder(parent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(79);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getVcsFor(change);
        }
    }

    @Override
    public void addUnversionedFiles(@NotNull LocalChangeList list, @NotNull List<? extends VirtualFile> files) {
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(80);
        }
        if (files == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(81);
        }
        ScheduleForAdditionAction.addUnversionedFilesToVcs(this.myProject, list, files);
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(82);
        }
        if (disposable == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(83);
        }
        this.myListeners.addListener((EventListener)listener2, disposable);
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(84);
        }
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(85);
        }
        this.myListeners.removeListener((EventListener)listener2);
    }

    public void registerCommitExecutor(@NotNull CommitExecutor executor) {
        if (executor == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(86);
        }
        this.myRegisteredCommitExecutors.add(executor);
    }

    public void commitChanges(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(87);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(88);
        }
        this.doCommit(changeList, changes, false);
    }

    private void doCommit(LocalChangeList changeList, List<? extends Change> changes, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        String commitMessage2 = StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment();
        ChangeListCommitState commitState = new ChangeListCommitState(changeList, changes, commitMessage2);
        SingleChangeListCommitter committer = new SingleChangeListCommitter(this.myProject, commitState, new CommitContext(), changeList.getName(), false);
        committer.addResultHandler(new ShowNotificationCommitResultHandler(committer));
        committer.runCommit(changeList.getName(), synchronously);
    }

    public void commitChangesSynchronouslyWithResult(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(89);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(90);
        }
        this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        if (element == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(91);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ChangeListManagerSerialization.readExternal(element, this.myWorker);
        }
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ChangeListWorker worker;
        Element element = new Element("state");
        if (this.myProject.isDefault()) {
            return element;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            worker = this.myWorker.copy();
        }
        ChangeListManagerSerialization.writeExternal(element, worker);
        this.myConflictTracker.saveState(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(@NotNull List<? extends FilePath> paths) {
        if (paths == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(92);
        }
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable((Collection)ContainerUtil.mapNotNull(paths, FilePath::getVirtualFile));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    @NotNull
    public List<CommitExecutor> getRegisteredExecutors() {
        List<CommitExecutor> list = Collections.unmodifiableList(this.myRegisteredCommitExecutors);
        if (list == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(93);
        }
        return list;
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(94);
        }
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path2) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(95);
        }
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path2) {
        if (path2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(96);
        }
    }

    public void scheduleUnversionedUpdate() {
        Couple couple = (Couple)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                List<FilePath> unversioned = this.myComposite.getUnversionedFileHolder().getFiles();
                Collection<FilePath> ignored = this.myComposite.getIgnoredFileHolder().values();
                return Couple.of(unversioned, ignored);
            }
        });
        Collection unversioned = (Collection)couple.first;
        Collection ignored = (Collection)couple.second;
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        int ourPiecesLimit = 100;
        if (unversioned.size() + ignored.size() > 100) {
            vcsDirtyScopeManager.markEverythingDirty();
        } else {
            ArrayList<FilePath> dirs = new ArrayList<FilePath>();
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            for (FilePath filePath : ContainerUtil.concat((Iterable)unversioned, (Iterable)ignored)) {
                if (filePath.isDirectory()) {
                    dirs.add(filePath);
                    continue;
                }
                files.add(filePath);
            }
            vcsDirtyScopeManager.filePathsDirty(files, dirs);
        }
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(97);
        }
    }

    public IgnoredFileBean @NotNull [] getFilesToIgnore() {
        if (EMPTY_ARRAY == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(98);
        }
        return EMPTY_ARRAY;
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(99);
        }
        return this.isIgnoredFile(VcsUtil.getFilePath((VirtualFile)file));
    }

    public boolean isIgnoredFile(@NotNull FilePath file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(100);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().containsFile(file);
            }
        });
    }

    @Nullable
    public String getSwitchedBranch(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(101);
        }
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchForFile(file);
            }
        });
    }

    public void waitUntilRefreshed() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        VcsDirtyScopeVfsListener.getInstance(this.myProject).waitForAsyncTaskCompletion();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    private void waitUpdateAlarm() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduler.submit(() -> semaphore.up());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            while (!semaphore.waitFor(100L)) {
                UIUtil.dispatchAllInvocationEvents();
            }
        } else {
            semaphore.waitFor();
        }
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.cancelAll();
    }

    public void waitEverythingDoneInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.awaitAll();
    }

    public void forceStopInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.stop();
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public boolean ensureUpToDate() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        this.waitUntilRefreshed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    public void showLocalChangesInvalidated() {
        this.myShowLocalChangesInvalidated = true;
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(@Nls @Nullable String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason == null) {
            return false;
        }
        if (modalTitle != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
        } else {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
        }
        return true;
    }

    public void replaceCommitMessage(@NotNull String oldMessage, @NotNull String newMessage) {
        if (oldMessage == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(102);
        }
        if (newMessage == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(103);
        }
        VcsConfiguration.getInstance((Project)this.myProject).replaceMessage(oldMessage, newMessage);
        for (LocalChangeList changeList : this.getChangeLists()) {
            if (!oldMessage.equals(changeList.getComment())) continue;
            this.editComment(changeList.getName(), newMessage);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 51: 
            case 52: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 93: 
            case 98: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 51: 
            case 52: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 93: 
            case 98: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 39: 
            case 42: 
            case 43: 
            case 49: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gate";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 51: 
            case 52: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 93: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 34: 
            case 56: 
            case 61: 
            case 65: 
            case 67: 
            case 99: 
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 50: 
            case 57: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 53: 
            case 66: 
            case 68: 
            case 95: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeChangeListsIds";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterChangeListsIds";
                break;
            }
            case 59: 
            case 64: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 82: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 94: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIgnore";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMessage";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 25: 
            case 60: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFilesPaths";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedWithoutEditing";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilePaths";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChangeList";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultListName";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedLists";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 71: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredExecutors";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToIgnore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAutomaticEmptyChangeListDeletion";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showRemoveEmptyChangeListsProposal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeTracker";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterChangeTracker";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeAfterUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "freeze";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeOnUpdaterThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderDataLock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "iterateScopes";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "actualUpdate";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 51: 
            case 52: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 93: 
            case 98: {
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFileAffected";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultChangeList";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "editChangeListData";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "notifyChangelistsChanged";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLists";
                break;
            }
            case 59: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getChangeLists";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 70: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isChangeUnder";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addUnversionedFiles";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListListener";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListListener";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "registerCommitExecutor";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "commitChangesSynchronouslyWithResult";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "reopenFiles";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToIgnore";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoryToIgnoreImplicitly";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "removeImplicitlyIgnoredDirectory";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "setFilesToIgnore";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFile";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchedBranch";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "replaceCommitMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 51: 
            case 52: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 93: 
            case 98: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Scheduler {
        private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ChangeListManagerImpl Pool", (int)1);
        private final boolean myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        private final ArrayDeque<Future> myFutures = new ArrayDeque();

        Scheduler() {
        }

        /*
         * WARNING - void declaration
         */
        public void schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit timeUnit) {
            void unit;
            if (command == null) {
                Scheduler.$$$reportNull$$$0(0);
            }
            if (timeUnit == null) {
                Scheduler.$$$reportNull$$$0(1);
            }
            ScheduledFuture<?> future2 = this.myExecutor.schedule(command, delay, (TimeUnit)unit);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        public void submit(@NotNull Runnable command) {
            if (command == null) {
                Scheduler.$$$reportNull$$$0(2);
            }
            Future<?> future2 = this.myExecutor.submit(command);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFuture(Future<?> future2) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            ArrayDeque<Future> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                this.myFutures.add(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelAll() {
            ArrayDeque<Future> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                for (Future future2 : this.myFutures) {
                    future2.cancel(true);
                }
                this.myFutures.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitAll() {
            ArrayList<Exception> throwables = new ArrayList<Exception>();
            long start2 = System.currentTimeMillis();
            while (true) {
                Future future2;
                if (System.currentTimeMillis() - start2 > TimeUnit.MINUTES.toMillis(10L)) {
                    this.cancelAll();
                    throwables.add(new IllegalStateException("Too long waiting for VCS update"));
                    break;
                }
                ArrayDeque<Future> arrayDeque = this.myFutures;
                synchronized (arrayDeque) {
                    future2 = this.myFutures.peek();
                }
                if (future2 == null) break;
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
                try {
                    future2.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignore) {
                    continue;
                }
                catch (CancellationException ignore) {
                }
                catch (InterruptedException | ExecutionException e) {
                    throwables.add(e);
                }
                arrayDeque = this.myFutures;
                synchronized (arrayDeque) {
                    this.myFutures.remove(future2);
                }
            }
            CompoundRuntimeException.throwIfNotEmpty(throwables);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$Scheduler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "schedule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "submit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyChangesDeltaForwarder
    implements ChangeListDeltaListener {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final Scheduler myScheduler;

        MyChangesDeltaForwarder(Project project, @NotNull Scheduler scheduler) {
            if (scheduler == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myScheduler = scheduler;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        }

        @Override
        public void modified(@NotNull BaseRevision was, @NotNull BaseRevision become) {
            if (was == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(1);
            }
            if (become == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(2);
            }
            this.doModify(was, become);
        }

        @Override
        public void added(@NotNull BaseRevision baseRevision) {
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(3);
            }
            this.doModify(baseRevision, baseRevision);
        }

        @Override
        public void removed(@NotNull BaseRevision baseRevision) {
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(4);
            }
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.changeRemoved(baseRevision.getPath(), vcs);
                }
                ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision.getPath());
            });
        }

        private void doModify(BaseRevision was, BaseRevision become) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.changeUpdated(was.getPath(), vcs);
                }
                ((VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(become);
            });
        }

        @Nullable
        private AbstractVcs getVcs(@NotNull BaseRevision baseRevision) {
            AbstractVcs vcs;
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(5);
            }
            if ((vcs = baseRevision.getVcs()) != null) {
                return vcs;
            }
            return this.myVcsManager.getVcsFor(baseRevision.getFilePath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheduler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "was";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "become";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseRevision";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyChangesDeltaForwarder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modified";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "added";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVcs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
            if (project == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(1);
            }
            IProjectStore store = ProjectKt.getStateStore((Project)project);
            return !ProjectKt.isDirectoryBased((Project)project) && FileUtilRt.extensionEquals((String)filePath.getPath(), (String)"iws") || StringsKt.equals((String)filePath.getPath(), (String)store.getWorkspaceFilePath(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0) || DefaultIgnoredFileProvider.isShelfDirOrInsideIt(filePath, project);
        }

        private static boolean isShelfDirOrInsideIt(@NotNull FilePath filePath, @NotNull Project project) {
            if (filePath == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(2);
            }
            if (project == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(3);
            }
            String shelfPath = ShelveChangesManager.getShelfPath(project);
            return FileUtil.isAncestor((String)shelfPath, (String)filePath.getPath(), (boolean)false);
        }

        @NotNull
        public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
            if (project == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(4);
            }
            LinkedHashSet<IgnoredFileBean> ignored = new LinkedHashSet<IgnoredFileBean>();
            String shelfPath = ShelveChangesManager.getShelfPath(project);
            ignored.add(IgnoredBeanFactory.ignoreUnderDirectory((String)shelfPath, (Project)project));
            String workspaceFilePath = ProjectKt.getStateStore((Project)project).getWorkspaceFilePath();
            if (workspaceFilePath != null) {
                ignored.add(IgnoredBeanFactory.ignoreFile((String)workspaceFilePath, (Project)project));
            }
            Set set = ContainerUtil.unmodifiableOrEmptySet(ignored);
            if (set == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(5);
            }
            return set;
        }

        @NotNull
        public String getIgnoredGroupDescription() {
            return "Default ignored files";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnoredFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isShelfDirOrInsideIt";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIgnoredFiles";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;

        private DataHolder(FileHolderComposite composite, ChangeListWorker.ChangeListUpdater changeListUpdater, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListUpdater = changeListUpdater;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListUpdater.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope) {
            if (scope == null) {
                DataHolder.$$$reportNull$$$0(0);
            }
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope);
                this.myChangeListUpdater.notifyStartProcessingChanges(scope);
            }
            this.myComposite.notifyVcsStarted(scope.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        public ChangeListWorker.ChangeListUpdater getChangeListUpdater() {
            return this.myChangeListUpdater;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder", "notifyStartProcessingChanges"));
        }
    }

    static final class MyAppLevelProjectManagerListener
    implements ProjectManagerListener {
        MyAppLevelProjectManagerListener() {
        }

        public void projectOpened(@NotNull Project project) {
            if (project == null) {
                MyAppLevelProjectManagerListener.$$$reportNull$$$0(0);
            }
            ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)project)).projectOpened();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosed(@NotNull Project project) {
            ChangeListManagerImpl manager;
            if (project == null) {
                MyAppLevelProjectManagerListener.$$$reportNull$$$0(1);
            }
            if ((manager = (ChangeListManagerImpl)project.getServiceIfCreated(ChangeListManager.class)) == null) {
                return;
            }
            Object object = manager.myDataLock;
            synchronized (object) {
                manager.myUpdateChangesProgressIndicator.cancel();
            }
            manager.myUpdater.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyAppLevelProjectManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

