/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateVcsVirtualFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateVcsVirtualFileAction.class);

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDisposed()) {
            return false;
        }
        VirtualFile[] selectedFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (selectedFiles == null || selectedFiles.length != 1) {
            return false;
        }
        VirtualFile file = selectedFiles[0];
        if (file.isDirectory() || file.getFileType().isBinary()) {
            return false;
        }
        if (AnnotateVcsVirtualFileAction.getEditors(project, file, e.getDataContext()).isEmpty()) {
            return false;
        }
        AnnotationData data = AnnotateVcsVirtualFileAction.extractData(project, file);
        if (data == null) {
            return false;
        }
        AnnotationProviderEx provider = (AnnotationProviderEx)ObjectUtils.tryCast((Object)data.vcs.getAnnotationProvider(), AnnotationProviderEx.class);
        if (provider == null) {
            return false;
        }
        return provider.isAnnotationValid(data.filePath, data.revisionNumber);
    }

    private static boolean isSuspended(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(1);
        }
        VirtualFile file = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        return VcsAnnotateUtil.getBackgroundableLock((Project)e.getRequiredData(CommonDataKeys.PROJECT), file).isLocked();
    }

    private static boolean isAnnotated(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        List<Editor> editors = AnnotateVcsVirtualFileAction.getEditors(project, file, e.getDataContext());
        return ContainerUtil.exists(editors, editor -> AnnotateToggleAction.hasVcsAnnotations(editor));
    }

    private static void perform(AnActionEvent e, boolean selected) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        List<Editor> editors = AnnotateVcsVirtualFileAction.getEditors(project, file, e.getDataContext());
        if (!selected) {
            for (Editor editor : editors) {
                AnnotateToggleAction.closeVcsAnnotations(editor);
            }
        } else {
            Editor editor = editors.get(0);
            AnnotateVcsVirtualFileAction.doAnnotate(project, editor, file);
        }
    }

    private static void doAnnotate(final @NotNull Project project, final @NotNull Editor editor, @NotNull VirtualFile file) {
        if (project == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(5);
        }
        final AnnotationData data = AnnotateVcsVirtualFileAction.extractData(project, file);
        assert (data != null);
        final AnnotationProviderEx provider = (AnnotationProviderEx)data.vcs.getAnnotationProvider();
        assert (provider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        final BackgroundableActionLock actionLock = VcsAnnotateUtil.getBackgroundableLock(project, file);
        actionLock.lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    fileAnnotationRef.set((Object)provider.annotate(data.filePath, data.revisionNumber));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList(exceptionRef.get()), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project, (FileAnnotation)fileAnnotationRef.get(), data.vcs);
                }
            }

            public void onFinished() {
                actionLock.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    @Nullable
    private static AnnotationData extractData(@NotNull Project project, @NotNull VirtualFile file) {
        VcsFileRevision revision;
        if (project == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(7);
        }
        FilePath filePath = null;
        VcsRevisionNumber revisionNumber = null;
        if (file instanceof VcsVirtualFile) {
            revision = ((VcsVirtualFile)file).getFileRevision();
            filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath((String)file.getPath());
            revisionNumber = revision != null ? revision.getRevisionNumber() : null;
        } else if (file instanceof ContentRevisionVirtualFile) {
            revision = ((ContentRevisionVirtualFile)file).getContentRevision();
            filePath = revision.getFile();
            revisionNumber = revision.getRevisionNumber();
        }
        if (filePath == null || revisionNumber == null) {
            return null;
        }
        if (revisionNumber instanceof TextRevisionNumber || revisionNumber == VcsRevisionNumber.NULL) {
            return null;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)filePath);
        return vcs != null ? new AnnotationData(vcs, filePath, revisionNumber) : null;
    }

    @NotNull
    private static List<Editor> getEditors(@NotNull Project project, @NotNull VirtualFile file, @NotNull DataContext context) {
        Editor editor;
        if (project == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(9);
        }
        if (context == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(10);
        }
        if ((editor = (Editor)context.getData(CommonDataKeys.EDITOR)) instanceof EditorEx && file.equals(((EditorEx)editor).getVirtualFile())) {
            List<Editor> list = Collections.singletonList(editor);
            if (list == null) {
                AnnotateVcsVirtualFileAction.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<Editor> list = VcsAnnotateUtil.getEditors(project, file);
        if (list == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuspended";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractData";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateVcsVirtualFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(@NotNull AnActionEvent e) {
            if (e == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return AnnotateVcsVirtualFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateVcsVirtualFileAction.isAnnotated(e);
        }

        @Override
        public void perform(@NotNull AnActionEvent e, boolean selected) {
            if (e == null) {
                Provider.$$$reportNull$$$0(1);
            }
            AnnotateVcsVirtualFileAction.perform(e, selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$Provider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuspended";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AnnotationData {
        @NotNull
        public final AbstractVcs vcs;
        @NotNull
        public final FilePath filePath;
        @NotNull
        public final VcsRevisionNumber revisionNumber;

        AnnotationData(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revisionNumber) {
            if (vcs == null) {
                AnnotationData.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                AnnotationData.$$$reportNull$$$0(1);
            }
            if (revisionNumber == null) {
                AnnotationData.$$$reportNull$$$0(2);
            }
            this.vcs = vcs;
            this.filePath = filePath;
            this.revisionNumber = revisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "revisionNumber";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$AnnotationData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

