/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.CharsetEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.Nullable;

public class ApplyTextFilePatch
extends ApplyFilePatchBase<TextFilePatch> {
    public ApplyTextFilePatch(TextFilePatch patch) {
        super(patch);
    }

    @Override
    @Nullable
    protected ApplyFilePatch.Result applyChange(final Project project, final VirtualFile fileToPatch, final FilePath pathBeforeRename, final @Nullable Getter<? extends CharSequence> baseContents) throws IOException {
        Document document = FileDocumentManager.getInstance().getDocument(fileToPatch);
        if (document == null) {
            throw new IOException("Failed to set contents for updated file " + fileToPatch.getPath());
        }
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(document.getText(), ((TextFilePatch)this.myPatch).getHunks());
        if (appliedPatch != null) {
            FormatChangedTextUtil.getInstance().runHeavyModificationTask(project, document, () -> document.setText((CharSequence)appliedPatch.patchedText));
            FileDocumentManager.getInstance().saveDocument(document);
            return new ApplyFilePatch.Result(appliedPatch.status);
        }
        return new ApplyFilePatch.Result(ApplyPatchStatus.FAILURE){

            @Override
            public ApplyPatchForBaseRevisionTexts getMergeData() {
                return ApplyPatchForBaseRevisionTexts.create(project, fileToPatch, pathBeforeRename, (TextFilePatch)ApplyTextFilePatch.this.myPatch, baseContents != null ? (CharSequence)baseContents.get() : null);
            }
        };
    }

    @Override
    protected void applyCreate(Project project, VirtualFile newFile, CommitContext commitContext) throws IOException {
        Document document = FileDocumentManager.getInstance().getDocument(newFile);
        if (document == null) {
            throw new IOException("Failed to set contents for new file " + newFile.getPath());
        }
        String charsetName = CharsetEP.getCharset(newFile.getPath(), commitContext);
        if (charsetName != null) {
            try {
                Charset charset = Charset.forName(charsetName);
                newFile.setCharset(charset);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        document.setText((CharSequence)((TextFilePatch)this.myPatch).getSingleHunkPatchText());
        FileDocumentManager.getInstance().saveDocument(document);
    }
}

