/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsUtil {
    private static final Logger LOG = Logger.getInstance(DvcsUtil.class);
    private static final Logger LOGGER = Logger.getInstance(DvcsUtil.class);
    private static final int IO_RETRIES = 3;
    public static final Comparator<VirtualFile> VIRTUAL_FILE_PRESENTATION_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
    };
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = Comparator.comparing(Repository::getPresentableUrl);

    @NotNull
    public static List<VirtualFile> sortVirtualFilesByPresentation(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            DvcsUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.sorted(virtualFiles, VIRTUAL_FILE_PRESENTATION_COMPARATOR);
        if (list == null) {
            DvcsUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> findVirtualFilesWithRefresh(@NotNull List<? extends File> files) {
        if (files == null) {
            DvcsUtil.$$$reportNull$$$0(2);
        }
        RefreshVFsSynchronously.refreshFiles(files);
        List list = ContainerUtil.mapNotNull(files, file -> VfsUtil.findFileByIoFile((File)file, (boolean)false));
        if (list == null) {
            DvcsUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Deprecated
    @NotNull
    public static String getShortRepositoryName(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            DvcsUtil.$$$reportNull$$$0(5);
        }
        String string = VcsImplUtil.getShortVcsRootName(project, root);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            DvcsUtil.$$$reportNull$$$0(7);
        }
        String string = VcsImplUtil.getShortVcsRootName(repository.getProject(), repository.getRoot());
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(9);
        }
        String string = StringUtil.join(repositories, repository -> DvcsUtil.getShortRepositoryName(repository), (String)", ");
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String fileOrFolder(@NotNull VirtualFile file) {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(11);
        }
        if (file.isDirectory()) {
            return "folder";
        }
        return "file";
    }

    public static boolean anyRepositoryIsFresh(Collection<? extends Repository> repositories) {
        for (Repository repository : repositories) {
            if (!repository.isFresh()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        String joined;
        if (messages == null) {
            DvcsUtil.$$$reportNull$$$0(12);
        }
        return StringUtil.isEmptyOrSpaces((String)(joined = StringUtil.join(messages, (String)"\n"))) ? null : joined;
    }

    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project) {
        Editor editor;
        FileEditorManager manager;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(13);
        }
        StatusBar statusBar2 = WindowManager.getInstance().getStatusBar(project);
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor((StatusBar)statusBar2);
        VirtualFile result2 = null;
        if (fileEditor != null) {
            result2 = fileEditor.getFile();
        }
        if (result2 == null && (manager = FileEditorManager.getInstance((Project)project)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            result2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        }
        return result2;
    }

    @NotNull
    public static String getShortHash(@NotNull String hash) {
        if (hash == null) {
            DvcsUtil.$$$reportNull$$$0(14);
        }
        if (hash.length() < 8) {
            LOG.debug("Unexpectedly short hash: [" + hash + "]");
        }
        if (hash.length() > 40) {
            LOG.debug("Unexpectedly long hash: [" + hash + "]");
        }
        String string = VcsLogUtil.getShortHash(hash);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            DvcsUtil.$$$reportNull$$$0(16);
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit.getTimestamp()) + " ";
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(@NotNull Project project) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(18);
        }
        return DvcsUtil.workingTreeChangeStarted(project, null);
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(final @NotNull Project project, @Nullable String activityName) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(19);
        }
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, activityName);
        return new AccessToken(){

            public void finish() {
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
            }
        };
    }

    @Deprecated
    public static void workingTreeChangeFinished(@NotNull Project project, @NotNull AccessToken token) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(20);
        }
        if (token == null) {
            DvcsUtil.$$$reportNull$$$0(21);
        }
        token.finish();
    }

    public static void assertFileExists(File file, String message) throws IllegalStateException {
        if (!file.exists()) {
            throw new IllegalStateException(message);
        }
    }

    @NotNull
    public static String tryLoadFile(@NotNull File file) throws RepoStateException {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(22);
        }
        return DvcsUtil.tryLoadFile(file, null);
    }

    @NotNull
    public static String tryLoadFile(@NotNull File file, @Nullable String encoding) throws RepoStateException {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(23);
        }
        String string = DvcsUtil.tryOrThrow(() -> StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file, (String)encoding)).trim(), file);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    @Contract(value="_ , !null -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file, @Nullable String defaultValue) {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(25);
        }
        return DvcsUtil.tryLoadFileOrReturn(file, defaultValue, null);
    }

    @Nullable
    @Contract(value="_ , !null, _ -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file, @Nullable String defaultValue, @Nullable String encoding) {
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(26);
        }
        try {
            return DvcsUtil.tryLoadFile(file, encoding);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return defaultValue;
        }
    }

    private static <T> T tryOrThrow(Callable<T> actionToTry, File fileToLoad) throws RepoStateException {
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOG.info("IOException while loading " + fileToLoad, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + fileToLoad, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + fileToLoad, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            DvcsUtil.$$$reportNull$$$0(27);
        }
        if (subDirs == null) {
            DvcsUtil.$$$reportNull$$$0(28);
        }
        vcsDir.getChildren();
        for (String subdir2 : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir2);
            DvcsUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)CommonProcessors.alwaysTrue());
        }
    }

    public static void addMappingIfSubRoot(@NotNull Project project, @NotNull String newRepositoryPath, @NotNull String vcsName) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(29);
        }
        if (newRepositoryPath == null) {
            DvcsUtil.$$$reportNull$$$0(30);
        }
        if (vcsName == null) {
            DvcsUtil.$$$reportNull$$$0(31);
        }
        if (!project.isDisposed() && project.getBasePath() != null && FileUtil.isAncestor((String)project.getBasePath(), (String)newRepositoryPath, (boolean)true)) {
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
            manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)newRepositoryPath, (String)vcsName));
        }
    }

    @Nullable
    public static <T extends Repository> T guessRepositoryForFile(@NotNull Project project, @NotNull RepositoryManager<T> manager, @Nullable VirtualFile file, @Nullable String defaultRootPathValue) {
        Repository repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(32);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(33);
        }
        return (T)((repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project, file))) != null ? repository : manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), defaultRootPathValue)));
    }

    @Nullable
    public static <T extends Repository> T guessCurrentRepositoryQuick(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager, @Nullable String defaultRootPathValue) {
        T repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(34);
        }
        if (manager == null) {
            DvcsUtil.$$$reportNull$$$0(35);
        }
        return (repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project, DvcsUtil.getSelectedFile(project)))) != null ? repository : manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager.getVcs(), defaultRootPathValue));
    }

    @Nullable
    private static VirtualFile guessRootForVcs(@NotNull Project project, @Nullable AbstractVcs vcs, @Nullable String defaultRootPathValue) {
        VirtualFile recentRoot;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(36);
        }
        if (project.isDisposed()) {
            return null;
        }
        LOG.debug("Guessing vcs root...");
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        if (vcs == null) {
            LOG.debug("Vcs not found.");
            return null;
        }
        String vcsName = vcs.getDisplayName();
        VirtualFile[] vcsRoots = vcsManager2.getRootsUnderVcs(vcs);
        if (vcsRoots.length == 0) {
            LOG.debug("No " + vcsName + " roots in the project.");
            return null;
        }
        if (vcsRoots.length == 1) {
            VirtualFile onlyRoot = vcsRoots[0];
            LOG.debug("Only one " + vcsName + " root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        if (defaultRootPathValue != null && (recentRoot = VcsUtil.getVirtualFile((String)defaultRootPathValue)) != null) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir == null) {
            VirtualFile firstRoot = vcsRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + firstRoot);
            return firstRoot;
        }
        for (VirtualFile root : vcsRoots) {
            if (!root.equals(projectBaseDir) && !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            LOG.debug("The best candidate: " + root);
            return root;
        }
        VirtualFile rootCandidate = vcsRoots[0];
        LOG.debug("Returning the best candidate: " + rootCandidate);
        return rootCandidate;
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<? extends T> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(37);
        }
        List validRepositories = ContainerUtil.filter(repositories, t -> t.getRoot().isValid());
        Collections.sort(validRepositories, REPOSITORY_COMPARATOR);
        return validRepositories;
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project, @NotNull VirtualFile file) {
        ProjectLevelVcsManager vcsManager2;
        VirtualFile root;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(38);
        }
        if (file == null) {
            DvcsUtil.$$$reportNull$$$0(39);
        }
        if ((root = (vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project)).getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file))) != null) {
            LOGGER.debug("Found root for zip/jar file: " + root);
            return root;
        }
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
        HashSet<VirtualFile> libraryRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry : entries) {
            VirtualFile moduleRoot;
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry) || (moduleRoot = vcsManager2.getVcsRootFor(entry.getOwnerModule().getModuleFile())) == null) continue;
            libraryRoots.add(moduleRoot);
        }
        if (libraryRoots.isEmpty()) {
            LOGGER.debug("No library roots");
            return null;
        }
        Iterator libIterator = libraryRoots.iterator();
        VirtualFile topLibraryRoot = (VirtualFile)libIterator.next();
        while (libIterator.hasNext()) {
            VirtualFile libRoot = (VirtualFile)libIterator.next();
            if (!VfsUtilCore.isAncestor((VirtualFile)libRoot, (VirtualFile)topLibraryRoot, (boolean)true)) continue;
            topLibraryRoot = libRoot;
        }
        LOGGER.debug("Several library roots, returning " + topLibraryRoot);
        return topLibraryRoot;
    }

    @Nullable
    public static VirtualFile guessVcsRoot(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(40);
        }
        VirtualFile root = null;
        if (file != null && (root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file)) == null) {
            LOGGER.debug("Cannot get root by file. Trying with get by library: " + file);
            root = DvcsUtil.getVcsRootForLibraryFile(project, file);
        }
        return root;
    }

    @NotNull
    public static <R extends Repository> Map<R, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull RepositoryManager<R> repoManager, @NotNull List<? extends VcsFullCommitDetails> commits) {
        if (repoManager == null) {
            DvcsUtil.$$$reportNull$$$0(41);
        }
        if (commits == null) {
            DvcsUtil.$$$reportNull$$$0(42);
        }
        HashMap<Repository, List> groupedCommits = new HashMap<Repository, List>();
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            Repository repository = repoManager.getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                LOGGER.info("No repository found for commit " + vcsFullCommitDetails);
                continue;
            }
            List commitsInRoot = groupedCommits.computeIfAbsent(repository, __ -> new ArrayList());
            commitsInRoot.add(vcsFullCommitDetails);
        }
        HashMap<Repository, List> hashMap = groupedCommits;
        if (hashMap == null) {
            DvcsUtil.$$$reportNull$$$0(43);
        }
        return hashMap;
    }

    @Nullable
    public static PushSupport getPushSupport(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            DvcsUtil.$$$reportNull$$$0(44);
        }
        return (PushSupport)ContainerUtil.find((Object[])PushSupport.PUSH_SUPPORT_EP.getExtensions((AreaInstance)vcs.getProject()), support -> support.getVcs().equals((Object)vcs));
    }

    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(45);
        }
        return DvcsUtil.joinShortNames(repositories, -1);
    }

    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories, int limit) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(46);
        }
        return DvcsUtil.joinWithAnd(ContainerUtil.map(repositories, repository -> DvcsUtil.getShortRepositoryName(repository)), limit);
    }

    @NotNull
    public static String joinWithAnd(@NotNull List<String> strings, int limit) {
        int size;
        if (strings == null) {
            DvcsUtil.$$$reportNull$$$0(47);
        }
        if ((size = strings.size()) == 0) {
            return "";
        }
        if (size == 1) {
            String string = strings.get(0);
            if (string == null) {
                DvcsUtil.$$$reportNull$$$0(48);
            }
            return string;
        }
        if (size == 2) {
            String string = strings.get(0) + " and " + strings.get(1);
            if (string == null) {
                DvcsUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        boolean isLimited = limit >= 2 && limit < size;
        int listCount = (isLimited ? limit : size) - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listCount; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(strings.get(i));
        }
        if (isLimited) {
            sb.append(" and ").append(size - limit + 1).append(" others");
        } else {
            sb.append(" and ").append(strings.get(size - 1));
        }
        String string = sb.toString();
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 24: 
            case 43: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 24: 
            case 43: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 24: 
            case 43: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: 
            case 37: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 11: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDir";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirs";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRepositoryPath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoManager";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sortVirtualFilesByPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFilesWithRefresh";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortRepositoryName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateString";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLoadFile";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "groupCommitsByRoots";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithAnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortVirtualFilesByPresentation";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 24: 
            case 43: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFilesWithRefresh";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getShortRepositoryName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getShortNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fileOrFolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "joinMessagesOrNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDateString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "workingTreeChangeStarted";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "workingTreeChangeFinished";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFileOrReturn";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitVcsDirVfs";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addMappingIfSubRoot";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepositoryQuick";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "guessRootForVcs";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sortRepositories";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootForLibraryFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "guessVcsRoot";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "groupCommitsByRoots";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPushSupport";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "joinShortNames";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "joinWithAnd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 24: 
            case 43: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

