/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.agent.settings.DockerSystemInfo;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.target.DockerEnvironment;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentFactory;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.remoteServer.util.ServerRuntimeException;
import org.jetbrains.annotations.NotNull;

public class DockerEnvironmentFactory
implements TargetEnvironmentFactory {
    private final RemoteDockerRuntime myDocker;
    private final RemoteDockerApplicationRuntime myImageRuntime;
    private final DockerTargetEnvironmentConfiguration myTargetConfiguration;
    private DockerSystemInfo mySystemInfo;
    private TargetPlatform myTargetPlatform;

    public DockerEnvironmentFactory(RemoteDockerRuntime docker, RemoteDockerApplicationRuntime imageRuntime, DockerTargetEnvironmentConfiguration targetConfiguration) {
        this.myDocker = docker;
        this.myImageRuntime = imageRuntime;
        this.myTargetConfiguration = targetConfiguration;
    }

    public RemoteDockerRuntime getDocker() {
        return this.myDocker;
    }

    @NotNull
    public TargetEnvironment prepareRemoteEnvironment(@NotNull TargetEnvironmentRequest request, @NotNull ProgressIndicator indicator) {
        if (request == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(1);
        }
        assert (request instanceof DockerRemoteRequest);
        try {
            this.getSystemInfo();
        }
        catch (ServerRuntimeException e) {
            throw new RuntimeException(e);
        }
        return new DockerEnvironment(this, this.myImageRuntime, (DockerRemoteRequest)request);
    }

    @NotNull
    public DockerSystemInfo getSystemInfo() throws ServerRuntimeException {
        if (this.mySystemInfo == null) {
            this.mySystemInfo = this.myImageRuntime.getSystemInfo();
        }
        DockerSystemInfo dockerSystemInfo = this.mySystemInfo;
        if (dockerSystemInfo == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(2);
        }
        return dockerSystemInfo;
    }

    @NotNull
    public TargetEnvironmentConfiguration getTargetConfiguration() {
        DockerTargetEnvironmentConfiguration dockerTargetEnvironmentConfiguration = this.myTargetConfiguration;
        if (dockerTargetEnvironmentConfiguration == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(3);
        }
        return dockerTargetEnvironmentConfiguration;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        if (this.myTargetPlatform == null) {
            try {
                DockerSystemInfo dockerInfo = this.getSystemInfo();
            }
            catch (ServerRuntimeException e) {
                throw new IllegalStateException(e);
            }
            this.myTargetPlatform = new TargetPlatform(Platform.UNIX, TargetPlatform.Arch.x64bit);
        }
        TargetPlatform targetPlatform = this.myTargetPlatform;
        if (targetPlatform == null) {
            DockerEnvironmentFactory.$$$reportNull$$$0(4);
        }
        return targetPlatform;
    }

    @NotNull
    public TargetEnvironmentRequest createRequest() {
        return new DockerRemoteRequest(this.myTargetConfiguration, this.getTargetPlatform());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerEnvironmentFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerEnvironmentFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareRemoteEnvironment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

