/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShShellcheckUtil {
    @NonNls
    private static final Logger LOG = Logger.getInstance(ShShellcheckUtil.class);
    private static final String FEATURE_ACTION_ID = "ExternalAnnotatorDownloaded";
    private static final String WINDOWS_EXTENSION = ".exe";
    static final String SHELLCHECK = "shellcheck";
    static final String SHELLCHECK_VERSION = "0.6.0-1";
    static final String SHELLCHECK_ARCHIVE_EXTENSION = ".tar.gz";
    static final String SHELLCHECK_URL = "https://jetbrains.bintray.com/intellij-third-party-dependencies/org/jetbrains/intellij/deps/shellcheck/";
    private static final String DOWNLOAD_PATH = PathManager.getPluginsPath() + File.separator + ShLanguage.INSTANCE.getID();
    public static final Map<String, String> SHELLCHECK_CODES = new TreeMap<String, String>(){
        {
            this.put("SC1000", "$ is not used specially and should therefore be escaped.");
            this.put("SC1001", "This \\o will be a regular 'o' in this context.");
            this.put("SC1003", "Want to escape a single quote? echo 'This is how it'\\''s done'.");
            this.put("SC1004", "This backslash+linefeed is literal. Break outside single quotes if you just want to break the line.");
            this.put("SC1007", "Remove space after = if trying to assign a value (or for empty string, use var='' ... ).");
            this.put("SC1008", "This shebang was unrecognized. ShellCheck only supports sh/bash/dash/ksh. Add a 'shell' directive to specify.");
            this.put("SC1009", "The mentioned parser error was in ...");
            this.put("SC1010", "Use semicolon or linefeed before 'done' (or quote to make it literal).");
            this.put("SC1011", "This apostrophe terminated the single quoted string!");
            this.put("SC1012", "`\t` is just literal `t` here. For tab, use \"$(printf '\t')\" instead.");
            this.put("SC1014", "Use 'if cmd; then ..' to check exit code, or 'if [ \"$(cmd)\" = .. ]' to check output.");
            this.put("SC1015", "This is a unicode double quote. Delete and retype it.");
            this.put("SC1016", "This is a Unicode single quote. Delete and retype it.");
            this.put("SC1017", "Literal carriage return. Run script through `tr -d '\r'` .");
            this.put("SC1018", "This is a unicode non-breaking space. Delete it and retype as space.");
            this.put("SC1019", "Expected this to be an argument to the unary condition.");
            this.put("SC1020", "You need a space before the if single then \"]\" else \"]]\"");
            this.put("SC1026", "If grouping expressions inside [[..]], use ( .. ).");
            this.put("SC1028", "In [..] you have to escape \\( \\) or preferably combine [..] expressions.");
            this.put("SC1029", "In `[[..]]` you shouldn't escape `(` or `)`.");
            this.put("SC1035", "You need a space here");
            this.put("SC1036", "`(` is invalid here. Did you forget to escape it?");
            this.put("SC1037", "Braces are required for positionals over 9, e.g. ${10}.");
            this.put("SC1038", "Shells are space sensitive. Use '< <(cmd)', not '<<(cmd)'.");
            this.put("SC1039", "Remove indentation before end token (or use `<<-` and indent with tabs).");
            this.put("SC1040", "When using <<-, you can only indent with tabs.");
            this.put("SC1041", "Found 'eof' further down, but not on a separate line.");
            this.put("SC1042", "Found 'eof' further down, but not on a separate line.");
            this.put("SC1044", "Couldn't find end token `EOF' in the here document.");
            this.put("SC1045", "It's not 'foo &; bar', just 'foo & bar'.");
            this.put("SC1046", "Couldn't find 'fi' for this 'if'.");
            this.put("SC1047", "Expected 'fi' matching previously mentioned 'if'.");
            this.put("SC1048", "Can't have empty then clauses (use 'true' as a no-op).");
            this.put("SC1049", "Did you forget the 'then' for this 'if'?");
            this.put("SC1050", "Expected 'then'.");
            this.put("SC1051", "Semicolons directly after 'then' are not allowed. Just remove it.");
            this.put("SC1052", "Semicolons directly after 'then' are not allowed. Just remove it.");
            this.put("SC1053", "Semicolons directly after 'else' are not allowed. Just remove it.");
            this.put("SC1054", "You need a space after the '{'.");
            this.put("SC1058", "Expected `do`.");
            this.put("SC1061", "Couldn't find 'done' for this 'do'.");
            this.put("SC1062", "Expected 'done' matching previously mentioned 'do'.");
            this.put("SC1064", "Expected a { to open the function definition.");
            this.put("SC1065", "Trying to declare parameters? Don't. Use () and refer to params as $1, $2..");
            this.put("SC1066", "Don't use $ on the left side of assignments.");
            this.put("SC1068", "Don't put spaces around the = in assignments.");
            this.put("SC1069", "You need a space before the [.");
            this.put("SC1071", "ShellCheck only supports sh/bash/dash/ksh scripts. Sorry!");
            this.put("SC1072", "Unexpected ..");
            this.put("SC1073", "Couldn't parse this (thing). Fix to allow more checks.");
            this.put("SC1075", "Use 'elif' instead of 'else if'.");
            this.put("SC1077", "For command expansion, the tick should slant left (` vs \u00b4).");
            this.put("SC1078", "Did you forget to close this double quoted string?");
            this.put("SC1079", "This is actually an end quote, but due to next char it looks suspect.");
            this.put("SC1081", "Scripts are case sensitive. Use 'if', not 'If'.");
            this.put("SC1082", "This file has a UTF-8 BOM. Remove it with: LC_CTYPE=C sed '1s/^...//' < yourscript .");
            this.put("SC1083", "This `{`/`}` is literal. Check expression (missing `;/\n?`) or quote it.");
            this.put("SC1084", "Use #!, not !#, for the shebang.");
            this.put("SC1086", "Don't use $ on the iterator name in for loops.");
            this.put("SC1087", "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).");
            this.put("SC1088", "Parsing stopped here. Invalid use of parentheses?");
            this.put("SC1089", "Parsing stopped here. Is this keyword correctly matched up?");
            this.put("SC1090", "Can't follow non-constant source. Use a directive to specify location.");
            this.put("SC1091", "Not following: (error message here)");
            this.put("SC1094", "Parsing of sourced file failed. Ignoring it.");
            this.put("SC1095", "You need a space or linefeed between the function name and body.");
            this.put("SC1097", "Unexpected ==. For assignment, use =. For comparison, use [/[[.");
            this.put("SC1098", "Quote/escape special characters when using eval, e.g. eval \"a=(b)\".");
            this.put("SC1099", "You need a space before the #.");
            this.put("SC1100", "This is a unicode dash. Delete and retype as ASCII minus.");
            this.put("SC1101", "Delete trailing spaces after \\ to break line (or use quotes for literal space).");
            this.put("SC1102", "Shells disambiguate $(( differently or not at all. If the first $( should start command substitution, add a space after it.");
            this.put("SC1104", "Use #!, not just !, for the shebang.");
            this.put("SC1105", "Shells disambiguate (( differently or not at all. If the first ( should start a subshell, add a space after it.");
            this.put("SC1107", "This directive is unknown. It will be ignored.");
            this.put("SC1108", "You need a space before and after the = .");
            this.put("SC1109", "This is an unquoted HTML entity. Replace with corresponding character.");
            this.put("SC1110", "This is a unicode quote. Delete and retype it (or quote to make literal).");
            this.put("SC1111", "This is a unicode quote. Delete and retype it (or ignore/singlequote for literal).");
            this.put("SC1112", "This is a unicode quote. Delete and retype it (or ignore/doublequote for literal).");
            this.put("SC1113", "Use #!, not just #, for the shebang.");
            this.put("SC1114", "Remove leading spaces before the shebang.");
            this.put("SC1115", "Remove spaces between # and ! in the shebang.");
            this.put("SC1116", "Missing $ on a $((..)) expression? (or use ( ( for arrays).");
            this.put("SC1117", "Backslash is literal in \"\n\". Prefer explicit escaping: \"\\n\".");
            this.put("SC1118", "Delete whitespace after the here-doc end token.");
            this.put("SC1119", "Add a linefeed between end token and terminating ')'.");
            this.put("SC1120", "No comments allowed after here-doc token. Comment the next line instead.");
            this.put("SC1121", "Add ;/& terminators (and other syntax) on the line with the <<, not here.");
            this.put("SC1122", "Nothing allowed after end token. To continue a command, put it on the line with the `<<`.");
            this.put("SC1123", "ShellCheck directives are only valid in front of complete compound commands, like `if`, not e.g. individual `elif` branches.");
            this.put("SC1124", "ShellCheck directives are only valid in front of complete commands like 'case' statements, not individual case branches.");
            this.put("SC1126", "Place shellcheck directives before commands, not after.");
            this.put("SC1127", "Was this intended as a comment? Use `#` in sh.");
            this.put("SC1128", "The shebang must be on the first line. Delete blanks and move comments.");
            this.put("SC1129", "You need a space before the !.");
            this.put("SC1130", "You need a space before the :.");
            this.put("SC1131", "Use `elif` to start another branch.");
            this.put("SC1132", "This `&` terminates the command. Escape it or add space after `&` to silence.");
            this.put("SC1133", "Unexpected start of line. If breaking lines, |/||/&& should be at the end of the previous one.");
            this.put("SC2001", "SC2001: See if you can use ${variable//search/replace} instead.");
            this.put("SC2002", "Useless cat. Consider 'cmd < file | ..' or 'cmd file | ..' instead.");
            this.put("SC2003", "expr is antiquated. Consider rewriting this using $((..)), ${} or \\[\\[ \\]\\].");
            this.put("SC2004", "$/${} is unnecessary on arithmetic variables.");
            this.put("SC2005", "Useless `echo`? Instead of `echo $(cmd)`, just use `cmd`");
            this.put("SC2006", "Use $(...) notation instead of legacy backticked `` `...` ``.");
            this.put("SC2007", "Use $((..)) instead of deprecated $[..]");
            this.put("SC2008", "echo doesn't read from stdin, are you sure you should be piping to it?");
            this.put("SC2009", "SC2009 Consider using pgrep instead of grepping ps output.");
            this.put("SC2010", "Don't use ls | grep. Use a glob or a for loop with a condition to allow non-alphanumeric filenames.");
            this.put("SC2012", "Use `find` instead of `ls` to better handle non-alphanumeric filenames.");
            this.put("SC2013", "To read lines rather than words, pipe/redirect to a 'while read' loop.");
            this.put("SC2014", "This will expand once before find runs, not per file found.");
            this.put("SC2015", "Note that A && B || C is not if-then-else. C may run when A is true.");
            this.put("SC2016", "Expressions don't expand in single quotes, use double quotes for that.");
            this.put("SC2017", "Increase precision by replacing a/b\\*c with a\\*c/b.");
            this.put("SC2018", "Use '[:lower:]' to support accents and foreign alphabets.");
            this.put("SC2019", "Use '[:upper:]' to support accents and foreign alphabets.");
            this.put("SC2020", "tr replaces sets of chars, not words (mentioned due to duplicates).");
            this.put("SC2021", "Don't use [] around ranges in tr, it replaces literal square brackets.");
            this.put("SC2022", "Note that unlike globs, o* here matches 'ooo' but not 'oscar'");
            this.put("SC2024", "`sudo` doesn't affect redirects. Use `..| sudo tee file`");
            this.put("SC2025", "Make sure all escape sequences are enclosed in `\\[..\\]` to prevent line wrapping issues");
            this.put("SC2026", "This word is outside of quotes. Did you intend to 'nest '\"'single quotes'\"' instead'?");
            this.put("SC2027", "The surrounding quotes actually unquote this. Remove or escape them.");
            this.put("SC2028", "echo won't expand escape sequences. Consider printf.");
            this.put("SC2029", "Note that, unescaped, this expands on the client side.");
            this.put("SC2030", "Modification of var is local (to subshell caused by pipeline).");
            this.put("SC2031", "var was modified in a subshell. That change might be lost.");
            this.put("SC2032", "Use own script or sh -c '..' to run this from su.");
            this.put("SC2033", "Shell functions can't be passed to external commands.");
            this.put("SC2034", "foo appears unused. Verify it or export it.");
            this.put("SC2035", "Use ./\\*glob* or -- \\*glob* so names with dashes won't become options.");
            this.put("SC2036", "If you wanted to assign the output of the pipeline, use a=$(b | c) .");
            this.put("SC2037", "To assign the output of a command, use var=$(cmd) .");
            this.put("SC2038", "Use -print0/-0 or find -exec + to allow for non-alphanumeric filenames.");
            this.put("SC2039", "In POSIX sh, *something* is undefined.");
            this.put("SC2040", "#!/bin/sh was specified, so ____ is not supported, even when sh is actually bash.");
            this.put("SC2041", "This is a literal string. To run as a command, use $(..) instead of '..' .");
            this.put("SC2043", "This loop will only ever run once for a constant value. Did you perhaps mean to loop over dir/*, $var or $(cmd)?");
            this.put("SC2044", "For loops over find output are fragile. Use find -exec or a while read loop.");
            this.put("SC2045", "Iterating over ls output is fragile. Use globs.");
            this.put("SC2046", "Quote this to prevent word splitting");
            this.put("SC2048", "Use \"$@\" (with quotes) to prevent whitespace problems.");
            this.put("SC2049", "=~ is for regex, but this looks like a glob. Use = instead.");
            this.put("SC2050", "This expression is constant. Did you forget the `$` on a variable?");
            this.put("SC2051", "Bash doesn't support variables in brace range expansions.");
            this.put("SC2053", "Quote the rhs of = in [[ ]] to prevent glob matching.");
            this.put("SC2054", "Use spaces, not commas, to separate array elements.");
            this.put("SC2055", "You probably wanted && here");
            this.put("SC2056", "You probably wanted && here");
            this.put("SC2057", "Unknown binary operator.");
            this.put("SC2058", "Unknown unaryoperator.");
            this.put("SC2059", "Don't use variables in the printf format string. Use printf \"..%s..\" \"$foo\".");
            this.put("SC2060", "Quote parameters to tr to prevent glob expansion.");
            this.put("SC2061", "Quote the parameter to -name so the shell won't interpret it.");
            this.put("SC2062", "Quote the grep pattern so the shell won't interpret it.");
            this.put("SC2063", "Grep uses regex, but this looks like a glob.");
            this.put("SC2064", "Use single quotes, otherwise this expands now rather than when signalled.");
            this.put("SC2065", "This is interpreted as a shell file redirection, not a comparison.");
            this.put("SC2066", "Since you double quoted this, it will not word split, and the loop will only run once.");
            this.put("SC2067", "Missing ';' or + terminating -exec. You can't use |/||/&&, and ';' has to be a separate, quoted argument.");
            this.put("SC2068", "Double quote array expansions to avoid re-splitting elements.");
            this.put("SC2069", "To redirect stdout+stderr, 2>&1 must be last (or use '{ cmd > file; } 2>&1' to clarify).");
            this.put("SC2070", "`-n` doesn't work with unquoted arguments. Quote or use ``[[ ]]``.");
            this.put("SC2071", "> is for string comparisons. Use -gt instead.");
            this.put("SC2072", "Decimals are not supported. Either use integers only, or use bc or awk to compare.");
            this.put("SC2074", "Can't use `=~` in `[ ]`. Use `[[..]]` instead.");
            this.put("SC2076", "Don't quote rhs of =~, it'll match literally rather than as a regex.");
            this.put("SC2077", "You need spaces around the comparison operator.");
            this.put("SC2078", "This expression is constant. Did you forget a `$` somewhere?");
            this.put("SC2079", "(( )) doesn't support decimals. Use bc or awk.");
            this.put("SC2080", "Numbers with leading 0 are considered octal.");
            this.put("SC2081", "`[ .. ]` can't match globs. Use `[[ .. ]]` or grep.");
            this.put("SC2082", "To expand via indirection, use name=\"foo$n\"; echo \"${!name}\".");
            this.put("SC2084", "Remove '$' or use '_=$((expr))' to avoid executing output.");
            this.put("SC2086", "Double quote to prevent globbing and word splitting.");
            this.put("SC2087", "Quote 'EOF' to make here document expansions happen on the server side rather than on the client.");
            this.put("SC2088", "Tilde does not expand in quotes. Use $HOME.");
            this.put("SC2089", "Quotes/backslashes will be treated literally. Use an array.");
            this.put("SC2090", "Quotes/backslashes in this variable will not be respected.");
            this.put("SC2091", "Remove surrounding $() to avoid executing output.");
            this.put("SC2092", "Remove backticks to avoid executing output.");
            this.put("SC2093", "Remove \"exec \" if script should continue after this command.");
            this.put("SC2094", "SC2094 Make sure not to read and write the same file in the same pipeline.");
            this.put("SC2095", "Add < /dev/null to prevent ssh from swallowing stdin.");
            this.put("SC2096", "On most OS, shebangs can only specify a single parameter.");
            this.put("SC2097", "This assignment is only seen by the forked process.");
            this.put("SC2098", "This expansion will not see the mentioned assignment.");
            this.put("SC2099", "Use `$((..))` for arithmetics, e.g. `i=$((i + 2))`");
            this.put("SC2100", "Use `$((..))` for arithmetics, e.g. `i=$((i + 2))`");
            this.put("SC2101", "Named class needs outer [], e.g. [[:digit:]\\].");
            this.put("SC2102", "Ranges can only match single chars (mentioned due to duplicates).");
            this.put("SC2103", "Use a ( subshell ) to avoid having to cd back.");
            this.put("SC2104", "In functions, use return instead of break.");
            this.put("SC2105", "`break` is only valid in loops");
            this.put("SC2106", "SC2106: This only exits the subshell caused by the pipeline.");
            this.put("SC2107", "Instead of [ a && b ], use [ a ] && [ b ].");
            this.put("SC2108", "In [\\[..]], use && instead of -a.");
            this.put("SC2109", "Instead of [ a || b ], use [ a ] || [ b ].");
            this.put("SC2110", "In [\\[..]], use || instead of -o.");
            this.put("SC2112", "'function' keyword is non-standard. Delete it.");
            this.put("SC2114", "Warning: deletes a system directory.");
            this.put("SC2115", "Use \"${var:?}\" to ensure this never expands to /* .");
            this.put("SC2116", "Useless echo? Instead of 'cmd $(echo foo)', just use 'cmd foo'.");
            this.put("SC2117", "To run commands as another user, use su -c or sudo.");
            this.put("SC2119", "Use foo \"$@\" if function's $1 should mean script's $1.");
            this.put("SC2120", "foo references arguments, but none are ever passed.");
            this.put("SC2121", "To assign a variable, use just 'var=value', no 'set ..'.");
            this.put("SC2122", ">= is not a valid operator. Use '! a < b' instead.");
            this.put("SC2123", "PATH is the shell search path. Use another name.");
            this.put("SC2124", "Assigning an array to a string! Assign as array, or use * instead of @ to concatenate.");
            this.put("SC2125", "Brace expansions and globs are literal in assignments. Quote it or use an array.");
            this.put("SC2126", "Consider using grep -c instead of grep|wc.");
            this.put("SC2128", "Expanding an array without an index only gives the first element.");
            this.put("SC2129", "Consider using { cmd1; cmd2; } >> file instead of individual redirects.");
            this.put("SC2130", "-eq is for integer comparisons. Use = instead.");
            this.put("SC2139", "This expands when defined, not when used. Consider escaping.");
            this.put("SC2140", " Word is on the form \"A\"B\"C\" (B indicated). Did you mean \"ABC\" or \"A\\\"B\\\"C\"?");
            this.put("SC2141", "Did you mean IFS=$'\t' ?");
            this.put("SC2142", "Aliases can't use positional parameters. Use a function.");
            this.put("SC2143", "Use grep -q instead of comparing output with [ -n .. ].");
            this.put("SC2144", "-e doesn't work with globs. Use a for loop.");
            this.put("SC2145", "Argument mixes string and array. Use * or separate argument.");
            this.put("SC2146", "This action ignores everything before the -o. Use \\( \\) to group.");
            this.put("SC2147", "Literal tilde in PATH works poorly across programs.");
            this.put("SC2148", "Tips depend on target shell and yours is unknown. Add a shebang.");
            this.put("SC2149", "Remove $/${} for numeric index, or escape it for string.");
            this.put("SC2150", "-exec does not automatically invoke a shell. Use -exec sh -c .. for that.");
            this.put("SC2151", "Only one integer 0-255 can be returned. Use stdout for other data.");
            this.put("SC2152", "Can only return 0-255. Other data should be written to stdout.");
            this.put("SC2153", "Possible Misspelling: MYVARIABLE may not be assigned, but MY_VARIABLE is.");
            this.put("SC2154", "var is referenced but not assigned.");
            this.put("SC2155", "Declare and assign separately to avoid masking return values.");
            this.put("SC2156", "Injecting filenames is fragile and insecure. Use parameters.");
            this.put("SC2157", "Argument to implicit -n is always true due to literal strings.");
            this.put("SC2158", "[ false ] is true. Remove the brackets");
            this.put("SC2159", "[ 0 ] is true. Use 'false' instead");
            this.put("SC2160", "Instead of '[ true ]', just use 'true'.");
            this.put("SC2161", "Instead of '[ 1 ]', use 'true'.");
            this.put("SC2162", "read without -r will mangle backslashes");
            this.put("SC2163", "This does not export 'FOO'. Remove $/${} for that, or use ${var?} to quiet.");
            this.put("SC2164", "Use cd ... || exit in case cd fails.");
            this.put("SC2165", "This nested loop overrides the index variable of its parent.");
            this.put("SC2166", "Prefer [ p ] && [ q ] as [ p -a q ] is not well defined.");
            this.put("SC2167", "This parent loop has its index variable overridden.");
            this.put("SC2168", "'local' is only valid in functions.");
            this.put("SC2169", "In dash, *something* is not supported.");
            this.put("SC2170", "Numerical -eq does not dereference in [..]. Expand or use string operator.");
            this.put("SC2172", "Trapping signals by number is not well defined. Prefer signal names.");
            this.put("SC2173", "SIGKILL/SIGSTOP can not be trapped.");
            this.put("SC2174", "When used with -p, -m only applies to the deepest directory.");
            this.put("SC2175", "Quote this invalid brace expansion since it should be passed literally to eval");
            this.put("SC2176", "'time' is undefined for pipelines. time single stage or bash -c instead.");
            this.put("SC2177", "'time' is undefined for compound commands, time sh -c instead.");
            this.put("SC2178", "Variable was used as an array but is now assigned a string.");
            this.put("SC2179", "Use array+=(\"item\") to append items to an array.");
            this.put("SC2180", "Bash does not support multidimensional arrays. Use 1D or associative arrays.");
            this.put("SC2181", "Check exit code directly with e.g. 'if mycmd;', not indirectly with $?.");
            this.put("SC2182", "This printf format string has no variables. Other arguments are ignored.");
            this.put("SC2183", "This format string has 2 variables, but is passed 1 arguments.");
            this.put("SC2184", "Quote arguments to unset so they're not glob expanded.");
            this.put("SC2185", "Some finds don't have a default path. Specify '.' explicitly.");
            this.put("SC2186", "tempfile is deprecated. Use mktemp instead.");
            this.put("SC2187", "Ash scripts will be checked as Dash. Add '# shellcheck shell=dash' to silence.");
            this.put("SC2188", "This redirection doesn't have a command. Move to its command (or use 'true' as no-op).");
            this.put("SC2189", "You can't have | between this redirection and the command it should apply to.");
            this.put("SC2190", "Elements in associative arrays need index, e.g. array=( [index]=value ) .");
            this.put("SC2191", "The = here is literal. To assign by index, use ( [index]=value ) with no spaces. To keep as literal, quote it.");
            this.put("SC2192", "This array element has no value. Remove spaces after = or use \"\" for empty string.");
            this.put("SC2193", "The arguments to this comparison can never be equal. Make sure your syntax is correct.");
            this.put("SC2194", "This word is constant. Did you forget the $ on a variable?");
            this.put("SC2195", "This pattern will never match the case statement's word. Double check them.");
            this.put("SC2196", "egrep is non-standard and deprecated. Use grep -E instead.");
            this.put("SC2197", "fgrep is non-standard and deprecated. Use grep -F instead.");
            this.put("SC2198", "Arrays don't work as operands in [ ]. Use a loop (or concatenate with * instead of @).");
            this.put("SC2199", "Arrays implicitly concatenate in `[[ ]]`. Use a loop (or explicit * instead of @).");
            this.put("SC2200", "Brace expansions don't work as operands in [ ]. Use a loop.");
            this.put("SC2201", "Brace expansion doesn't happen in `[[ ]]`. Use a loop.");
            this.put("SC2202", "Globs don't work as operands in [ ]. Use a loop.");
            this.put("SC2203", "Globs are ignored in `[[ ]]` except right of =/!=. Use a loop.");
            this.put("SC2204", "(..) is a subshell. Did you mean [ .. ], a test expression?");
            this.put("SC2205", "(..) is a subshell. Did you mean [ .. ], a test expression?");
            this.put("SC2206", "Quote to prevent word splitting, or split robustly with mapfile or read -a.");
            this.put("SC2207", "Prefer mapfile or read -a to split command output (or quote to avoid splitting).");
            this.put("SC2208", "Use `[[ ]]` or quote arguments to -v to avoid glob expansion.");
            this.put("SC2209", "Use var=$(command) to assign output (or quote to assign string).");
            this.put("SC2210", "This is a file redirection. Was it supposed to be a comparison or fd operation?");
            this.put("SC2211", "This is a glob used as a command name. Was it supposed to be in ${..}, array, or is it missing quoting?");
            this.put("SC2212", "Use 'false' instead of empty [/[[ conditionals.");
            this.put("SC2213", "getopts specified -n, but it's not handled by this 'case'.");
            this.put("SC2214", "This case is not specified by getopts.");
            this.put("SC2215", "This flag is used as a command name. Bad line break or missing `[ .. ]`?");
            this.put("SC2216", "Piping to 'rm', a command that doesn't read stdin. Wrong command or missing xargs?");
            this.put("SC2217", "Redirecting to 'echo', a command that doesn't read stdin. Bad quoting or missing xargs?");
            this.put("SC2218", "This function is only defined later. Move the definition up.");
            this.put("SC2219", "Instead of `let expr`, prefer `(( expr ))` .");
            this.put("SC2220", "Invalid flags are not handled. Add a `*)` case.");
            this.put("SC2221", "This pattern always overrides a later one.");
            this.put("SC2222", "This pattern never matches because of a previous pattern.");
            this.put("SC2223", "This default assignment may cause DoS due to globbing. Quote it.");
            this.put("SC2224", "This mv has no destination. Check the arguments.");
            this.put("SC2225", "This cp has no destination. Check the arguments.");
            this.put("SC2226", "This ln has no destination. Check the arguments, or specify '.' explicitly.");
            this.put("SC2227", "Redirection applies to the find command itself. Rewrite to work per action (or move to end).");
            this.put("SC2229", "This does not read 'foo'. Remove $/${} for that, or use ${var?} to quiet.");
            this.put("SC2230", "which is non-standard. Use builtin 'command -v' instead.");
            this.put("SC2231", "Quote expansions in this for loop glob to prevent wordsplitting, e.g. \"$dir\"/*.txt .");
            this.put("SC2232", "Can't use sudo with builtins like cd. Did you want sudo sh -c .. instead?");
            this.put("SC2233", "Remove superfluous `(..)` around condition.");
            this.put("SC2234", "Remove superfluous `(..)` around test command.");
            this.put("SC2235", "Use `{ ..; }` instead of `(..)` to avoid subshell overhead.");
            this.put("SC2236", "Use `-n` instead of `! -z`.");
            this.put("SC2237", "Use `[ -n .. ]` instead of `! [ -z .. ]`.");
            this.put("SC2238", "Redirecting to/from command name instead of file. Did you want pipes/xargs (or quote to ignore)?");
            this.put("SC2239", "Ensure the shebang uses the absolute path to the interpreter.");
            this.put("SC2240", "The dot command does not support arguments in sh/dash. Set them as variables.");
            this.put("SC2241", "The exit status can only be one integer 0-255. Use stdout for other data.");
            this.put("SC2242", "Can only exit with status 0-255. Other data should be written to stdout/stderr.");
            this.put("SC2243", "Prefer explicit -n to check for output (or run command without [/[[ to check for success)");
            this.put("SC2244", "Prefer explicit -n to check non-empty string (or use =/-ne to check boolean/integer).");
            this.put("SC2245", "-d only applies to the first expansion of this glob. Use a loop to check any/all.");
            this.put("SC2246", "This shebang specifies a directory. Ensure the interpreter is a file.");
            this.put("SC2247", "Flip leading $ and \" if this should be a quoted substitution.");
            this.put("SC2249", "Consider adding a default *) case, even if it just exits with error.");
        }
    };

    ShShellcheckUtil() {
    }

    static void download(@Nullable Project project, final @NotNull Runnable onSuccess, final @NotNull Runnable onFailure) {
        File shellcheck;
        File directory;
        if (onSuccess == null) {
            ShShellcheckUtil.$$$reportNull$$$0(0);
        }
        if (onFailure == null) {
            ShShellcheckUtil.$$$reportNull$$$0(1);
        }
        if (!(directory = new File(DOWNLOAD_PATH)).exists()) {
            directory.mkdirs();
        }
        if ((shellcheck = new File(DOWNLOAD_PATH + File.separator + SHELLCHECK + (SystemInfo.isWindows ? WINDOWS_EXTENSION : ""))).exists()) {
            try {
                String path = ShSettings.getShellcheckPath();
                String shellcheckPath = shellcheck.getCanonicalPath();
                if (StringUtil.isNotEmpty((String)path) && path.equals(shellcheckPath)) {
                    LOG.debug("Shellcheck already downloaded");
                } else {
                    ShSettings.setShellcheckPath(shellcheckPath);
                }
                ApplicationManager.getApplication().invokeLater(onSuccess);
                return;
            }
            catch (IOException e) {
                LOG.debug("Can't evaluate shellcheck path", (Throwable)e);
                ApplicationManager.getApplication().invokeLater(onFailure);
                return;
            }
        }
        String url = ShShellcheckUtil.getShellcheckDistributionLink();
        if (StringUtil.isEmpty((String)url)) {
            LOG.debug("Unsupported OS for shellcheck");
            return;
        }
        String downloadName = "shellcheck.tar.gz";
        DownloadableFileService service = DownloadableFileService.getInstance();
        DownloadableFileDescription description = service.createFileDescription(url, downloadName);
        final FileDownloader downloader = service.createDownloader(Collections.singletonList(description), downloadName);
        Task.Backgroundable task = new Task.Backgroundable(project, ShBundle.message("sh.shellcheck.download.label.text", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    String path;
                    File file;
                    List pairs = downloader.download(new File(DOWNLOAD_PATH));
                    Pair first = (Pair)ContainerUtil.getFirstItem((List)pairs);
                    File file2 = file = first != null ? (File)first.first : null;
                    if (file != null && StringUtil.isNotEmpty((String)(path = ShShellcheckUtil.decompressShellcheck(file.getCanonicalPath(), directory)))) {
                        FileUtil.setExecutable((File)new File(path));
                        ShSettings.setShellcheckPath(path);
                        ApplicationManager.getApplication().invokeLater(onSuccess);
                        ShFeatureUsagesCollector.logFeatureUsage(ShShellcheckUtil.FEATURE_ACTION_ID);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Can't download shellcheck", (Throwable)e);
                    ApplicationManager.getApplication().invokeLater(onFailure);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sh/shellcheck/ShShellcheckUtil$1", "run"));
            }
        };
        BackgroundableProcessIndicator processIndicator = new BackgroundableProcessIndicator(task);
        processIndicator.setIndeterminate(false);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)processIndicator);
    }

    static boolean isExecutionValidPath(@Nullable String path) {
        if (path == null || "I do mind".equals(path)) {
            return false;
        }
        File file = new File(path);
        return file.canExecute() && file.getName().contains(SHELLCHECK);
    }

    static boolean isValidPath(@Nullable String path) {
        if (path == null) {
            return false;
        }
        if ("I do mind".equals(path)) {
            return true;
        }
        File file = new File(path);
        return file.canExecute() && file.getName().contains(SHELLCHECK);
    }

    @NotNull
    static String decompressShellcheck(@NotNull String tarPath, File directory) throws IOException {
        if (tarPath == null) {
            ShShellcheckUtil.$$$reportNull$$$0(2);
        }
        File archive = new File(tarPath);
        Decompressor.Tar tar = new Decompressor.Tar(archive);
        File tmpDir = new File(directory, "tmp");
        tar.postprocessor(outputFile -> {
            try {
                FileUtil.copyDir((File)outputFile.getParentFile(), (File)directory);
            }
            catch (IOException e) {
                LOG.warn("Can't decompressor shellcheck", (Throwable)e);
            }
        });
        tar.extract(tmpDir);
        FileUtil.delete((File)tmpDir);
        FileUtil.delete((File)archive);
        File shellcheck = new File(directory, SHELLCHECK + (SystemInfo.isWindows ? WINDOWS_EXTENSION : ""));
        return shellcheck.exists() ? shellcheck.getCanonicalPath() : "";
    }

    @Nullable
    private static String getShellcheckDistributionLink() {
        String platform = ShShellcheckUtil.getPlatform();
        if (platform == null) {
            return null;
        }
        return "https://jetbrains.bintray.com/intellij-third-party-dependencies/org/jetbrains/intellij/deps/shellcheck/0.6.0-1/" + platform + SHELLCHECK_ARCHIVE_EXTENSION;
    }

    @Nullable
    private static String getPlatform() {
        if (SystemInfo.isMac) {
            return "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        if (SystemInfo.isWindows) {
            return "windows";
        }
        return null;
    }

    static int calcOffset(CharSequence sequence, int startOffset, int column) {
        int i = 1;
        while (i < column) {
            int c = Character.codePointAt(sequence, startOffset);
            i += c == 9 ? 8 : 1;
            ++startOffset;
        }
        return startOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/shellcheck/ShShellcheckUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "download";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "decompressShellcheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

