/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.structureView;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.structureView.JsonCustomStructureViewFactory;
import com.intellij.json.structureView.JsonStructureViewModel;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStructureViewBuilderFactory
implements PsiStructureViewFactory {
    public JsonStructureViewBuilderFactory() {
        JsonCustomStructureViewFactory.EP_NAME.addExtensionPointListener(() -> ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(StructureViewWrapperImpl.STRUCTURE_CHANGED)).run(), ExtensionPointUtil.createKeyedExtensionDisposable((Object)this, (ExtensionPoint)PsiStructureViewFactory.EP_NAME.getPoint(null)));
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JsonStructureViewBuilderFactory.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof JsonFile)) {
            return null;
        }
        List extensionList = JsonCustomStructureViewFactory.EP_NAME.getExtensionList();
        if (extensionList.size() > 1) {
            Logger.getInstance(JsonStructureViewBuilderFactory.class).warn("Several extensions are registered for JsonCustomStructureViewFactory extension point. Conflicts can arise if there are several builders corresponding to the same file.");
        }
        for (JsonCustomStructureViewFactory extension : extensionList) {
            StructureViewBuilder builder = extension.getStructureViewBuilder((JsonFile)psiFile);
            if (builder == null) continue;
            return builder;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new JsonStructureViewModel(psiFile, editor);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/json/structureView/JsonStructureViewBuilderFactory", "getStructureViewBuilder"));
    }
}

