/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.io.ConnectToChannelResult;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u001d\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H&J\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J.\u0010\u001b\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0014J(\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0007R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "VmT", "Lorg/jetbrains/debugger/Vm;", "Lorg/jetbrains/debugger/connection/VmConnection;", "()V", "address", "Ljava/net/InetSocketAddress;", "getAddress", "()Ljava/net/InetSocketAddress;", "setAddress", "(Ljava/net/InetSocketAddress;)V", "connectCancelHandler", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Function0;", "", "connectedAddressToPresentation", "", "vm", "connectionSucceeded", "it", "(Lorg/jetbrains/debugger/Vm;Ljava/net/InetSocketAddress;)V", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "doOpen", "result", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "open", "intellij.platform.scriptDebugger.ui"})
public abstract class RemoteVmConnection<VmT extends Vm>
extends VmConnection<VmT> {
    @Nullable
    private InetSocketAddress address;
    private final AtomicReference<Function0<Unit>> connectCancelHandler = new AtomicReference();

    @Nullable
    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public final void setAddress(@Nullable InetSocketAddress inetSocketAddress) {
        this.address = inetSocketAddress;
    }

    @NotNull
    public abstract Bootstrap createBootstrap(@NotNull InetSocketAddress var1, @NotNull AsyncPromise<VmT> var2);

    @JvmOverloads
    @NotNull
    public final Promise<VmT> open(@NotNull InetSocketAddress address, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        if (address.isUnresolved()) {
            String error = "Host " + address.getHostString() + " is unresolved";
            VmConnection.setState$default(this, ConnectionStatus.CONNECTION_FAILED, error, null, 4, null);
            return Promises.rejectedPromise((String)error);
        }
        this.address = address;
        VmConnection.setState$default(this, ConnectionStatus.WAITING_FOR_CONNECTION, "Connecting to " + address.getHostString() + ':' + address.getPort(), null, 4, null);
        AsyncPromise result2 = new AsyncPromise();
        result2.onSuccess(new Consumer<VmT>(this, address){
            final /* synthetic */ RemoteVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address;

            public final void accept(@NotNull VmT it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.this$0.connectionSucceeded(it, this.$address);
            }
            {
                this.this$0 = remoteVmConnection;
                this.$address = inetSocketAddress;
            }
        }).onError((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ RemoteVmConnection this$0;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (!(it instanceof ConnectException)) {
                    Promises.errorIfNotMessage((Logger)CommandProcessorKt.getLOG(), (Throwable)it);
                }
                VmConnection.setState$default(this.this$0, ConnectionStatus.CONNECTION_FAILED, it.getMessage(), null, 4, null);
            }
            {
                this.this$0 = remoteVmConnection;
            }
        }).onProcessed(new Consumer<VmT>(this){
            final /* synthetic */ RemoteVmConnection this$0;

            public final void accept(@Nullable VmT it) {
                RemoteVmConnection.access$getConnectCancelHandler$p(this.this$0).set(null);
            }
            {
                this.this$0 = remoteVmConnection;
            }
        });
        java.util.concurrent.Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, result2, address, stopCondition){
            final /* synthetic */ RemoteVmConnection this$0;
            final /* synthetic */ AsyncPromise $result;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ Condition $stopCondition;

            public final void run() {
                if (Thread.interrupted()) {
                    return;
                }
                RemoteVmConnection.access$getConnectCancelHandler$p(this.this$0).set(new Function0<Unit>(this){
                    final /* synthetic */ open.future.1 this$0;

                    public final void invoke() {
                        this.this$0.$result.setError("Closed explicitly");
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                this.this$0.doOpen(this.$result, this.$address, (Condition<Void>)this.$stopCondition);
            }
            {
                this.this$0 = remoteVmConnection;
                this.$result = asyncPromise;
                this.$address = inetSocketAddress;
                this.$stopCondition = condition;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)future2, (String)"ApplicationManager.getAp\u2026ess, stopCondition)\n    }");
        java.util.concurrent.Future future3 = future2;
        this.connectCancelHandler.set(new Function0<Unit>(future3, result2){
            final /* synthetic */ java.util.concurrent.Future $future;
            final /* synthetic */ AsyncPromise $result;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    this.$future.cancel(true);
                }
                finally {
                    this.$result.setError("Cancelled");
                }
            }
            {
                this.$future = future2;
                this.$result = asyncPromise;
                super(0);
            }
        });
        return (Promise)result2;
    }

    public static /* synthetic */ Promise open$default(RemoteVmConnection remoteVmConnection, InetSocketAddress inetSocketAddress, Condition condition, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: open");
        }
        if ((n & 2) != 0) {
            condition = null;
        }
        return remoteVmConnection.open(inetSocketAddress, (Condition<Void>)condition);
    }

    @JvmOverloads
    @NotNull
    public final Promise<VmT> open(@NotNull InetSocketAddress address) {
        return RemoteVmConnection.open$default(this, address, null, 2, null);
    }

    protected final void connectionSucceeded(@NotNull VmT it, @NotNull InetSocketAddress address) {
        Intrinsics.checkParameterIsNotNull(it, (String)"it");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.setVm(it);
        VmConnection.setState$default(this, ConnectionStatus.CONNECTED, "Connected to " + this.connectedAddressToPresentation(address, (Vm)it), null, 4, null);
        this.startProcessing();
    }

    protected void doOpen(@NotNull AsyncPromise<VmT> result2, @NotNull InetSocketAddress address, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        int maxAttemptCount = stopCondition == null ? 20 : -1;
        Condition resultRejected2 = (Condition)new Condition<Void>(result2){
            final /* synthetic */ AsyncPromise $result;

            public final boolean value(Void it) {
                return this.$result.getState() == Promise.State.REJECTED;
            }
            {
                this.$result = asyncPromise;
            }
        };
        Condition condition = stopCondition;
        if (condition == null) {
            condition = Conditions.alwaysFalse();
        }
        Condition condition2 = Conditions.or((Condition)condition, (Condition)resultRejected2);
        Intrinsics.checkExpressionValueIsNotNull((Object)condition2, (String)"Conditions.or(stopCondit\u2026sFalse(), resultRejected)");
        Condition combinedCondition = condition2;
        ConnectToChannelResult connectResult = NettyKt.connectRetrying((Bootstrap)this.createBootstrap(address, result2), (InetSocketAddress)address, (int)maxAttemptCount, (Condition)combinedCondition);
        connectResult.handleError((Consumer)new Consumer<String>(result2){
            final /* synthetic */ AsyncPromise $result;

            public final void accept(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$result.setError(it);
            }
            {
                this.$result = asyncPromise;
            }
        });
        connectResult.handleThrowable((Consumer)new Consumer<Throwable>(result2){
            final /* synthetic */ AsyncPromise $result;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$result.setError(it);
            }
            {
                this.$result = asyncPromise;
            }
        });
        Channel channel = connectResult.getChannel();
        Channel channel2 = channel;
        if (channel2 != null && (channel2 = channel2.closeFuture()) != null) {
            channel2.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, result2){
                final /* synthetic */ RemoteVmConnection this$0;
                final /* synthetic */ AsyncPromise $result;

                public final void operationComplete(Future<? super Void> it) {
                    if (this.$result.isSucceeded()) {
                        this.this$0.close("Process disconnected unexpectedly", ConnectionStatus.DISCONNECTED);
                    }
                }
                {
                    this.this$0 = remoteVmConnection;
                    this.$result = asyncPromise;
                }
            });
        }
        if (channel != null) {
            this.stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(channel){
                final /* synthetic */ Channel $channel;

                public final void invoke(@NotNull ConnectionState it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (it.getStatus() == ConnectionStatus.DISCONNECTED) {
                        this.$channel.close();
                    }
                }
                {
                    this.$channel = channel;
                    super(1);
                }
            }));
        }
    }

    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        return address.getHostName() + ':' + address.getPort();
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public Promise<?> detachAndClose() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Removing goto target
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.removeTarget(Op03SimpleStatement.java:365)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.nopOut(Op03SimpleStatement.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.PointlessExpressions.removePointlessExpressionStatements(PointlessExpressions.java:28)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.removePointlessExpressionStatements(Op03Rewriters.java:185)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:561)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final /* synthetic */ AtomicReference access$getConnectCancelHandler$p(RemoteVmConnection $this) {
        return $this.connectCancelHandler;
    }
}

