/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.IntIntHashMap;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XFetchValueActionBase
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            XFetchValueActionBase.$$$reportNull$$$0(0);
        }
        for (XValueNodeImpl node : XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext())) {
            if (!this.isEnabled(e, node)) continue;
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    protected boolean isEnabled(@NotNull AnActionEvent event, @NotNull XValueNodeImpl node) {
        if (event == null) {
            XFetchValueActionBase.$$$reportNull$$$0(1);
        }
        if (node == null) {
            XFetchValueActionBase.$$$reportNull$$$0(2);
        }
        if (node instanceof WatchNodeImpl || node.isComputed()) {
            event.getPresentation().setEnabled(true);
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<XValueNodeImpl> nodes;
        if (e == null) {
            XFetchValueActionBase.$$$reportNull$$$0(3);
        }
        if ((nodes = XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext())).isEmpty()) {
            return;
        }
        ValueCollector valueCollector = this.createCollector(e);
        for (XValueNodeImpl node : nodes) {
            this.addToCollector(nodes, node, valueCollector);
        }
        valueCollector.processed = true;
        valueCollector.finish();
    }

    protected void addToCollector(@NotNull List<XValueNodeImpl> paths, @NotNull XValueNodeImpl valueNode, @NotNull ValueCollector valueCollector) {
        if (paths == null) {
            XFetchValueActionBase.$$$reportNull$$$0(4);
        }
        if (valueNode == null) {
            XFetchValueActionBase.$$$reportNull$$$0(5);
        }
        if (valueCollector == null) {
            XFetchValueActionBase.$$$reportNull$$$0(6);
        }
        if (paths.size() > 1) {
            valueCollector.add(valueNode.getText().toString(), valueNode.getPath().getPathCount());
        } else {
            XFullValueEvaluator fullValueEvaluator = valueNode.getFullValueEvaluator();
            if (fullValueEvaluator == null || !fullValueEvaluator.isShowValuePopup()) {
                valueCollector.add(StringUtil.notNullize((String)DebuggerUIUtil.getNodeRawValue(valueNode)));
            } else {
                new CopyValueEvaluationCallback(valueNode, valueCollector).startFetchingValue(fullValueEvaluator);
            }
        }
    }

    @NotNull
    protected ValueCollector createCollector(@NotNull AnActionEvent e) {
        if (e == null) {
            XFetchValueActionBase.$$$reportNull$$$0(7);
        }
        return new ValueCollector(XDebuggerTree.getTree(e.getDataContext()));
    }

    protected abstract void handle(Project var1, String var2, XDebuggerTree var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueCollector";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addToCollector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createCollector";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CopyValueEvaluationCallback
    extends HeadlessValueEvaluationCallback {
        private final int myValueIndex;
        private final ValueCollector myValueCollector;

        CopyValueEvaluationCallback(@NotNull XValueNodeImpl node, @NotNull ValueCollector valueCollector) {
            if (node == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(0);
            }
            if (valueCollector == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(1);
            }
            super(node);
            this.myValueCollector = valueCollector;
            this.myValueIndex = valueCollector.acquire();
        }

        @Override
        protected void evaluationComplete(@NotNull String value2, @NotNull Project project) {
            if (value2 == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(2);
            }
            if (project == null) {
                CopyValueEvaluationCallback.$$$reportNull$$$0(3);
            }
            this.myValueCollector.evaluationComplete(this.myValueIndex, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueCollector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluationComplete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ValueCollector {
        private final List<String> values = new SmartList();
        private final IntIntHashMap indents = new IntIntHashMap();
        private final XDebuggerTree myTree;
        private volatile boolean processed;

        public ValueCollector(XDebuggerTree tree) {
            this.myTree = tree;
        }

        public void add(@NotNull String value2) {
            if (value2 == null) {
                ValueCollector.$$$reportNull$$$0(0);
            }
            this.values.add(value2);
        }

        public void add(@NotNull String value2, int indent) {
            if (value2 == null) {
                ValueCollector.$$$reportNull$$$0(1);
            }
            this.values.add(value2);
            this.indents.put(this.values.size() - 1, indent);
        }

        public void finish() {
            Project project = this.myTree.getProject();
            if (this.processed && !this.values.contains(null) && !project.isDisposed()) {
                int minIndent = Integer.MAX_VALUE;
                for (int indent : this.indents.getValues()) {
                    minIndent = Math.min(minIndent, indent);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.values.size(); ++i) {
                    int indent;
                    if (i > 0) {
                        sb.append("\n");
                    }
                    if ((indent = this.indents.get(i)) > 0) {
                        StringUtil.repeatSymbol((Appendable)sb, (char)' ', (int)(indent - minIndent));
                    }
                    sb.append(this.values.get(i));
                }
                this.handleInCollector(project, sb.toString(), this.myTree);
            }
        }

        public void handleInCollector(Project project, String value2, XDebuggerTree tree) {
            XFetchValueActionBase.this.handle(project, value2, tree);
        }

        public int acquire() {
            int index = this.values.size();
            this.values.add(null);
            return index;
        }

        public void evaluationComplete(int index, @NotNull String value2) {
            if (value2 == null) {
                ValueCollector.$$$reportNull$$$0(2);
            }
            AppUIUtil.invokeOnEdt(() -> {
                this.values.set(index, value2);
                this.finish();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluationComplete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

