/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.legacyBridge.libraries.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.util.Disposer;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspace.UtilsKt;
import com.intellij.workspace.api.EntityChange;
import com.intellij.workspace.api.EntityStoreChanged;
import com.intellij.workspace.api.LibraryEntity;
import com.intellij.workspace.api.LibraryId;
import com.intellij.workspace.api.LibraryTableId;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.api.TypedEntityStore;
import com.intellij.workspace.ide.WorkspaceModel;
import com.intellij.workspace.ide.WorkspaceModelChangeListener;
import com.intellij.workspace.ide.WorkspaceModelTopics;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyBridgeLibraryImpl;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyBridgeLibraryModifiableModelImpl;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyBridgeProjectLibraryTable;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyBridgeProjectLibraryTableImpl;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyBridgeProjectModifiableLibraryTableImpl;
import com.intellij.workspace.legacyBridge.typedModel.library.LibraryViaTypedEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0016\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016J\b\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001fH\u0016J\u0018\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u001b\u00105\u001a\u00020\u00192\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001207H\u0001\u00a2\u0006\u0002\b8R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeProjectLibraryTableImpl;", "Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeProjectLibraryTable;", "Lcom/intellij/openapi/Disposable;", "parentProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "kotlin.jvm.PlatformType", "entityStore", "Lcom/intellij/workspace/api/TypedEntityStore;", "librariesMap", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/workspace/api/LibraryId;", "Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeLibraryImpl;", "libraryNameMap", "Lcom/intellij/util/containers/ConcurrentMultiMap;", "", "newLibraryInstances", "", "addLibraryToMaps", "", "library", "addListener", "listener", "parentDisposable", "createLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "name", "dispose", "getLibraries", "", "()[Lcom/intellij/openapi/roots/libraries/Library;", "getLibraryByName", "getLibraryIterator", "", "getModifiableModel", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "diff", "Lcom/intellij/workspace/api/TypedEntityStorageBuilder;", "getPresentation", "Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "getProject", "getTableLevel", "removeLibrary", "removeLibraryFromMaps", "id", "libraryImpl", "removeListener", "setNewLibraryInstances", "addedInstances", "", "setNewLibraryInstances$intellij_platform_workspaceModel_ide", "Companion", "intellij.platform.workspaceModel.ide"})
public final class LegacyBridgeProjectLibraryTableImpl
implements LegacyBridgeProjectLibraryTable,
Disposable {
    private final Logger LOG;
    private final ConcurrentMap<LibraryId, LegacyBridgeLibraryImpl> librariesMap;
    private final ConcurrentMultiMap<String, LegacyBridgeLibraryImpl> libraryNameMap;
    private final Map<LibraryId, LegacyBridgeLibraryImpl> newLibraryInstances;
    private final TypedEntityStore entityStore;
    private final EventDispatcher<LibraryTable.Listener> dispatcher;
    private final Project parentProject;
    @NotNull
    private static final LibraryTablePresentation PROJECT_LIBRARY_TABLE_PRESENTATION;
    public static final Companion Companion;

    @ApiStatus.Internal
    public final void setNewLibraryInstances$intellij_platform_workspaceModel_ide(@NotNull List<LegacyBridgeLibraryImpl> addedInstances) {
        Intrinsics.checkParameterIsNotNull(addedInstances, (String)"addedInstances");
        Object object = this.newLibraryInstances;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = "setNewLibraryInstances are not empty";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        for (LegacyBridgeLibraryImpl instance : addedInstances) {
            this.newLibraryInstances.put(instance.getLibraryId(), instance);
        }
    }

    private final void removeLibraryFromMaps(LibraryId id2, LegacyBridgeLibraryImpl libraryImpl) {
        this.librariesMap.remove(id2);
        boolean bl = false;
        List namesToRemove = new ArrayList();
        for (Map.Entry entry : this.libraryNameMap.entrySet()) {
            if (!((Collection)entry.getValue()).contains(libraryImpl)) continue;
            Object k = entry.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"entry.key");
            namesToRemove.add(k);
        }
        for (String name : namesToRemove) {
            this.libraryNameMap.remove((Object)name, (Object)libraryImpl);
        }
    }

    private final void addLibraryToMaps(LegacyBridgeLibraryImpl library) {
        LibraryId entityId = library.getEntityId();
        LegacyBridgeLibraryImpl existingLibrary = this.librariesMap.put(entityId, library);
        if (existingLibrary != null) {
            String string = "Library with " + entityId + " was already exist";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.libraryNameMap.putValue((Object)entityId.getName(), (Object)library);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.parentProject;
    }

    @NotNull
    public Library[] getLibraries() {
        Collection $this$toTypedArray$iv = this.librariesMap.values();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Library[] libraryArray = thisCollection$iv.toArray(new Library[0]);
        if (libraryArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return libraryArray;
    }

    @NotNull
    public Library createLibrary() {
        return this.createLibrary(null);
    }

    @NotNull
    public Library createLibrary(@Nullable String name) {
        if (name == null) {
            String string = "Creating unnamed project libraries is unsupported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.getLibraryByName(name) != null) {
            String string = "Project library named " + name + " already exists";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.createLibrary(name);
        modifiableModel.commit();
        Library newLibrary2 = this.getLibraryByName(name);
        if (newLibrary2 == null) {
            String string = "Library " + name + " was not created";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return newLibrary2;
    }

    public void removeLibrary(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        return CollectionsKt.toMutableList(this.librariesMap.values()).iterator();
    }

    @Nullable
    public Library getLibraryByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Collection collection = this.libraryNameMap.get((Object)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"libraryNameMap[name]");
        return (Library)CollectionsKt.firstOrNull((Iterable)collection);
    }

    @NotNull
    public String getTableLevel() {
        return "project";
    }

    @NotNull
    public LibraryTablePresentation getPresentation() {
        return PROJECT_LIBRARY_TABLE_PRESENTATION;
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        TypedEntityStorageBuilder typedEntityStorageBuilder = null;
        TypedEntityStorage typedEntityStorage = this.entityStore.getCurrent();
        Project project = this.getProject();
        LegacyBridgeProjectLibraryTableImpl legacyBridgeProjectLibraryTableImpl = this;
        return new LegacyBridgeProjectModifiableLibraryTableImpl(typedEntityStorage, legacyBridgeProjectLibraryTableImpl, project, typedEntityStorageBuilder, 8, null);
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel(@NotNull TypedEntityStorageBuilder diff) {
        Intrinsics.checkParameterIsNotNull((Object)diff, (String)"diff");
        TypedEntityStorageBuilder typedEntityStorageBuilder = diff;
        TypedEntityStorage typedEntityStorage = this.entityStore.getCurrent();
        Project project = this.getProject();
        LegacyBridgeProjectLibraryTableImpl legacyBridgeProjectLibraryTableImpl = this;
        return new LegacyBridgeProjectModifiableLibraryTableImpl(typedEntityStorage, legacyBridgeProjectLibraryTableImpl, project, typedEntityStorageBuilder);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.dispatcher.removeListener((EventListener)listener2);
    }

    public void dispose() {
    }

    public LegacyBridgeProjectLibraryTableImpl(@NotNull Project parentProject) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)parentProject, (String)"parentProject");
        this.parentProject = parentProject;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
        this.librariesMap = new ConcurrentHashMap();
        this.libraryNameMap = new ConcurrentMultiMap();
        LegacyBridgeProjectLibraryTableImpl legacyBridgeProjectLibraryTableImpl = this;
        boolean bl = false;
        legacyBridgeProjectLibraryTableImpl.newLibraryInstances = map2 = (Map)new LinkedHashMap();
        this.entityStore = WorkspaceModel.Companion.getInstance(this.parentProject).getEntityStore();
        EventDispatcher eventDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(L\u2026ble.Listener::class.java)");
        this.dispatcher = eventDispatcher;
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        WorkspaceModelTopics.Companion.getInstance(this.getProject()).subscribeAfterModuleLoading(messageBusConnection2, new WorkspaceModelChangeListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void beforeChanged(@NotNull EntityStoreChanged event) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Iterable $this$filterIsInstance$iv = Companion.filterProjectLibraryChanges(event.getChanges(LibraryEntity.class));
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EntityChange.Removed)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List changes = (List)destination$iv$iv;
                if (changes.isEmpty()) {
                    return;
                }
                UtilsKt.executeOrQueueOnDispatchThread((Function0<Unit>)((Function0)new Function0<Unit>(this, changes){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ List $changes;

                    public final void invoke() {
                        UtilsKt.bracket(LegacyBridgeProjectLibraryTableImpl.access$getLOG$p(this.this$0.this), "ProjectLibraryTable.beforeChanged", (Function0)new Function0<Unit>(this){
                            final /* synthetic */ beforeChanged.1 this$0;

                            public final void invoke() {
                                for (EntityChange.Removed change : this.this$0.$changes) {
                                    LegacyBridgeLibraryImpl libraryImpl = (LegacyBridgeLibraryImpl)MapsKt.getValue((Map)LegacyBridgeProjectLibraryTableImpl.access$getLibrariesMap$p(this.this$0.this$0.this), (Object)((LibraryEntity)change.getEntity()).persistentId());
                                    ((LibraryTable.Listener)LegacyBridgeProjectLibraryTableImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).beforeLibraryRemoved((Library)libraryImpl);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$changes = list2;
                        super(0);
                    }
                }));
            }

            @Override
            public void changed(@NotNull EntityStoreChanged event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                List changes = Companion.filterProjectLibraryChanges(event.getChanges(LibraryEntity.class));
                if (changes.isEmpty()) {
                    return;
                }
                UtilsKt.executeOrQueueOnDispatchThread((Function0<Unit>)((Function0)new Function0<Unit>(this, changes){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ List $changes;

                    public final void invoke() {
                        UtilsKt.bracket(LegacyBridgeProjectLibraryTableImpl.access$getLOG$p(this.this$0.this), "ProjectLibraryTable.EntityStoreChange", (Function0)new Function0<Unit>(this){
                            final /* synthetic */ changed.1 this$0;

                            public final void invoke() {
                                for (EntityChange change : this.this$0.$changes) {
                                    LibraryId idAfter;
                                    LibraryId idBefore;
                                    EntityChange entityChange = change;
                                    if (entityChange instanceof EntityChange.Added) {
                                        LegacyBridgeLibraryImpl legacyBridgeLibraryImpl;
                                        LibraryId addedLibraryId = ((LibraryEntity)((EntityChange.Added)change).getEntity()).persistentId();
                                        LegacyBridgeLibraryImpl alreadyCreatedLibrary = (LegacyBridgeLibraryImpl)LegacyBridgeProjectLibraryTableImpl.access$getNewLibraryInstances$p(this.this$0.this$0.this).remove(addedLibraryId);
                                        if (alreadyCreatedLibrary != null) {
                                            alreadyCreatedLibrary.setEntityStore$intellij_platform_workspaceModel_ide(LegacyBridgeProjectLibraryTableImpl.access$getEntityStore$p(this.this$0.this$0.this));
                                            alreadyCreatedLibrary.setModifiableModelFactory((Function2<? super LibraryViaTypedEntity, ? super TypedEntityStorageBuilder, LegacyBridgeLibraryModifiableModelImpl>)((Function2)null));
                                            legacyBridgeLibraryImpl = alreadyCreatedLibrary;
                                        } else {
                                            legacyBridgeLibraryImpl = new LegacyBridgeLibraryImpl(this.this$0.this$0.this, this.this$0.this$0.this.getProject(), addedLibraryId, LegacyBridgeProjectLibraryTableImpl.access$getEntityStore$p(this.this$0.this$0.this), this.this$0.this$0.this);
                                        }
                                        LegacyBridgeLibraryImpl libraryImpl = legacyBridgeLibraryImpl;
                                        LegacyBridgeProjectLibraryTableImpl.access$addLibraryToMaps(this.this$0.this$0.this, libraryImpl);
                                        ((LibraryTable.Listener)LegacyBridgeProjectLibraryTableImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).afterLibraryAdded((Library)libraryImpl);
                                        continue;
                                    }
                                    if (entityChange instanceof EntityChange.Removed) {
                                        LibraryId removedLibraryId = ((LibraryEntity)((EntityChange.Removed)change).getEntity()).persistentId();
                                        LegacyBridgeLibraryImpl libraryImpl = (LegacyBridgeLibraryImpl)MapsKt.getValue((Map)LegacyBridgeProjectLibraryTableImpl.access$getLibrariesMap$p(this.this$0.this$0.this), (Object)removedLibraryId);
                                        LegacyBridgeProjectLibraryTableImpl legacyBridgeProjectLibraryTableImpl = this.this$0.this$0.this;
                                        LegacyBridgeLibraryImpl legacyBridgeLibraryImpl = libraryImpl;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)legacyBridgeLibraryImpl, (String)"libraryImpl");
                                        LegacyBridgeProjectLibraryTableImpl.access$removeLibraryFromMaps(legacyBridgeProjectLibraryTableImpl, removedLibraryId, legacyBridgeLibraryImpl);
                                        ((LibraryTable.Listener)LegacyBridgeProjectLibraryTableImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).afterLibraryRemoved((Library)libraryImpl);
                                        Disposer.dispose((Disposable)((Disposable)libraryImpl));
                                        continue;
                                    }
                                    if (!(entityChange instanceof EntityChange.Replaced) || !(Intrinsics.areEqual((Object)(idBefore = ((LibraryEntity)((EntityChange.Replaced)change).getOldEntity()).persistentId()), (Object)(idAfter = ((LibraryEntity)((EntityChange.Replaced)change).getNewEntity()).persistentId())) ^ true)) continue;
                                    LegacyBridgeLibraryImpl library = (LegacyBridgeLibraryImpl)MapsKt.getValue((Map)LegacyBridgeProjectLibraryTableImpl.access$getLibrariesMap$p(this.this$0.this$0.this), (Object)idBefore);
                                    LegacyBridgeProjectLibraryTableImpl legacyBridgeProjectLibraryTableImpl = this.this$0.this$0.this;
                                    LegacyBridgeLibraryImpl legacyBridgeLibraryImpl = library;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)legacyBridgeLibraryImpl, (String)"library");
                                    LegacyBridgeProjectLibraryTableImpl.access$removeLibraryFromMaps(legacyBridgeProjectLibraryTableImpl, idBefore, legacyBridgeLibraryImpl);
                                    library.setEntityId$intellij_platform_workspaceModel_ide(idAfter);
                                    LegacyBridgeProjectLibraryTableImpl.access$addLibraryToMaps(this.this$0.this$0.this, library);
                                    ((LibraryTable.Listener)LegacyBridgeProjectLibraryTableImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).afterLibraryRenamed((Library)library);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        Map map2 = LegacyBridgeProjectLibraryTableImpl.access$getNewLibraryInstances$p(this.this$0.this);
                        boolean bl = false;
                        if (!map2.isEmpty()) {
                            LegacyBridgeProjectLibraryTableImpl.access$getLOG$p(this.this$0.this).error("Not all library instances were handled in change event. Leftovers:\n" + CollectionsKt.joinToString$default((Iterable)LegacyBridgeProjectLibraryTableImpl.access$getNewLibraryInstances$p(this.this$0.this).keySet(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                            LegacyBridgeProjectLibraryTableImpl.access$getNewLibraryInstances$p(this.this$0.this).clear();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$changes = list2;
                        super(0);
                    }
                }));
            }
        });
        UtilsKt.executeOrQueueOnDispatchThread((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                Sequence $this$forEach$iv = SequencesKt.filter(entityStore.getCurrent().entities(LibraryEntity.class), (Function1)1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LibraryEntity libraryEntity = (LibraryEntity)element$iv;
                    boolean bl = false;
                    LegacyBridgeLibraryImpl library = new LegacyBridgeLibraryImpl(this, this.getProject(), libraryEntity.persistentId(), entityStore, this);
                    this.addLibraryToMaps(library);
                    ((LibraryTable.Listener)dispatcher.getMulticaster()).afterLibraryAdded((Library)library);
                }
            }
        }));
    }

    static {
        Companion = new Companion(null);
        PROJECT_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

            @NotNull
            public String getDisplayName(boolean plural) {
                String string = ProjectModelBundle.message((String)"project.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProjectModelBundle.messa\u2026e\", if (plural) 2 else 1)");
                return string;
            }

            @NotNull
            public String getDescription() {
                String string = ProjectModelBundle.message((String)"libraries.node.text.project", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProjectModelBundle.messa\u2026aries.node.text.project\")");
                return string;
            }

            @NotNull
            public String getLibraryTableEditorTitle() {
                String string = ProjectModelBundle.message((String)"library.configure.project.title", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ProjectModelBundle.messa\u2026configure.project.title\")");
                return string;
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG$p(LegacyBridgeProjectLibraryTableImpl $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ ConcurrentMap access$getLibrariesMap$p(LegacyBridgeProjectLibraryTableImpl $this) {
        return $this.librariesMap;
    }

    public static final /* synthetic */ Map access$getNewLibraryInstances$p(LegacyBridgeProjectLibraryTableImpl $this) {
        return $this.newLibraryInstances;
    }

    public static final /* synthetic */ void access$removeLibraryFromMaps(LegacyBridgeProjectLibraryTableImpl $this, LibraryId id2, LegacyBridgeLibraryImpl libraryImpl) {
        $this.removeLibraryFromMaps(id2, libraryImpl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeProjectLibraryTableImpl$Companion;", "", "()V", "PROJECT_LIBRARY_TABLE_PRESENTATION", "Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "getPROJECT_LIBRARY_TABLE_PRESENTATION$intellij_platform_workspaceModel_ide", "()Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "filterProjectLibraryChanges", "", "Lcom/intellij/workspace/api/EntityChange;", "Lcom/intellij/workspace/api/LibraryEntity;", "intellij.platform.workspaceModel.ide"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final List<EntityChange<LibraryEntity>> filterProjectLibraryChanges(@NotNull List<? extends EntityChange<LibraryEntity>> $this$filterProjectLibraryChanges) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$filterProjectLibraryChanges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                EntityChange it = (EntityChange)element$iv$iv;
                boolean bl2 = false;
                EntityChange entityChange = it;
                if (entityChange instanceof EntityChange.Added) {
                    bl = ((LibraryEntity)((EntityChange.Added)it).getEntity()).getTableId() instanceof LibraryTableId.ProjectLibraryTableId;
                } else if (entityChange instanceof EntityChange.Removed) {
                    bl = ((LibraryEntity)((EntityChange.Removed)it).getEntity()).getTableId() instanceof LibraryTableId.ProjectLibraryTableId;
                } else if (entityChange instanceof EntityChange.Replaced) {
                    bl = ((LibraryEntity)((EntityChange.Replaced)it).getOldEntity()).getTableId() instanceof LibraryTableId.ProjectLibraryTableId;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final LibraryTablePresentation getPROJECT_LIBRARY_TABLE_PRESENTATION$intellij_platform_workspaceModel_ide() {
            return PROJECT_LIBRARY_TABLE_PRESENTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

