/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.jps;

import com.intellij.configurationStore.DirectoryBasedStorageBase;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtil;
import com.intellij.workspace.jps.CachingJpsFileContentReader;
import com.intellij.workspace.jps.JpsFileContentReader;
import com.intellij.workspace.jps.JpsProjectModelSynchronizerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspace/jps/StorageJpsConfigurationReader;", "Lcom/intellij/workspace/jps/JpsFileContentReader;", "project", "Lcom/intellij/openapi/project/Project;", "baseDirUrl", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "loadComponent", "Lorg/jdom/Element;", "fileUrl", "componentName", "intellij.platform.workspaceModel.ide"})
final class StorageJpsConfigurationReader
implements JpsFileContentReader {
    private final Project project;
    private final String baseDirUrl;

    @Override
    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        if (FileUtil.extensionEquals((String)filePath, (String)"iml")) {
            return new CachingJpsFileContentReader(this.baseDirUrl).loadComponent(fileUrl, componentName);
        }
        String string = filePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filePath");
        StateStorageBase<StateMap> storage = JpsProjectModelSynchronizerKt.getProjectStateStorage(string, ProjectKt.getStateStore(this.project));
        StateMap stateMap = storage.getStorageData();
        if (storage instanceof DirectoryBasedStorageBase) {
            String string2 = PathUtil.getFileName((String)filePath);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.getFileName(filePath)");
            Element elementContent = StateMap.getElement$default((StateMap)stateMap, (String)string2, null, (int)2, null);
            object = elementContent != null ? new Element("component").setAttribute("name", componentName).addContent(elementContent) : null;
        } else {
            object = StateMap.getElement$default((StateMap)stateMap, (String)componentName, null, (int)2, null);
        }
        return object;
    }

    public StorageJpsConfigurationReader(@NotNull Project project, @NotNull String baseDirUrl) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)baseDirUrl, (String)"baseDirUrl");
        this.project = project;
        this.baseDirUrl = baseDirUrl;
    }
}

