/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class PersistentIndicesConfiguration {
    private static final int BASE_INDICES_CONFIGURATION_VERSION = 1;

    PersistentIndicesConfiguration() {
    }

    static void saveConfiguration() {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(PersistentIndicesConfiguration.indicesConfigurationFile())));){
            DataInputOutputUtil.writeINT((DataOutput)out, (int)PersistentIndicesConfiguration.getIndexesConfigurationVersion());
            IndexingStamp.savePersistentIndexStamp(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void loadConfiguration() {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(PersistentIndicesConfiguration.indicesConfigurationFile())));){
            if (DataInputOutputUtil.readINT((DataInput)in) == PersistentIndicesConfiguration.getIndexesConfigurationVersion()) {
                IndexingStamp.initPersistentIndexStamp(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int getIndexesConfigurationVersion() {
        int version2 = 1;
        for (FileBasedIndexInfrastructureExtension ex : (FileBasedIndexInfrastructureExtension[])FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions()) {
            version2 = 31 * version2 + ex.getVersion();
        }
        return version2;
    }

    private static File indicesConfigurationFile() {
        return new File(PathManager.getIndexRoot(), "indices.config");
    }
}

