/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.HiddenFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdFilter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSymbolParameters {
    private final String myCompletePattern;
    private final String myLocalPatternName;
    private final GlobalSearchScope mySearchScope;
    private final IdFilter myIdFilter;

    public FindSymbolParameters(@NotNull String pattern, @NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(0);
        }
        if (name == null) {
            FindSymbolParameters.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            FindSymbolParameters.$$$reportNull$$$0(2);
        }
        this.myCompletePattern = pattern;
        this.myLocalPatternName = name;
        this.mySearchScope = scope;
        this.myIdFilter = idFilter;
    }

    public FindSymbolParameters withCompletePattern(@NotNull String pattern) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(3);
        }
        return new FindSymbolParameters(pattern, this.myLocalPatternName, this.mySearchScope, this.myIdFilter);
    }

    public FindSymbolParameters withLocalPattern(@NotNull String pattern) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(4);
        }
        return new FindSymbolParameters(this.myCompletePattern, pattern, this.mySearchScope, this.myIdFilter);
    }

    public FindSymbolParameters withScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FindSymbolParameters.$$$reportNull$$$0(5);
        }
        return new FindSymbolParameters(this.myCompletePattern, this.myLocalPatternName, scope, this.myIdFilter);
    }

    @NotNull
    public String getCompletePattern() {
        String string = this.myCompletePattern;
        if (string == null) {
            FindSymbolParameters.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getLocalPatternName() {
        String string = this.myLocalPatternName;
        if (string == null) {
            FindSymbolParameters.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            FindSymbolParameters.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @Nullable
    public IdFilter getIdFilter() {
        return this.myIdFilter;
    }

    @NotNull
    public Project getProject() {
        Project project = Objects.requireNonNull(this.mySearchScope.getProject());
        if (project == null) {
            FindSymbolParameters.$$$reportNull$$$0(9);
        }
        return project;
    }

    public boolean isSearchInLibraries() {
        return this.mySearchScope.isSearchInLibraries();
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull Project project, boolean searchInLibraries) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(10);
        }
        if (project == null) {
            FindSymbolParameters.$$$reportNull$$$0(11);
        }
        return new FindSymbolParameters(pattern, pattern, FindSymbolParameters.searchScopeFor(project, searchInLibraries), ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project));
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull GlobalSearchScope scope) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            FindSymbolParameters.$$$reportNull$$$0(13);
        }
        return new FindSymbolParameters(pattern, pattern, scope, null);
    }

    public static FindSymbolParameters simple(@NotNull Project project, boolean searchInLibraries) {
        if (project == null) {
            FindSymbolParameters.$$$reportNull$$$0(14);
        }
        return new FindSymbolParameters("", "", FindSymbolParameters.searchScopeFor(project, searchInLibraries), ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project));
    }

    @NotNull
    public static GlobalSearchScope searchScopeFor(@Nullable Project project, boolean searchInLibraries) {
        EverythingGlobalScope baseScope = project == null ? new EverythingGlobalScope() : (searchInLibraries ? ProjectScope.getAllScope((Project)project) : ProjectScope.getProjectScope((Project)project));
        GlobalSearchScope globalSearchScope = baseScope.intersectWith((GlobalSearchScope)new EverythingGlobalScope(project){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !(file2.getFileSystem() instanceof HiddenFileSystem);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FindSymbolParameters$1", "contains"));
            }
        });
        if (globalSearchScope == null) {
            FindSymbolParameters.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FindSymbolParameters";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FindSymbolParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletePattern";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPatternName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "searchScopeFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withCompletePattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withLocalPattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withScope";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "simple";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

