/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import org.jetbrains.annotations.NotNull;

public class FileBasedIndexSwitcher {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexSwitcher.class);
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    private Semaphore myDumbModeSemaphore;

    public FileBasedIndexSwitcher() {
        this((FileBasedIndexImpl)FileBasedIndex.getInstance());
    }

    public FileBasedIndexSwitcher(@NotNull FileBasedIndexImpl index) {
        if (index == null) {
            FileBasedIndexSwitcher.$$$reportNull$$$0(0);
        }
        this.myFileBasedIndex = index;
    }

    public void turnOff() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        LOG.assertTrue(!ApplicationManager.getApplication().isWriteAccessAllowed());
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode) {
            this.myDumbModeSemaphore = new Semaphore(1);
            for (Project project : projects) {
                DumbService.getInstance((Project)project).cancelAllTasksAndWait();
                DumbService.getInstance((Project)project).queueTask(new DumbModeTask(){

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicator.setText(IndexingBundle.message((String)"indexes.reloading", (Object[])new Object[0]));
                        FileBasedIndexSwitcher.this.myDumbModeSemaphore.waitFor();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexSwitcher$1", "performInDumbMode"));
                    }
                });
            }
        }
        this.myFileBasedIndex.performShutdown(true);
        this.myFileBasedIndex.dropRegisteredIndexes();
        IndexingStamp.flushCaches();
    }

    public void turnOn() {
        LOG.assertTrue(ApplicationManager.getApplication().isWriteThread());
        RebuildStatus.reset();
        this.myFileBasedIndex.initComponent();
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (unitTestMode) {
            this.myFileBasedIndex.waitUntilIndicesAreInitialized();
        }
        if (!unitTestMode) {
            this.myDumbModeSemaphore.up();
        }
        FileBasedIndexImpl.cleanupProcessedFlag();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/util/indexing/FileBasedIndexSwitcher", "<init>"));
    }
}

