/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemAnActionButton
extends TBItemButton {
    private static final int ourRunConfigurationPopoverWidth = 143;
    public static final int SHOWMODE_IMAGE_ONLY = 0;
    public static final int SHOWMODE_TEXT_ONLY = 1;
    public static final int SHOWMODE_IMAGE_TEXT = 2;
    public static final int SHOWMODE_IMAGE_ONLY_IF_PRESENTED = 3;
    @NotNull
    private AnAction myAnAction;
    @NotNull
    private String myActionId;
    private int myShowMode;
    private boolean myAutoVisibility;
    private boolean myHiddenWhenDisabled;
    @Nullable
    private Component myComponent;
    @Nullable
    private List<? extends TBItemAnActionButton> myLinkedButtons;

    TBItemAnActionButton(@Nullable ItemListener listener2, @NotNull AnAction action2, @Nullable TouchBarStats.AnActionStats stats) {
        if (action2 == null) {
            TBItemAnActionButton.$$$reportNull$$$0(0);
        }
        super(listener2, stats);
        this.myShowMode = 3;
        this.myAutoVisibility = true;
        this.myHiddenWhenDisabled = false;
        this.setAnAction(action2);
        this.setModality(null);
        if (action2 instanceof Toggleable) {
            this.myFlags |= 8;
        }
    }

    @Override
    public String toString() {
        return String.format("%s [%s]", this.myActionId, this.getUid());
    }

    TBItemAnActionButton setComponent(Component component2) {
        this.myComponent = component2;
        return this;
    }

    TBItemAnActionButton setModality(ModalityState modality) {
        this.setAction(this::_performAction, true, modality);
        return this;
    }

    TBItemAnActionButton setShowMode(int showMode) {
        this.myShowMode = showMode;
        return this;
    }

    void setLinkedButtons(@Nullable List<? extends TBItemAnActionButton> linkedButtons) {
        this.myLinkedButtons = linkedButtons;
    }

    boolean isAutoVisibility() {
        return this.myAutoVisibility;
    }

    void setAutoVisibility(boolean autoVisibility) {
        this.myAutoVisibility = autoVisibility;
    }

    void setHiddenWhenDisabled(boolean hiddenWhenDisabled) {
        this.myHiddenWhenDisabled = hiddenWhenDisabled;
    }

    @NotNull
    AnAction getAnAction() {
        AnAction anAction = this.myAnAction;
        if (anAction == null) {
            TBItemAnActionButton.$$$reportNull$$$0(1);
        }
        return anAction;
    }

    @NotNull
    String getActionId() {
        String string = this.myActionId;
        if (string == null) {
            TBItemAnActionButton.$$$reportNull$$$0(2);
        }
        return string;
    }

    void setAnAction(@NotNull AnAction newAction) {
        if (newAction == null) {
            TBItemAnActionButton.$$$reportNull$$$0(3);
        }
        this.myAnAction = newAction;
        String newActionId = ActionManager.getInstance().getId(newAction);
        this.myActionId = newActionId == null ? newAction.toString() : newActionId;
    }

    boolean updateVisibility(Presentation presentation) {
        boolean visibilityChanged;
        if (!this.myAutoVisibility) {
            return false;
        }
        boolean isVisible = presentation.isVisible() && (presentation.isEnabled() || !this.myHiddenWhenDisabled);
        boolean bl = visibilityChanged = isVisible != this.myIsVisible;
        if (visibilityChanged) {
            this.myIsVisible = isVisible;
        }
        if ("RunConfiguration".equals(this.myActionId)) {
            visibilityChanged = visibilityChanged || this._setLinkedVisibility(presentation.getIcon() != AllIcons.General.Add);
        }
        return visibilityChanged;
    }

    boolean updateView(@NotNull Presentation presentation) {
        if (presentation == null) {
            TBItemAnActionButton.$$$reportNull$$$0(4);
        }
        if (!this.myIsVisible) {
            return false;
        }
        long startNs = this.myActionStats != null ? System.nanoTime() : 0L;
        Icon icon2 = null;
        boolean needGetDisabledIcon = false;
        if (this.myShowMode != 1) {
            if (presentation.isEnabled()) {
                icon2 = presentation.getIcon();
            } else {
                icon2 = presentation.getDisabledIcon();
                if (icon2 == null && presentation.getIcon() != null) {
                    needGetDisabledIcon = true;
                    icon2 = presentation.getIcon();
                }
            }
        }
        this.setIcon(icon2, needGetDisabledIcon);
        this.setDisabled(!presentation.isEnabled());
        boolean isSelected = false;
        if (this.myAnAction instanceof Toggleable) {
            isSelected = Toggleable.isSelected((Presentation)presentation);
            if (this.myNativePeer != ID.NIL && this.myActionId.startsWith("Console.Jdbc.Execute")) {
                this.myUpdateOptions |= 2;
            }
        }
        this.setSelected(isSelected);
        if ("RunConfiguration".equals(this.myActionId)) {
            if (presentation.getIcon() != AllIcons.General.Add) {
                this.setHasArrowIcon(true);
                this.setLayout(143, 0, 5, 8);
            } else {
                this.setHasArrowIcon(false);
                this.setLayout(0, 0, 5, 8);
            }
        }
        boolean hideText = this.myShowMode == 0 || this.myShowMode == 3 && icon2 != null;
        String text2 = hideText ? null : presentation.getText();
        this.setText(text2);
        if (this.myActionStats != null) {
            this.myActionStats.updateViewNs += System.nanoTime() - startNs;
        }
        return this.myUpdateOptions != 0 && this.myNativePeer != ID.NIL;
    }

    private boolean _setLinkedVisibility(boolean visible) {
        if (this.myLinkedButtons == null) {
            return false;
        }
        boolean visibilityChanged = false;
        for (TBItemAnActionButton tBItemAnActionButton : this.myLinkedButtons) {
            if (tBItemAnActionButton.myAutoVisibility != visible) {
                visibilityChanged = true;
            }
            tBItemAnActionButton.setAutoVisibility(visible);
            tBItemAnActionButton.myIsVisible = visible;
        }
        return visibilityChanged;
    }

    private void _performAction() {
        ActionManagerEx actionManagerEx = ActionManagerEx.getInstanceEx();
        Component src = this.getComponent();
        if (src == null) {
            return;
        }
        KeyEvent ie = new KeyEvent(src, 100, System.currentTimeMillis(), 0, 0, '\u0000');
        actionManagerEx.tryToExecute(this.myAnAction, (InputEvent)ie, src, "TouchBarGeneral", true);
        if (this.myAnAction instanceof Toggleable) {
            this.myUpdateOptions |= 2;
        }
    }

    Component getComponent() {
        return this.myComponent != null ? this.myComponent : BuildUtils.getCurrentFocusComponent();
    }

    private static String _printPresentation(Presentation presentation) {
        Icon disabledIcon;
        Icon icon2;
        StringBuilder sb = new StringBuilder();
        if (presentation.getText() != null && !presentation.getText().isEmpty()) {
            sb.append(String.format("text='%s'", presentation.getText()));
        }
        if ((icon2 = presentation.getIcon()) != null) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(String.format("icon: %dx%d", icon2.getIconWidth(), icon2.getIconHeight()));
        }
        if ((disabledIcon = presentation.getDisabledIcon()) != null) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(String.format("dis-icon: %dx%d", disabledIcon.getIconWidth(), disabledIcon.getIconHeight()));
        }
        if (sb.length() != 0) {
            sb.append(", ");
        }
        sb.append(presentation.isVisible() ? "visible" : "hidden");
        sb.append(presentation.isEnabled() ? ", enabled" : ", disabled");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/TBItemAnActionButton";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TBItemAnActionButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAnAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

