/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import java.awt.Container;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BarContainer {
    @NotNull
    private final BarType myType;
    private final Container myParentComponent;
    private Map<Long, TouchBar> myKeyMask2Alt;
    @NotNull
    private TouchBar myMain;
    private TouchBar myCurrent;
    private Runnable myOnHideCallback;

    BarContainer(@NotNull BarType type, @NotNull TouchBar main2, Map<Long, TouchBar> alts, Container parentComponent) {
        if (type == null) {
            BarContainer.$$$reportNull$$$0(0);
        }
        if (main2 == null) {
            BarContainer.$$$reportNull$$$0(1);
        }
        this.myParentComponent = parentComponent;
        this.myMain = main2;
        this.myType = type;
        this.myKeyMask2Alt = alts;
        this._updateTouchBarsParents();
    }

    public String toString() {
        return this.myMain.toString();
    }

    void set(@NotNull TouchBar main2, Map<Long, TouchBar> alts) {
        if (main2 == null) {
            BarContainer.$$$reportNull$$$0(2);
        }
        this.myMain = main2;
        this.myKeyMask2Alt = alts;
        this.myCurrent = null;
        this._updateTouchBarsParents();
    }

    void selectBarByKeyMask(long keyMask) {
        TouchBar alt;
        if (keyMask == 0L) {
            this.myCurrent = this.myMain;
            return;
        }
        TouchBar touchBar = alt = this.myKeyMask2Alt == null ? null : this.myKeyMask2Alt.get(keyMask);
        if (alt != null) {
            this.myCurrent = alt;
        }
    }

    @NotNull
    TouchBar getMain() {
        TouchBar touchBar = this.myMain;
        if (touchBar == null) {
            BarContainer.$$$reportNull$$$0(3);
        }
        return touchBar;
    }

    TouchBar get() {
        if (this.myCurrent == null) {
            this.myCurrent = this.myMain;
        }
        return this.myCurrent;
    }

    void show() {
        TouchBarsManager.showContainer(this);
    }

    void hide() {
        TouchBarsManager.hideContainer(this);
    }

    @NotNull
    BarType getType() {
        BarType barType = this.myType;
        if (barType == null) {
            BarContainer.$$$reportNull$$$0(4);
        }
        return barType;
    }

    boolean isPopup() {
        return this.myType == BarType.POPUP;
    }

    boolean isDialog() {
        return this.myType == BarType.DIALOG || this.myType == BarType.MODAL_DIALOG;
    }

    boolean isNonModalDialog() {
        return this.myType == BarType.DIALOG;
    }

    boolean isModalDialog() {
        return this.myType == BarType.MODAL_DIALOG;
    }

    void setOnHideCallback(Runnable onHideCallback) {
        this.myOnHideCallback = onHideCallback;
    }

    void onHide() {
        if (this.myOnHideCallback != null) {
            this.myOnHideCallback.run();
        }
    }

    void setOptionalContextActions(@Nullable ActionGroup actions, @NotNull String contextName) {
        if (contextName == null) {
            BarContainer.$$$reportNull$$$0(5);
        }
        if (actions == null) {
            this.myMain.removeOptionalContextItems(contextName);
        } else {
            this.myMain.setOptionalContextItems(actions, contextName);
        }
    }

    void setOptionalContextVisible(@Nullable String contextName) {
        this.myMain.setOptionalContextVisible(contextName);
    }

    Container getParentComponent() {
        return this.myParentComponent;
    }

    void release() {
        this.myMain.release();
        if (this.myKeyMask2Alt != null) {
            this.myKeyMask2Alt.forEach((mask, bar) -> bar.release());
        }
        this.myKeyMask2Alt = null;
        this.myMain = TouchBar.EMPTY;
    }

    private void _updateTouchBarsParents() {
        this.myMain.setBarContainer(this);
        if (this.myKeyMask2Alt != null && !this.myKeyMask2Alt.isEmpty()) {
            this.myKeyMask2Alt.values().forEach(tb -> tb.setBarContainer(this));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/BarContainer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/BarContainer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOptionalContextActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

