/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.ui.Splash;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;

class ProgressSlidePainter {
    public final boolean hasSlides;
    private static final int PREFETCH_BUFFER_SIZE = 5;
    private final BlockingQueue<Slide> myPrefetchQueue;
    private boolean isFinish;
    private Slide nextSlide;
    private final List<ProgressSlide> myProgressSlides;

    ProgressSlidePainter(@NotNull ApplicationInfoEx appInfo) {
        if (appInfo == null) {
            ProgressSlidePainter.$$$reportNull$$$0(0);
        }
        this.myPrefetchQueue = new ArrayBlockingQueue<Slide>(5);
        this.nextSlide = null;
        this.myProgressSlides = appInfo.getProgressSlides();
        if (this.myProgressSlides.isEmpty()) {
            this.hasSlides = false;
            return;
        }
        this.hasSlides = true;
        this.myProgressSlides.sort(Comparator.comparing(ProgressSlide::getProgressRation));
    }

    public void startPreloading() {
        if (!this.hasSlides) {
            return;
        }
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            for (int i = 0; i < this.myProgressSlides.size(); ++i) {
                ProgressSlide slide = this.myProgressSlides.get(i);
                try {
                    Image image = ImageLoader.loadFromUrl((String)slide.getUrl(), Splash.class, (int)1, null, (ScaleContext)ScaleContext.create());
                    if (image == null) {
                        throw new IllegalStateException("Cannot load slide by url: " + slide.getUrl());
                    }
                    this.myPrefetchQueue.put(new Slide(slide.getProgressRation(), image, i == this.myProgressSlides.size() - 1));
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
    }

    public void paintSlides(@NotNull Graphics g, double currentProgress) {
        Slide newSlide;
        if (g == null) {
            ProgressSlidePainter.$$$reportNull$$$0(1);
        }
        if (this.isFinish || this.nextSlide != null && this.nextSlide.progress > currentProgress || !this.hasSlides) {
            return;
        }
        if (this.nextSlide != null) {
            StartupUiUtil.drawImage((Graphics)g, (Image)this.nextSlide.image, (int)0, (int)0, null);
            if (this.nextSlide.isLastSlide) {
                this.isFinish = true;
                this.nextSlide = null;
                return;
            }
        }
        do {
            try {
                newSlide = this.myPrefetchQueue.take();
            }
            catch (InterruptedException e) {
                return;
            }
            if (newSlide.progress <= currentProgress) {
                StartupUiUtil.drawImage((Graphics)g, (Image)newSlide.image, (int)0, (int)0, null);
                if (!newSlide.isLastSlide) continue;
                this.nextSlide = null;
                this.isFinish = true;
                continue;
            }
            this.nextSlide = newSlide;
            break;
        } while (!newSlide.isLastSlide);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ProgressSlidePainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paintSlides";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Slide {
        public final double progress;
        public final Image image;
        public final boolean isLastSlide;

        Slide(double progress2, Image image, boolean isLastSlide) {
            this.progress = progress2;
            this.image = image;
            this.isLastSlide = isLastSlide;
        }
    }
}

