/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexState;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.IndicesRegistrationResult;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.VoidDataExternalizer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileBasedIndex", storages={@Storage(value="$CACHE_FILE$"), @Storage(value="stubIndex.xml", deprecated=true, roamingType=RoamingType.DISABLED)})
public final class StubIndexImpl
extends StubIndexEx
implements PersistentStateComponent<StubIndexState> {
    private static final AtomicReference<Boolean> ourForcedClean = new AtomicReference<Object>(null);
    static final Logger LOG = Logger.getInstance(StubIndexImpl.class);
    private final Map<StubIndexKey<?, ?>, CachedValue<Map<CompositeKey<?>, StubIdList>>> myCachedStubIds = FactoryMap.createMap(k -> {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> index = StubIndexImpl.getStubUpdatingIndex();
        ModificationTracker tracker = index::getModificationStamp;
        return new CachedValueImpl(() -> new CachedValueProvider.Result((Object)ContainerUtil.newConcurrentMap(), new Object[]{tracker}));
    }, ContainerUtil::newConcurrentMap);
    private final StubProcessingHelper myStubProcessingHelper = new StubProcessingHelper();
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile CompletableFuture<AsyncState> myStateFuture;
    private volatile AsyncState myState;
    private volatile boolean myInitialized;
    private StubIndexState myPreviouslyRegistered;

    public StubIndexImpl() {
        StubIndexExtension.EP_NAME.addExtensionPointListener(new ExtensionPointListener<StubIndexExtension<?, ?>>(){

            public void extensionRemoved(@NotNull StubIndexExtension<?, ?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ID.unloadId((ID)extension.getKey());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/stubs/StubIndexImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    @Nullable
    static StubIndexImpl getInstanceOrInvalidate() {
        if (ourForcedClean.compareAndSet(null, Boolean.TRUE)) {
            return null;
        }
        return (StubIndexImpl)StubIndexImpl.getInstance();
    }

    private AsyncState getAsyncState() {
        AsyncState state = this.myState;
        if (state == null) {
            if (this.myStateFuture == null) {
                ((FileBasedIndexImpl)FileBasedIndex.getInstance()).waitUntilIndicesAreInitialized();
            }
            this.myState = state = ProgressIndicatorUtils.awaitWithCheckCanceled(this.myStateFuture);
        }
        return state;
    }

    @NotNull
    public static <K> FileBasedIndexExtension<K, Void> wrapStubIndexExtension(final StubIndexExtension<K, ?> extension) {
        return new FileBasedIndexExtension<K, Void>(){

            @NotNull
            public ID<K, Void> getName() {
                StubIndexKey stubIndexKey = extension.getKey();
                if (stubIndexKey == null) {
                    2.$$$reportNull$$$0(0);
                }
                return stubIndexKey;
            }

            @NotNull
            public FileBasedIndex.InputFilter getInputFilter() {
                FileBasedIndex.InputFilter inputFilter = f -> {
                    throw new UnsupportedOperationException();
                };
                if (inputFilter == null) {
                    2.$$$reportNull$$$0(1);
                }
                return inputFilter;
            }

            public boolean dependsOnFileContent() {
                return true;
            }

            @NotNull
            public DataIndexer<K, Void, FileContent> getIndexer() {
                DataIndexer dataIndexer = i -> {
                    throw new AssertionError();
                };
                if (dataIndexer == null) {
                    2.$$$reportNull$$$0(2);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<K> getKeyDescriptor() {
                KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
                if (keyDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                return keyDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    2.$$$reportNull$$$0(4);
                }
                return voidDataExternalizer;
            }

            public int getVersion() {
                return extension.getVersion();
            }

            public boolean traceKeyHashToVirtualFileMapping() {
                return extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/stubs/StubIndexImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputFilter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static <K> void registerIndexer(final @NotNull StubIndexExtension<K, ?> extension, boolean forceClean, @NotNull AsyncState state, @NotNull IndicesRegistrationResult registrationResultSink) throws IOException {
        if (extension == null) {
            StubIndexImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(1);
        }
        if (registrationResultSink == null) {
            StubIndexImpl.$$$reportNull$$$0(2);
        }
        indexKey = extension.getKey();
        version = extension.getVersion();
        wrappedExtension = StubIndexImpl.wrapStubIndexExtension(extension);
        var7_7 = state;
        synchronized (var7_7) {
            AsyncState.access$000(state).put((Object)indexKey, version);
        }
        indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        if (forceClean || IndexingStamp.versionDiffers(indexKey, version)) {
            versionFile = IndexInfrastructure.getVersionFile(indexKey);
            versionFileExisted = versionFile.exists();
            children = indexRootDir.list();
            indexRootHasChildren = children != null && children.length > 0;
            v0 = needRebuild = forceClean == false && (versionFileExisted != false || indexRootHasChildren != false);
            if (needRebuild) {
                registrationResultSink.registerIndexAsChanged((ID<?, ?>)indexKey);
            } else {
                registrationResultSink.registerIndexAsInitiallyBuilt((ID<?, ?>)indexKey);
            }
            if (indexRootHasChildren) {
                FileUtil.deleteWithRenaming((File)indexRootDir);
            }
            IndexingStamp.rewriteVersion(indexKey, version);
            try {
                if (!needRebuild) ** GOTO lbl43
                for (Object ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    ex.onStubIndexVersionChanged(indexKey);
                }
            }
            catch (Exception e) {
                StubIndexImpl.LOG.error((Throwable)e);
            }
        } else {
            registrationResultSink.registerIndexAsUptoDate((ID<?, ?>)indexKey);
        }
lbl43:
        // 4 sources

        stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        lock = stubUpdatingIndex.getLock();
        for (attempt = 0; attempt < 2; ++attempt) {
            try {
                storage = new VfsAwareMapIndexStorage<Key, Value>(IndexInfrastructure.getStorageFile(indexKey).toPath(), wrappedExtension.getKeyDescriptor(), wrappedExtension.getValueExternalizer(), wrappedExtension.getCacheSize(), wrappedExtension.keyIsUniqueForIndexedFile(), wrappedExtension.traceKeyHashToVirtualFileMapping());
                memStorage = new MemoryIndexStorage<Key, Value>(storage, (ID<?, ?>)indexKey);
                index /* !! */  = new VfsAwareMapReduceIndex<Key, Value>(wrappedExtension, memStorage, null, null, null, lock);
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    intermediateIndex = infrastructureExtension.combineIndex(wrappedExtension, index /* !! */ );
                    if (intermediateIndex == null) continue;
                    index /* !! */  = intermediateIndex;
                }
                keyHashingStrategy = new TObjectHashingStrategy<K>(){
                    private final KeyDescriptor<K> descriptor;
                    {
                        this.descriptor = extension.getKeyDescriptor();
                    }

                    public int computeHashCode(K object) {
                        return this.descriptor.getHashCode(object);
                    }

                    public boolean equals(K o1, K o2) {
                        return this.descriptor.isEqual(o1, o2);
                    }
                };
                var15_25 = state;
                synchronized (var15_25) {
                    AsyncState.access$100(state).put(indexKey, index /* !! */ );
                    AsyncState.access$200(state).put(indexKey, keyHashingStrategy);
                    break;
                }
            }
            catch (IOException e) {
                registrationResultSink.registerIndexAsInitiallyBuilt((ID<?, ?>)indexKey);
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version, indexRootDir, e);
            }
        }
    }

    @Override
    @NotNull
    <K> TObjectHashingStrategy<K> getKeyHashingStrategy(StubIndexKey<K, ?> stubIndexKey) {
        TObjectHashingStrategy tObjectHashingStrategy = (TObjectHashingStrategy)this.getAsyncState().myKeyHashingStrategies.get(stubIndexKey);
        if (tObjectHashingStrategy == null) {
            StubIndexImpl.$$$reportNull$$$0(3);
        }
        return tObjectHashingStrategy;
    }

    private static <K> void onExceptionInstantiatingIndex(@NotNull StubIndexKey<K, ?> indexKey, int version2, @NotNull File indexRootDir, @NotNull Exception e) throws IOException {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(4);
        }
        if (indexRootDir == null) {
            StubIndexImpl.$$$reportNull$$$0(5);
        }
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(6);
        }
        LOG.info((Throwable)e);
        FileUtil.deleteWithRenaming((File)indexRootDir);
        IndexingStamp.rewriteVersion(indexKey, version2);
    }

    public long getIndexModificationStamp(@NotNull StubIndexKey<?, ?> indexId, @NotNull Project project) {
        UpdatableIndex index;
        if (indexId == null) {
            StubIndexImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(8);
        }
        if ((index = (UpdatableIndex)this.getAsyncState().myIndices.get(indexId)) != null) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
            return index.getModificationStamp();
        }
        return -1L;
    }

    public void flush() throws StorageException {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            index.flush();
        }
    }

    @Override
    <K> void serializeIndexValue(@NotNull DataOutput out, @NotNull StubIndexKey<K, ?> stubIndexKey, @NotNull Map<K, StubIdList> map2) throws IOException {
        UpdatableIndex<K, Void, FileContent> index;
        if (out == null) {
            StubIndexImpl.$$$reportNull$$$0(9);
        }
        if (stubIndexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(10);
        }
        if (map2 == null) {
            StubIndexImpl.$$$reportNull$$$0(11);
        }
        if ((index = this.getIndex(stubIndexKey)) == null) {
            return;
        }
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        BufferExposingByteArrayOutputStream indexOs = new BufferExposingByteArrayOutputStream();
        DataOutputStream indexDos = new DataOutputStream((OutputStream)indexOs);
        for (K key : map2.keySet()) {
            keyDescriptor.save((DataOutput)indexDos, key);
            StubIdExternalizer.INSTANCE.save((DataOutput)indexDos, map2.get(key));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)indexDos.size());
        out.write(indexOs.getInternalBuffer(), 0, indexOs.size());
    }

    @Override
    @NotNull
    <K> Map<K, StubIdList> deserializeIndexValue(@NotNull DataInput in, @NotNull StubIndexKey<K, ?> stubIndexKey, @Nullable K requestedKey) throws IOException {
        if (in == null) {
            StubIndexImpl.$$$reportNull$$$0(12);
        }
        if (stubIndexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(13);
        }
        UpdatableIndex<K, Void, FileContent> index = this.getIndex(stubIndexKey);
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        int bufferSize = DataInputOutputUtil.readINT((DataInput)in);
        byte[] buffer = new byte[bufferSize];
        in.readFully(buffer);
        UnsyncByteArrayInputStream indexIs = new UnsyncByteArrayInputStream(buffer);
        DataInputStream indexDis = new DataInputStream((InputStream)indexIs);
        TObjectHashingStrategy<K> hashingStrategy = this.getKeyHashingStrategy(stubIndexKey);
        THashMap result2 = new THashMap(hashingStrategy);
        while (indexDis.available() > 0) {
            Object key = keyDescriptor.read((DataInput)indexDis);
            StubIdList read2 = StubIdExternalizer.INSTANCE.read(indexDis);
            if (requestedKey != null) {
                if (!hashingStrategy.equals(requestedKey, key)) continue;
                result2.put(key, read2);
                THashMap tHashMap = result2;
                if (tHashMap == null) {
                    StubIndexImpl.$$$reportNull$$$0(14);
                }
                return tHashMap;
            }
            result2.put(key, read2);
        }
        THashMap tHashMap = result2;
        if (tHashMap == null) {
            StubIndexImpl.$$$reportNull$$$0(15);
        }
        return tHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor2) {
        block15: {
            DumbModeAccessType accessType;
            boolean dumb;
            if (indexKey == null) {
                StubIndexImpl.$$$reportNull$$$0(16);
            }
            if (key == null) {
                StubIndexImpl.$$$reportNull$$$0(17);
            }
            if (project == null) {
                StubIndexImpl.$$$reportNull$$$0(18);
            }
            if (requiredClass == null) {
                StubIndexImpl.$$$reportNull$$$0(19);
            }
            if (processor2 == null) {
                StubIndexImpl.$$$reportNull$$$0(20);
            }
            if ((dumb = DumbService.isDumb((Project)project)) && (accessType = FileBasedIndex.getInstance().getCurrentDumbModeAccessType()) == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
                throw new AssertionError((Object)"raw index data access is not available for StubIndex");
            }
            IdIterator ids = this.getContainingIds(indexKey, key, project, idFilter, scope);
            PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
            IntPredicate accessibleFileFilter = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getAccessibleFileIdFilter(project);
            try {
                while (ids.hasNext()) {
                    VirtualFile file2;
                    int id2 = ids.next();
                    ProgressManager.checkCanceled();
                    if (!accessibleFileFilter.test(id2) || (file2 = IndexInfrastructure.findFileByIdIfCached(fs, id2)) == null || scope != null && !scope.contains(file2)) continue;
                    StubIdList list2 = ((Map)this.myCachedStubIds.get(indexKey).getValue()).computeIfAbsent(new CompositeKey(key, id2), __ -> this.myStubProcessingHelper.retrieveStubIdList(indexKey, key, file2, project));
                    if (list2 == null) {
                        LOG.error("StubUpdatingIndex & " + indexKey + " stub index mismatch. No stub index key is present");
                        continue;
                    }
                    if (this.myStubProcessingHelper.processStubsInFile(project, file2, list2, processor2, scope, requiredClass)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause != null) {
                    this.forceRebuild(cause);
                    break block15;
                }
                throw e;
            }
            finally {
                this.wipeProblematicFileIdsForParticularKeyAndStubIndex(indexKey, key);
            }
        }
        return true;
    }

    private <Key> UpdatableIndex<Key, Void, FileContent> getIndex(@NotNull StubIndexKey<Key, ?> indexKey) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(21);
        }
        return (UpdatableIndex)this.getAsyncState().myIndices.get(indexKey);
    }

    private <Key> void wipeProblematicFileIdsForParticularKeyAndStubIndex(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key) {
        Set<VirtualFile> filesWithProblems;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(22);
        }
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(23);
        }
        if ((filesWithProblems = this.myStubProcessingHelper.takeAccumulatedFilesWithIndexProblems()) != null) {
            LOG.info("data for " + indexKey.getName() + " will be wiped for a some files because of internal stub processing error");
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).runCleanupAction(() -> {
                Lock writeLock = this.getIndex(indexKey).getWriteLock();
                boolean locked = writeLock.tryLock();
                if (!locked) {
                    return;
                }
                try {
                    for (VirtualFile file2 : filesWithProblems) {
                        this.updateIndex(indexKey, FileBasedIndex.getFileId((VirtualFile)file2), Collections.singletonMap(key, new StubIdList()), Collections.emptyMap());
                    }
                }
                finally {
                    writeLock.unlock();
                }
            });
        }
    }

    public void forceRebuild(@NotNull Throwable e) {
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(24);
        }
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    @Override
    void ensureLoaded() {
        ProgressManager.getInstance().executeNonCancelableSection(() -> this.getAsyncState());
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(25);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(26);
        }
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexKey, project, Processors.cancelableCollectProcessor((Collection)allKeys));
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            StubIndexImpl.$$$reportNull$$$0(27);
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        UpdatableIndex index;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(28);
        }
        if (processor2 == null) {
            StubIndexImpl.$$$reportNull$$$0(29);
        }
        if (scope == null) {
            StubIndexImpl.$$$reportNull$$$0(30);
        }
        if ((index = this.getIndex(indexKey)) == null || !((FileBasedIndexEx)FileBasedIndex.getInstance()).ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope, null)) {
            return true;
        }
        try {
            return (Boolean)this.myAccessValidator.validate(StubUpdatingIndex.INDEX_ID, () -> (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> index.processAllKeys(processor2, scope, idFilter)));
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(31);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(32);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(33);
        }
        return this.getContainingIds(indexKey, dataKey, project, null, scope);
    }

    @NotNull
    private <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable IdFilter idFilter, @Nullable GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(34);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(35);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(36);
        }
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        ID<Integer, SerializedStubTree> stubUpdatingIndexId = StubUpdatingIndex.INDEX_ID;
        UpdatableIndex index = this.getIndex(indexKey);
        if (index == null || !fileBasedIndex.ensureUpToDate(stubUpdatingIndexId, project, scope, null)) {
            IdIterator idIterator = IdIterator.EMPTY;
            if (idIterator == null) {
                StubIndexImpl.$$$reportNull$$$0(37);
            }
            return idIterator;
        }
        if (idFilter == null) {
            idFilter = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project);
        }
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = fileBasedIndex.getIndex(stubUpdatingIndexId);
        try {
            final TIntArrayList result2 = new TIntArrayList();
            IdFilter finalIdFilter = idFilter;
            this.myAccessValidator.validate(stubUpdatingIndexId, () -> (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> (Boolean)ConcurrencyUtil.withLock((Lock)stubUpdatingIndex.getReadLock(), () -> index.getData(dataKey).forEach((id2, value2) -> {
                if (finalIdFilter == null || finalIdFilter.containsFileId(id2)) {
                    result2.add(id2);
                }
                return true;
            }))));
            return new IdIterator(){
                int cursor;

                public boolean hasNext() {
                    return this.cursor < result2.size();
                }

                public int next() {
                    return result2.get(this.cursor++);
                }

                public int size() {
                    return result2.size();
                }
            };
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.forceRebuild(cause);
            }
            throw e;
        }
        IdIterator idIterator = IdIterator.EMPTY;
        if (idIterator == null) {
            StubIndexImpl.$$$reportNull$$$0(38);
        }
        return idIterator;
    }

    void initializeStubIndexes() {
        assert (!this.myInitialized);
        FileBasedIndex.getInstance();
        this.myStateFuture = new CompletableFuture();
        Future<AsyncState> future2 = IndexInfrastructure.submitGenesisTask(new StubIndexInitialization());
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            try {
                future2.get();
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    public void dispose() {
        try {
            for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
                index.dispose();
            }
        }
        finally {
            this.clearState();
        }
    }

    private void clearState() {
        this.myCachedStubIds.clear();
        this.myStateFuture = null;
        this.myState = null;
        this.myInitialized = false;
        LOG.info("StubIndexExtension-s were unloaded");
    }

    void setDataBufferingEnabled(boolean enabled) {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            index.setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupMemoryStorage() {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        stubUpdatingIndex.getWriteLock().lock();
        try {
            for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
                index.cleanupMemoryStorage();
            }
        }
        finally {
            stubUpdatingIndex.getWriteLock().unlock();
        }
    }

    void clearAllIndices() {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    <K> void removeTransientDataForFile(@NotNull StubIndexKey<K, ?> key, int inputId, @NotNull Collection<? extends K> keys2) {
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(39);
        }
        if (keys2 == null) {
            StubIndexImpl.$$$reportNull$$$0(40);
        }
        UpdatableIndex<K, Void, FileContent> index = this.getIndex(key);
        index.removeTransientDataForKeys(inputId, keys2);
    }

    private boolean dropUnregisteredIndices(@NotNull AsyncState state) {
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(41);
        }
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return false;
        }
        HashSet indicesToDrop = new HashSet(this.myPreviouslyRegistered != null ? this.myPreviouslyRegistered.registeredIndices : Collections.emptyList());
        for (ID key : state.myIndices.keySet()) {
            indicesToDrop.remove(key.getName());
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join(indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.delete((File)IndexInfrastructure.getStubIndexRootDir(s));
            }
            return true;
        }
        return false;
    }

    public StubIndexState getState() {
        if (!this.myInitialized) {
            return null;
        }
        return new StubIndexState(this.getAsyncState().myIndices.keySet());
    }

    public void loadState(@NotNull StubIndexState state) {
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(42);
        }
        this.myPreviouslyRegistered = state;
    }

    public <K> void updateIndex(@NotNull StubIndexKey<K, ?> key, final int fileId, final @NotNull Map<K, StubIdList> oldInputData, final @NotNull Map<K, StubIdList> newInputData) {
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(43);
        }
        if (oldInputData == null) {
            StubIndexImpl.$$$reportNull$$$0(44);
        }
        if (newInputData == null) {
            StubIndexImpl.$$$reportNull$$$0(45);
        }
        try {
            UpdatableIndex<K, Void, FileContent> index;
            if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                LOG.info("stub index '" + key + "' update: " + fileId + " old = " + Arrays.toString(oldInputData.keySet().toArray()) + " new  = " + Arrays.toString(newInputData.keySet().toArray()) + " updated_id = " + System.identityHashCode(newInputData));
            }
            if ((index = this.getIndex(key)) == null) {
                return;
            }
            index.updateWithMap(new AbstractUpdateData<K, Void>(fileId){

                protected boolean iterateKeys(@NotNull KeyValueUpdateProcessor<? super K, ? super Void> addProcessor, @NotNull KeyValueUpdateProcessor<? super K, ? super Void> updateProcessor, @NotNull RemovedKeyProcessor<? super K> removeProcessor) throws StorageException {
                    if (addProcessor == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (updateProcessor == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if (removeProcessor == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                        LOG.info("iterating keys updated_id = " + System.identityHashCode(newInputData));
                    }
                    boolean modified = false;
                    for (Object oldKey : oldInputData.keySet()) {
                        if (newInputData.containsKey(oldKey)) continue;
                        removeProcessor.process(oldKey, fileId);
                        if (modified) continue;
                        modified = true;
                    }
                    for (Object oldKey : newInputData.keySet()) {
                        if (oldInputData.containsKey(oldKey)) continue;
                        addProcessor.process(oldKey, null, fileId);
                        if (modified) continue;
                        modified = true;
                    }
                    if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                        LOG.info("keys iteration finished updated_id = " + System.identityHashCode(newInputData) + "; modified = " + modified);
                    }
                    return modified;
                }

                public boolean newDataIsEmpty() {
                    return newInputData.isEmpty();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "addProcessor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "updateProcessor";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "removeProcessor";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/psi/stubs/StubIndexImpl$5";
                    objectArray[2] = "iterateKeys";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (StorageException e) {
            LOG.info((Throwable)e);
            StubIndexImpl.requestRebuild();
        }
    }

    static UpdatableIndex<Integer, SerializedStubTree, FileContent> getStubUpdatingIndex() {
        return ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
    }

    public boolean areAllProblemsProcessedInTheCurrentThread() {
        return this.myStubProcessingHelper.areAllProblemsProcessedInTheCurrentThread();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 27: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 27: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationResultSink";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 27: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 4: 
            case 16: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRootDir";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 8: 
            case 18: 
            case 26: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 17: 
            case 23: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInputData";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInputData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyHashingStrategy";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeIndexValue";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 27: 
            case 37: 
            case 38: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onExceptionInstantiatingIndex";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serializeIndexValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeIndexValue";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wipeProblematicFileIdsForParticularKeyAndStubIndex";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "forceRebuild";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getContainingIds";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForFile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "dropUnregisteredIndices";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 27: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeKey<K> {
        private final K key;
        private final int fileId;

        private CompositeKey(K key, int id2) {
            this.key = key;
            this.fileId = id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey key1 = (CompositeKey)o;
            return this.fileId == key1.fileId && Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.fileId);
        }
    }

    private class StubIndexInitialization
    extends IndexInfrastructure.DataInitialization<AsyncState> {
        private final AsyncState state = new AsyncState();
        private final IndicesRegistrationResult indicesRegistrationSink = new IndicesRegistrationResult();

        private StubIndexInitialization() {
        }

        @Override
        protected void prepare() {
            StubIndexExtension extension;
            boolean forceClean;
            Iterator extensionsIterator = IndexInfrastructure.hasIndices() ? ((ExtensionPointImpl)StubIndexExtension.EP_NAME.getPoint(null)).iterator() : Collections.emptyIterator();
            boolean bl = forceClean = Boolean.TRUE == ourForcedClean.getAndSet(Boolean.FALSE);
            while (extensionsIterator.hasNext() && (extension = (StubIndexExtension)extensionsIterator.next()) != null) {
                extension.getKey();
                this.addNestedInitializationTask(() -> StubIndexImpl.registerIndexer(extension, forceClean, this.state, this.indicesRegistrationSink));
            }
        }

        @Override
        protected void onThrowable(@NotNull Throwable t) {
            if (t == null) {
                StubIndexInitialization.$$$reportNull$$$0(0);
            }
            LOG.error(t);
        }

        @Override
        protected AsyncState finish() {
            boolean someIndicesWereDropped = StubIndexImpl.this.dropUnregisteredIndices(this.state);
            StringBuilder updated = new StringBuilder();
            String updatedIndices = this.indicesRegistrationSink.changedIndices();
            if (!updatedIndices.isEmpty()) {
                updated.append(updatedIndices);
            }
            if (someIndicesWereDropped && !InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED) {
                updated.append(" and some indices were dropped");
            }
            this.indicesRegistrationSink.logChangedAndFullyBuiltIndices(LOG, "Following stub indices will be updated:", "Following stub indices will be built:");
            if (updated.length() > 0) {
                Throwable e = new Throwable(updated.toString());
                AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(() -> StubIndexImpl.this.forceRebuild(e));
            }
            StubIndexImpl.this.myInitialized = true;
            StubIndexImpl.this.myStateFuture.complete(this.state);
            return this.state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/stubs/StubIndexImpl$StubIndexInitialization", "onThrowable"));
        }
    }

    public static class StubIdExternalizer
    implements DataExternalizer<StubIdList> {
        public static final StubIdExternalizer INSTANCE = new StubIdExternalizer();

        public void save(@NotNull DataOutput out, @NotNull StubIdList value2) throws IOException {
            int size;
            if (out == null) {
                StubIdExternalizer.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                StubIdExternalizer.$$$reportNull$$$0(1);
            }
            if ((size = value2.size()) == 0) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)Integer.MAX_VALUE);
            } else if (size == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.get(0));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-size));
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.get(i));
                }
            }
        }

        @NotNull
        public StubIdList read(@NotNull DataInput in) throws IOException {
            int size;
            if (in == null) {
                StubIdExternalizer.$$$reportNull$$$0(2);
            }
            if ((size = DataInputOutputUtil.readINT((DataInput)in)) == Integer.MAX_VALUE) {
                return new StubIdList();
            }
            if (size >= 0) {
                return new StubIdList(size);
            }
            size = -size;
            int[] result2 = new int[size];
            for (int i = 0; i < size; ++i) {
                result2[i] = DataInputOutputUtil.readINT((DataInput)in);
            }
            return new StubIdList(result2, size);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AsyncState {
        private final Map<StubIndexKey<?, ?>, UpdatableIndex<?, Void, FileContent>> myIndices = new THashMap();
        private final Map<StubIndexKey<?, ?>, TObjectHashingStrategy<?>> myKeyHashingStrategies = new THashMap();
        private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();

        private AsyncState() {
        }

        static /* synthetic */ TObjectIntHashMap access$000(AsyncState x0) {
            return x0.myIndexIdToVersionMap;
        }
    }
}

