/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FileIncludeIndex
extends FileBasedIndexExtension<String, List<FileIncludeInfoImpl>> {
    public static final ID<String, List<FileIncludeInfoImpl>> INDEX_ID = ID.create((String)"fileIncludes");
    private static final int BASE_VERSION = 6;

    @NotNull
    public static List<FileIncludeInfo> getIncludes(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FileIncludeIndex.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FileIncludeIndex.$$$reportNull$$$0(1);
        }
        Map data2 = FileBasedIndex.getInstance().getFileData(INDEX_ID, file2, project);
        List list2 = ContainerUtil.flatten(data2.values());
        if (list2 == null) {
            FileIncludeIndex.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static MultiMap<VirtualFile, FileIncludeInfoImpl> getIncludingFileCandidates(String fileName, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileIncludeIndex.$$$reportNull$$$0(3);
        }
        MultiMap result2 = new MultiMap();
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)fileName, null, (file2, value2) -> {
            result2.put((Object)file2, (Collection)value2);
            return true;
        }, scope);
        MultiMap multiMap = result2;
        if (multiMap == null) {
            FileIncludeIndex.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @NotNull
    public ID<String, List<FileIncludeInfoImpl>> getName() {
        ID<String, List<FileIncludeInfoImpl>> iD = INDEX_ID;
        if (iD == null) {
            FileIncludeIndex.$$$reportNull$$$0(5);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, List<FileIncludeInfoImpl>, FileContent> getIndexer() {
        return new CompositeDataIndexer<String, List<FileIncludeInfoImpl>, Set<FileIncludeProvider>, Set<String>>(){

            @NotNull
            public Set<FileIncludeProvider> calculateSubIndexer(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Set<FileIncludeProvider> set = FileIncludeProvider.EP_NAME.getExtensionList().stream().filter(provider -> provider.acceptFile(file2.getFile())).collect(Collectors.toSet());
                if (set == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set;
            }

            @NotNull
            public Set<String> getSubIndexerVersion(@NotNull Set<FileIncludeProvider> providers) {
                if (providers == null) {
                    1.$$$reportNull$$$0(2);
                }
                Set set = ContainerUtil.map2Set(providers, provider -> provider.getId() + ":" + provider.getVersion());
                if (set == null) {
                    1.$$$reportNull$$$0(3);
                }
                return set;
            }

            @NotNull
            public KeyDescriptor<Set<String>> getSubIndexerVersionDescriptor() {
                return new StringSetDescriptor();
            }

            @NotNull
            public Map<String, List<FileIncludeInfoImpl>> map(@NotNull FileContent inputData, @NotNull Set<FileIncludeProvider> providers) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (providers == null) {
                    1.$$$reportNull$$$0(5);
                }
                Map map2 = FactoryMap.create(key -> new ArrayList());
                for (FileIncludeProvider provider : providers) {
                    for (FileIncludeInfo info : provider.getIncludeInfos(inputData)) {
                        FileIncludeInfoImpl impl = new FileIncludeInfoImpl(info.path, info.offset, info.runtimeOnly, provider.getId());
                        ((List)map2.get(info.fileName)).add(impl);
                    }
                }
                Map map3 = map2;
                if (map3 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return map3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/include/FileIncludeIndex$1";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "providers";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "calculateSubIndexer";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            FileIncludeIndex.$$$reportNull$$$0(6);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<FileIncludeInfoImpl>> getValueExternalizer() {
        return new DataExternalizer<List<FileIncludeInfoImpl>>(){

            public void save(@NotNull DataOutput out, List<FileIncludeInfoImpl> value2) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                out.writeInt(value2.size());
                for (FileIncludeInfoImpl info : value2) {
                    IOUtil.writeUTF((DataOutput)out, (String)info.path);
                    out.writeInt(info.offset);
                    out.writeBoolean(info.runtimeOnly);
                    IOUtil.writeUTF((DataOutput)out, (String)info.providerId);
                }
            }

            public List<FileIncludeInfoImpl> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                int size = in.readInt();
                ArrayList<FileIncludeInfoImpl> infos = new ArrayList<FileIncludeInfoImpl>(size);
                for (int i = 0; i < size; ++i) {
                    infos.add(new FileIncludeInfoImpl(IOUtil.readUTF((DataInput)in), in.readInt(), in.readBoolean(), IOUtil.readUTF((DataInput)in)));
                }
                return infos;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.FileTypeSpecificInputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file2.getFileSystem() == JarFileSystem.getInstance()) {
                    return false;
                }
                for (FileIncludeProvider provider : FileIncludeProvider.EP_NAME.getExtensionList()) {
                    if (!provider.acceptFile(file2)) continue;
                    return true;
                }
                return false;
            }

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    3.$$$reportNull$$$0(1);
                }
                for (FileIncludeProvider provider : FileIncludeProvider.EP_NAME.getExtensionList()) {
                    provider.registerFileTypesUsedForIndexing(fileTypeSink);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileTypeSink";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptInput";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerFileTypesUsedForIndexing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        int version2 = 6;
        if (!InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED) {
            for (FileIncludeProvider provider : FileIncludeProvider.EP_NAME.getExtensionList()) {
                version2 = version2 * 31 + (provider.getVersion() ^ provider.getClass().getName().hashCode());
            }
        }
        return version2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/include/FileIncludeIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludingFileCandidates";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIncludes";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingFileCandidates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringSetDescriptor
    implements KeyDescriptor<Set<String>> {
        private StringSetDescriptor() {
        }

        public int getHashCode(Set<String> value2) {
            return value2.hashCode();
        }

        public boolean isEqual(Set<String> val1, Set<String> val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, Set<String> value2) throws IOException {
            if (out == null) {
                StringSetDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.size());
            for (String s : value2) {
                IOUtil.writeUTF((DataOutput)out, (String)s);
            }
        }

        public Set<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                StringSetDescriptor.$$$reportNull$$$0(1);
            }
            int size = DataInputOutputUtil.readINT((DataInput)in);
            THashSet result2 = new THashSet(size);
            for (int i = 0; i < size; ++i) {
                result2.add((Object)IOUtil.readUTF((DataInput)in));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/include/FileIncludeIndex$StringSetDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

