/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Block;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.text.CharArrayUtil;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewLineBlocksIterator
implements Iterator<Block> {
    private final ProgressIndicator myIndicator;
    private final Document myDocument;
    private final int myTotalLines;
    private int myCurrentLineStartOffset;
    private int myCurrentDocumentLine;
    private final Stack<Block> myStack;

    public NewLineBlocksIterator(@NotNull Block root, @NotNull Document document) {
        if (root == null) {
            NewLineBlocksIterator.$$$reportNull$$$0(0);
        }
        if (document == null) {
            NewLineBlocksIterator.$$$reportNull$$$0(1);
        }
        this(root, document, null);
    }

    public NewLineBlocksIterator(@NotNull Block root, @NotNull Document document, @Nullable ProgressIndicator indicator) {
        if (root == null) {
            NewLineBlocksIterator.$$$reportNull$$$0(2);
        }
        if (document == null) {
            NewLineBlocksIterator.$$$reportNull$$$0(3);
        }
        this.myStack = new Stack();
        this.myStack.add(root);
        this.myDocument = document;
        this.myTotalLines = this.myDocument.getLineCount();
        this.myCurrentDocumentLine = 0;
        this.myCurrentLineStartOffset = 0;
        this.myIndicator = indicator;
    }

    @Override
    public boolean hasNext() {
        if (this.myCurrentDocumentLine < this.myTotalLines) {
            this.popUntilTopBlockStartsNewLine();
            return !this.myStack.isEmpty();
        }
        return false;
    }

    private void popUntilTopBlockStartsNewLine() {
        this.popUntilTopBlockStartOffsetGreaterOrEqual(this.myCurrentLineStartOffset);
        if (this.myStack.isEmpty()) {
            return;
        }
        Block block = this.myStack.peek();
        while (block != null && !this.isStartingNewLine(block)) {
            this.checkCancelled();
            ++this.myCurrentDocumentLine;
            if (this.myCurrentDocumentLine >= this.myTotalLines) {
                this.myStack.clear();
                break;
            }
            this.myCurrentLineStartOffset = this.myDocument.getLineStartOffset(this.myCurrentDocumentLine);
            this.popUntilTopBlockStartOffsetGreaterOrEqual(this.myCurrentLineStartOffset);
            block = this.myStack.isEmpty() ? null : this.myStack.peek();
        }
    }

    private void checkCancelled() {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
        }
    }

    @Override
    public Block next() {
        this.popUntilTopBlockStartsNewLine();
        Block current2 = this.myStack.peek();
        TextRange currentBlockRange = current2.getTextRange();
        this.myCurrentDocumentLine = this.myDocument.getLineNumber(currentBlockRange.getStartOffset());
        ++this.myCurrentDocumentLine;
        if (this.myCurrentDocumentLine < this.myTotalLines) {
            this.myCurrentLineStartOffset = this.myDocument.getLineStartOffset(this.myCurrentDocumentLine);
            if (currentBlockRange.getEndOffset() < this.myCurrentLineStartOffset) {
                this.myStack.pop();
            } else {
                this.pushAll(current2);
            }
        }
        return current2;
    }

    private void popUntilTopBlockStartOffsetGreaterOrEqual(int lineStartOffset) {
        while (!this.myStack.isEmpty()) {
            this.checkCancelled();
            Block current2 = this.myStack.peek();
            TextRange range2 = current2.getTextRange();
            if (range2.getStartOffset() >= lineStartOffset) break;
            this.myStack.pop();
            if (range2.getEndOffset() <= lineStartOffset) continue;
            this.pushAll(current2);
        }
    }

    private void pushAll(Block current2) {
        if (current2 instanceof AbstractBlock) {
            ((AbstractBlock)current2).setBuildIndentsOnly(true);
        }
        List blocks = current2.getSubBlocks();
        ListIterator iterator2 = blocks.listIterator(blocks.size());
        while (iterator2.hasPrevious()) {
            this.myStack.push((Block)iterator2.previous());
        }
    }

    private boolean isStartingNewLine(Block block) {
        TextRange range2 = block.getTextRange();
        int blockStart = range2.getStartOffset();
        int lineNumber = this.myDocument.getLineNumber(blockStart);
        int lineStartOffset = this.myDocument.getLineStartOffset(lineNumber);
        CharSequence text2 = this.myDocument.getCharsSequence();
        return CharArrayUtil.isEmptyOrSpaces((CharSequence)text2, (int)lineStartOffset, (int)blockStart);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/formatter/common/NewLineBlocksIterator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

