/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"createNewProjectFrame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "forceDisableAutoRequestFocus", "", "restoreFrameState", "", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "frameInfo", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "intellij.platform.ide.impl"})
public final class ProjectFrameAllocatorKt {
    private static final void restoreFrameState(ProjectFrameHelper frameHelper, FrameInfo frameInfo) {
        Rectangle deviceBounds = frameInfo.getBounds();
        Rectangle bounds2 = deviceBounds == null ? null : FrameBoundsConverter.convertFromDeviceSpaceAndFitToScreen(deviceBounds);
        int state = frameInfo.getExtendedState();
        boolean isMaximized = FrameInfoHelper.Companion.isMaximized(state);
        IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl, (String)"frameHelper.frame");
        IdeFrameImpl frame = ideFrameImpl;
        if (bounds2 != null && isMaximized && frame.getExtendedState() == 0) {
            frame.getRootPane().putClientProperty("normalBounds", bounds2);
        }
        if (bounds2 != null) {
            frame.setBounds(bounds2);
        }
        frame.setExtendedState(state);
        if (frameInfo.getFullScreen() && FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs()) {
            frameHelper.toggleFullScreen(true);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final IdeFrameImpl createNewProjectFrame(boolean forceDisableAutoRequestFocus) {
        IdeFrameImpl frame;
        block3: {
            block2: {
                int n;
                frame = new IdeFrameImpl();
                SplashManager.hideBeforeShow(frame);
                Rectangle rectangle = ScreenUtil.getMainScreenBounds();
                Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"ScreenUtil.getMainScreenBounds()");
                Dimension size = rectangle.getSize();
                int n2 = 1400;
                int n3 = size.width - 20;
                Dimension dimension = size;
                boolean bl = false;
                dimension.width = n = Math.min(n2, n3);
                n2 = 1000;
                n3 = size.height - 40;
                dimension = size;
                bl = false;
                dimension.height = n = Math.min(n2, n3);
                frame.setSize(size);
                frame.setLocationRelativeTo(null);
                if (forceDisableAutoRequestFocus) break block2;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isActive() || !ComponentUtil.isDisableAutoRequestFocus()) break block3;
            }
            frame.setAutoRequestFocus(false);
        }
        frame.setMinimumSize(new Dimension(340, frame.getMinimumSize().height));
        return frame;
    }

    public static final /* synthetic */ void access$restoreFrameState(ProjectFrameHelper frameHelper, FrameInfo frameInfo) {
        ProjectFrameAllocatorKt.restoreFrameState(frameHelper, frameInfo);
    }
}

