/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public abstract class DependencyVisitorFactory {
    private static final LanguageExtension<DependencyVisitorFactory> EP_NAME = new LanguageExtension("com.intellij.packageDependencies.visitor");

    @NotNull
    public abstract PsiElementVisitor getVisitor(@NotNull DependenciesBuilder.DependencyProcessor var1, @NotNull VisitorOptions var2);

    @NotNull
    public static PsiElementVisitor createVisitor(@NotNull PsiFile file2, @NotNull DependenciesBuilder.DependencyProcessor processor2, @NotNull VisitorOptions options) {
        DependencyVisitorFactory factory;
        if (file2 == null) {
            DependencyVisitorFactory.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            DependencyVisitorFactory.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DependencyVisitorFactory.$$$reportNull$$$0(2);
        }
        return (factory = (DependencyVisitorFactory)EP_NAME.forLanguage(file2.getLanguage())) != null ? factory.getVisitor(processor2, options) : new DefaultVisitor(processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
        }
        objectArray[1] = "com/intellij/packageDependencies/DependencyVisitorFactory";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DefaultVisitor
    extends PsiRecursiveElementVisitor {
        private final DependenciesBuilder.DependencyProcessor myProcessor;

        DefaultVisitor(@NotNull DependenciesBuilder.DependencyProcessor processor2) {
            if (processor2 == null) {
                DefaultVisitor.$$$reportNull$$$0(0);
            }
            this.myProcessor = processor2;
        }

        public void visitElement(@NotNull PsiElement element2) {
            if (element2 == null) {
                DefaultVisitor.$$$reportNull$$$0(1);
            }
            super.visitElement(element2);
            for (PsiReference ref : element2.getReferences()) {
                PsiElement resolved = ref.resolve();
                if (resolved == null) continue;
                this.myProcessor.process(ref.getElement(), resolved);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/packageDependencies/DependencyVisitorFactory$DefaultVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class VisitorOptions {
        public static final VisitorOptions SKIP_IMPORTS = new VisitorOptions(){

            @Override
            public boolean skipImports() {
                return true;
            }
        };
        public static final VisitorOptions INCLUDE_IMPORTS = new VisitorOptions(){

            @Override
            public boolean skipImports() {
                return false;
            }
        };

        public abstract boolean skipImports();

        public static VisitorOptions fromSettings(@NotNull Project project) {
            if (project == null) {
                VisitorOptions.$$$reportNull$$$0(0);
            }
            final DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
            return new VisitorOptions(){

                @Override
                public boolean skipImports() {
                    return manager.skipImportStatements();
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/DependencyVisitorFactory$VisitorOptions", "fromSettings"));
        }
    }
}

