/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorBasedStatusBarPopup
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    private final PopupState myPopupState;
    private final TextPanel.WithIconAndArrows myComponent;
    private final boolean myWriteableFileRequired;
    private boolean actionEnabled;
    private final Alarm update;
    private volatile Reference<Editor> myEditor;

    public EditorBasedStatusBarPopup(@NotNull Project project, boolean writeableFileRequired) {
        if (project == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(0);
        }
        super(project);
        this.myPopupState = new PopupState();
        this.myEditor = new WeakReference<Object>(null);
        this.myWriteableFileRequired = writeableFileRequired;
        this.update = new Alarm((Disposable)this);
        this.myComponent = new TextPanel.WithIconAndArrows();
        this.myComponent.setVisible(false);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditorBasedStatusBarPopup.this.update();
                EditorBasedStatusBarPopup.this.showPopup(e);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$1", "onClick"));
            }
        }.installOn((Component)((Object)this.myComponent), true);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    public final void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile newFile = event.getNewFile();
        FileEditor fileEditor = newFile == null ? null : FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(newFile);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        this.setEditor(editor);
        this.fileChanged(newFile);
    }

    @ApiStatus.Internal
    public final void setEditor(@Nullable Editor editor) {
        this.myEditor = new WeakReference<Editor>(editor);
    }

    public final void selectionChanged(@Nullable VirtualFile newFile) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        FileEditor fileEditor = newFile == null ? null : FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(newFile);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        this.myEditor = new WeakReference<Editor>(editor);
        this.fileChanged(newFile);
    }

    private void fileChanged(VirtualFile newFile) {
        this.handleFileChange(newFile);
        this.update();
    }

    protected void handleFileChange(VirtualFile file2) {
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(3);
        }
        this.fileChanged(file2);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(5);
        }
        this.fileChanged(file2);
    }

    public final StatusBarWidget copy() {
        return this.createInstance(this.getProject());
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(6);
        }
        super.install(statusBar);
        this.registerCustomListeners();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                Document document = e.getDocument();
                EditorBasedStatusBarPopup.this.updateForDocument(document);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$2", "documentChanged"));
            }
        }, (Disposable)this);
        if (this.myWriteableFileRequired) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

                public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ("writable".equals(event.getPropertyName())) {
                        EditorBasedStatusBarPopup.this.updateForFile(event.getFile());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$3", "propertyChanged"));
                }
            }));
        }
        this.setEditor(this.getEditor());
        this.update();
    }

    protected void updateForDocument(@Nullable(value="null means update anyway") @Nullable(value="null means update anyway") Document document) {
        Editor selectedEditor = this.myEditor.get();
        if (document != null && (selectedEditor == null || selectedEditor.getDocument() != document)) {
            return;
        }
        this.update();
    }

    protected void updateForFile(@Nullable(value="null means update anyway") @Nullable(value="null means update anyway") VirtualFile file2) {
        if (file2 == null) {
            this.update();
        } else {
            this.updateForDocument(FileDocumentManager.getInstance().getCachedDocument(file2));
        }
    }

    private void showPopup(@NotNull MouseEvent e) {
        if (e == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(7);
        }
        if (!this.actionEnabled || this.myPopupState.isRecentlyHidden()) {
            return;
        }
        DataContext dataContext = this.getContext();
        ListPopup popup2 = this.createPopup(dataContext);
        if (popup2 != null) {
            Dimension dimension = popup2.getContent().getPreferredSize();
            Point at = new Point(0, -dimension.height);
            popup2.addListener((JBPopupListener)this.myPopupState);
            popup2.show(new RelativePoint(e.getComponent(), at));
            Disposer.register((Disposable)this, (Disposable)popup2);
        }
    }

    @NotNull
    protected DataContext getContext() {
        VirtualFile[] virtualFileArray;
        Editor editor = this.getEditor();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myStatusBar);
        VirtualFile selectedFile = this.getSelectedFile();
        ContainerUtil.ImmutableMapBuilder immutableMapBuilder = ContainerUtil.immutableMapBuilder().put((Object)CommonDataKeys.VIRTUAL_FILE.getName(), (Object)selectedFile);
        String string = CommonDataKeys.VIRTUAL_FILE_ARRAY.getName();
        if (selectedFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = selectedFile;
        }
        DataContext dataContext = SimpleDataContext.getSimpleContext(immutableMapBuilder.put((Object)string, (Object)virtualFileArray).put((Object)CommonDataKeys.PROJECT.getName(), (Object)this.getProject()).put((Object)PlatformDataKeys.CONTEXT_COMPONENT.getName(), (Object)(editor == null ? null : editor.getComponent())).build(), parent);
        if (dataContext == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(8);
        }
        return dataContext;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    protected boolean isEmpty() {
        return StringUtil.isEmpty((String)this.myComponent.getText()) && !this.myComponent.hasIcon();
    }

    public boolean isActionEnabled() {
        return this.actionEnabled;
    }

    public void updateInTests(boolean immediately) {
        this.update();
        this.update.drainRequestsInTest();
        UIUtil.dispatchAllInvocationEvents();
        if (immediately) {
            this.update.drainRequestsInTest();
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    public void flushUpdateInTests() {
        this.update.drainRequestsInTest();
    }

    public void update() {
        this.update(null);
    }

    public void update(@Nullable Runnable finishUpdate) {
        if (this.update.isDisposed()) {
            return;
        }
        this.update.cancelAllRequests();
        this.update.addRequest(() -> {
            if (this.isDisposed()) {
                return;
            }
            VirtualFile file2 = this.getSelectedFile();
            WidgetState state = this.getWidgetState(file2);
            if (state == WidgetState.NO_CHANGE) {
                return;
            }
            if (state == WidgetState.NO_CHANGE_MAKE_VISIBLE) {
                this.myComponent.setVisible(true);
                return;
            }
            if (state == WidgetState.HIDDEN) {
                this.myComponent.setVisible(false);
                return;
            }
            this.myComponent.setVisible(true);
            this.actionEnabled = state.actionEnabled && this.isEnabledForFile(file2);
            String widgetText = state.text;
            String toolTipText = state.toolTip;
            this.myComponent.setEnabled(this.actionEnabled);
            this.myComponent.setTextAlignment(0.5f);
            this.myComponent.setIcon(state.icon);
            this.myComponent.setToolTipText(toolTipText);
            this.myComponent.setText(widgetText);
            this.myComponent.invalidate();
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
            if (finishUpdate != null) {
                finishUpdate.run();
            }
            this.afterVisibleUpdate(state);
        }, 200, ModalityState.any());
    }

    protected void afterVisibleUpdate(@NotNull WidgetState state) {
        if (state == null) {
            EditorBasedStatusBarPopup.$$$reportNull$$$0(9);
        }
    }

    @NotNull
    protected abstract WidgetState getWidgetState(@Nullable VirtualFile var1);

    protected boolean isEnabledForFile(@Nullable VirtualFile file2) {
        return file2 == null || !this.myWriteableFileRequired || file2.isWritable();
    }

    @Nullable
    protected abstract ListPopup createPopup(DataContext var1);

    protected void registerCustomListeners() {
    }

    @NotNull
    protected abstract StatusBarWidget createInstance(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "afterVisibleUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class WidgetState {
        public static final WidgetState HIDDEN = new WidgetState();
        public static final WidgetState NO_CHANGE = new WidgetState();
        public static final WidgetState NO_CHANGE_MAKE_VISIBLE = new WidgetState();
        protected final String toolTip;
        private final String text;
        private final boolean actionEnabled;
        private Icon icon;

        private WidgetState() {
            this("", "", false);
        }

        public WidgetState(@Nls(capitalization=Nls.Capitalization.Sentence) String toolTip, @Nls String text2, boolean actionEnabled) {
            this.toolTip = toolTip;
            this.text = text2;
            this.actionEnabled = actionEnabled;
        }

        public static WidgetState getDumbModeState(String name, String widgetPrefix) {
            return new WidgetState(ActionUtil.getUnavailableMessage((String)name, (boolean)false), widgetPrefix + IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]), false);
        }

        public void setIcon(Icon icon2) {
            this.icon = icon2;
        }
    }
}

