/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.WatchRootsUtil;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;

final class WatchRootsManager {
    private static final Logger LOG = Logger.getInstance(WatchRootsManager.class);
    private final FileWatcher myFileWatcher;
    private final NavigableMap<String, List<LocalFileSystem.WatchRequest>> myRecursiveWatchRoots;
    private final NavigableMap<String, List<LocalFileSystem.WatchRequest>> myFlatWatchRoots;
    private final NavigableSet<String> myOptimizedRecursiveWatchRoots;
    private final NavigableMap<String, SymlinkData> mySymlinksByPath;
    private final TIntObjectHashMap<SymlinkData> mySymlinksById;
    private final MultiMap<String, String> myPathMappings;
    private boolean myWatcherRequiresUpdate;
    private final Object myLock;

    WatchRootsManager(@NotNull FileWatcher fileWatcher, @NotNull Disposable parent) {
        if (fileWatcher == null) {
            WatchRootsManager.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            WatchRootsManager.$$$reportNull$$$0(1);
        }
        this.myRecursiveWatchRoots = WatchRootsUtil.createFileNavigableMap();
        this.myFlatWatchRoots = WatchRootsUtil.createFileNavigableMap();
        this.myOptimizedRecursiveWatchRoots = WatchRootsUtil.createFileNavigableSet();
        this.mySymlinksByPath = WatchRootsUtil.createFileNavigableMap();
        this.mySymlinksById = new TIntObjectHashMap();
        this.myPathMappings = MultiMap.createConcurrentSet();
        this.myLock = new Object();
        this.myFileWatcher = fileWatcher;
        ApplicationManager.getApplication().getMessageBus().connect(parent).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = WatchRootsManager.this.myLock;
                synchronized (object) {
                    if (WatchRootsManager.this.myWatcherRequiresUpdate) {
                        WatchRootsManager.this.updateFileWatcher();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/local/WatchRootsManager$1", "after"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> requestsToRemove, @NotNull Collection<String> recursiveRootsToAdd, @NotNull Collection<String> flatRootsToAdd) {
        if (requestsToRemove == null) {
            WatchRootsManager.$$$reportNull$$$0(2);
        }
        if (recursiveRootsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(3);
        }
        if (flatRootsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(4);
        }
        HashSet<LocalFileSystem.WatchRequest> recursiveRequestsToRemove = new HashSet<LocalFileSystem.WatchRequest>();
        HashSet<LocalFileSystem.WatchRequest> flatRequestsToRemove = new HashSet<LocalFileSystem.WatchRequest>();
        requestsToRemove.forEach(req -> (req.isToWatchRecursively() ? recursiveRequestsToRemove : flatRequestsToRemove).add(req));
        HashSet<LocalFileSystem.WatchRequest> result2 = new HashSet<LocalFileSystem.WatchRequest>(recursiveRootsToAdd.size() + flatRootsToAdd.size());
        Object object = this.myLock;
        synchronized (object) {
            this.updateWatchRoots(recursiveRootsToAdd, recursiveRequestsToRemove, result2, this.myRecursiveWatchRoots, true);
            this.updateWatchRoots(flatRootsToAdd, flatRequestsToRemove, result2, this.myFlatWatchRoots, false);
            if (this.myWatcherRequiresUpdate) {
                this.updateFileWatcher();
            }
        }
        HashSet<LocalFileSystem.WatchRequest> hashSet = result2;
        if (hashSet == null) {
            WatchRootsManager.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myRecursiveWatchRoots.clear();
            this.myOptimizedRecursiveWatchRoots.clear();
            this.myFlatWatchRoots.clear();
            this.myPathMappings.clear();
            this.mySymlinksById.forEachValue(data2 -> {
                data2.clear();
                return true;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSymlink(int fileId, String linkPath, @Nullable String linkTarget) {
        Object object = this.myLock;
        synchronized (object) {
            SymlinkData data2 = (SymlinkData)this.mySymlinksById.get(fileId);
            if (data2 != null) {
                if (FileUtil.pathsEqual((String)data2.path, (String)linkPath) && FileUtil.pathsEqual((String)data2.target, (String)linkTarget)) {
                    return;
                }
                this.mySymlinksById.remove(fileId);
                this.mySymlinksByPath.remove(data2.path);
                data2.removeRequest(this);
            }
            data2 = new SymlinkData(fileId, linkPath, linkTarget);
            SymlinkData existing = (SymlinkData)this.mySymlinksByPath.get(linkPath);
            if (existing != null) {
                LOG.error("Path conflict. Existing symlink: " + existing + " vs. new symlink: " + data2);
                return;
            }
            this.mySymlinksByPath.put(data2.path, data2);
            this.mySymlinksById.put(data2.id, (Object)data2);
            if (data2.hasValidTarget() && WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, data2.path)) {
                this.addWatchSymlinkRequest(data2.getWatchRequest());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSymlink(int fileId) {
        Object object = this.myLock;
        synchronized (object) {
            SymlinkData data2 = (SymlinkData)this.mySymlinksById.remove(fileId);
            if (data2 != null) {
                this.mySymlinksByPath.remove(data2.path);
                data2.removeRequest(this);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void updateFileWatcher() {
        JBIterable flatWatchRootsIterable;
        NavigableSet<@SystemDependent String> recursiveWatchRoots = WatchRootsUtil.createFileNavigableSet();
        @SystemDependent @SystemDependent MultiMap initialMappings = MultiMap.create();
        if (File.separatorChar == '/') {
            flatWatchRootsIterable = this.myFlatWatchRoots.navigableKeySet();
            recursiveWatchRoots.addAll(this.myOptimizedRecursiveWatchRoots);
            initialMappings.putAllValues(this.myPathMappings);
        } else {
            Function pathMapper = path -> path.replace('/', File.separatorChar);
            flatWatchRootsIterable = JBIterable.from(this.myFlatWatchRoots.navigableKeySet()).map(pathMapper);
            JBIterable.from(this.myOptimizedRecursiveWatchRoots).map(pathMapper).addAllTo(recursiveWatchRoots);
            for (Map.Entry entry : this.myPathMappings.entrySet()) {
                initialMappings.putValues(pathMapper.fun(entry.getKey()), (Collection)ContainerUtil.map((Collection)((Collection)entry.getValue()), (Function)pathMapper));
            }
        }
        NavigableSet<@SystemDependent String> flatWatchRoots = WatchRootsUtil.optimizeFlatRoots((Iterable<String>)flatWatchRootsIterable, recursiveWatchRoots);
        this.myFileWatcher.setWatchRoots(new CanonicalPathMap(recursiveWatchRoots, flatWatchRoots, (MultiMap<String, String>)initialMappings));
        this.myWatcherRequiresUpdate = false;
    }

    private void updateWatchRoots(Collection<String> rootsToAdd, Set<LocalFileSystem.WatchRequest> requestsToRemove, Set<LocalFileSystem.WatchRequest> result2, NavigableMap<String, List<LocalFileSystem.WatchRequest>> roots, boolean recursiveWatchRoots) {
        SmartList watchSymlinkRequestsToAdd = new SmartList();
        for (String root : rootsToAdd) {
            String watchRoot = WatchRootsManager.prepareWatchRoot(root);
            if (watchRoot == null) continue;
            List requests = roots.computeIfAbsent(watchRoot, key -> new SmartList());
            boolean foundSameRequest = false;
            if (!requestsToRemove.isEmpty()) {
                for (LocalFileSystem.WatchRequest currentRequest : requests) {
                    if (!requestsToRemove.remove(currentRequest)) continue;
                    foundSameRequest = true;
                    result2.add(currentRequest);
                }
            }
            if (foundSameRequest) continue;
            WatchRequestImpl newRequest = new WatchRequestImpl(watchRoot, recursiveWatchRoots);
            requests.add(newRequest);
            result2.add(newRequest);
            if (recursiveWatchRoots) {
                this.collectSymlinkRequests(newRequest, (Collection<WatchSymlinkRequest>)watchSymlinkRequestsToAdd);
            }
            if (requests.size() != 1 || WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot)) continue;
            this.myWatcherRequiresUpdate = true;
            if (!recursiveWatchRoots) continue;
            WatchRootsUtil.insertRecursivePath(this.myOptimizedRecursiveWatchRoots, watchRoot);
        }
        SmartList watchSymlinkRequestsToRemove = new SmartList();
        for (LocalFileSystem.WatchRequest request2 : requestsToRemove) {
            this.removeWatchRequest(request2);
            if (!recursiveWatchRoots) continue;
            this.collectSymlinkRequests((WatchRequestImpl)request2, (Collection<WatchSymlinkRequest>)watchSymlinkRequestsToRemove);
        }
        if (recursiveWatchRoots) {
            this.addWatchSymlinkRequests((List<WatchSymlinkRequest>)watchSymlinkRequestsToAdd);
            this.removeWatchSymlinkRequests((List<WatchSymlinkRequest>)watchSymlinkRequestsToRemove);
        }
    }

    @Nullable
    private static String prepareWatchRoot(String root) {
        int index = root.indexOf("!/");
        if (index >= 0) {
            root = root.substring(0, index);
        }
        try {
            Path rootPath = Paths.get(FileUtil.toSystemDependentName((String)root), new String[0]);
            if (!rootPath.isAbsolute()) {
                throw new InvalidPathException(root, "Watch roots should be absolute");
            }
            return FileUtil.toSystemIndependentName((String)rootPath.toString());
        }
        catch (InvalidPathException e) {
            LOG.warn("invalid watch root", (Throwable)e);
            return null;
        }
    }

    private void removeWatchRequest(LocalFileSystem.WatchRequest request2) {
        String watchRoot = request2.getRootPath();
        NavigableMap<String, List<LocalFileSystem.WatchRequest>> roots = request2.isToWatchRecursively() ? this.myRecursiveWatchRoots : this.myFlatWatchRoots;
        List requests = (List)roots.get(watchRoot);
        if (requests != null) {
            requests.remove(request2);
            if (requests.isEmpty()) {
                roots.remove(watchRoot);
                if (request2.isToWatchRecursively()) {
                    if (WatchRootsUtil.removeRecursivePath(this.myOptimizedRecursiveWatchRoots, this.myRecursiveWatchRoots, watchRoot)) {
                        this.myWatcherRequiresUpdate = true;
                    }
                } else if (!WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot)) {
                    this.myWatcherRequiresUpdate = true;
                }
            }
        }
    }

    private void addWatchSymlinkRequests(List<WatchSymlinkRequest> watchSymlinkRequestsToAdd) {
        for (WatchSymlinkRequest request2 : watchSymlinkRequestsToAdd) {
            if (request2.getRootPath().isEmpty() || request2.isRegistered()) continue;
            this.addWatchSymlinkRequest(request2);
        }
    }

    private void addWatchSymlinkRequest(WatchSymlinkRequest request2) {
        String watchRoot = request2.getRootPath();
        NavigableMap<String, List<LocalFileSystem.WatchRequest>> roots = request2.isToWatchRecursively() ? this.myRecursiveWatchRoots : this.myFlatWatchRoots;
        List requests = roots.computeIfAbsent(watchRoot, key -> new SmartList());
        requests.add(request2);
        if (requests.size() == 1 && !WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot) && request2.isToWatchRecursively()) {
            WatchRootsUtil.insertRecursivePath(this.myOptimizedRecursiveWatchRoots, watchRoot);
        }
        if (request2.setRegistered(true)) {
            this.myWatcherRequiresUpdate = true;
            this.myPathMappings.putValue((Object)watchRoot, (Object)request2.getOriginalPath());
        }
    }

    private void removeWatchSymlinkRequests(List<WatchSymlinkRequest> watchSymlinkRequestsToRemove) {
        for (WatchSymlinkRequest request2 : watchSymlinkRequestsToRemove) {
            Ref remove2 = new Ref((Object)true);
            WatchRootsUtil.forEachPathSegment(request2.getOriginalPath(), '/', path -> {
                List requests = (List)this.myRecursiveWatchRoots.get(path);
                if (requests != null && ContainerUtil.findInstance((Iterable)requests, WatchRequestImpl.class) != null) {
                    remove2.set((Object)false);
                    return false;
                }
                return true;
            });
            if (!((Boolean)remove2.get()).booleanValue()) continue;
            this.removeWatchSymlinkRequest(request2);
        }
    }

    private void removeWatchSymlinkRequest(WatchSymlinkRequest request2) {
        if (!request2.isRegistered()) {
            return;
        }
        this.removeWatchRequest(request2);
        if (request2.setRegistered(false)) {
            this.myPathMappings.remove((Object)request2.getRootPath(), (Object)request2.getOriginalPath());
            this.myWatcherRequiresUpdate = true;
        }
    }

    private void collectSymlinkRequests(WatchRequestImpl newRequest, Collection<WatchSymlinkRequest> watchSymlinkRequestsToAdd) {
        assert (newRequest.isToWatchRecursively()) : newRequest;
        WatchRootsUtil.collectByPrefix(this.mySymlinksByPath, newRequest.getRootPath(), e -> {
            if (((SymlinkData)e.getValue()).hasValidTarget()) {
                watchSymlinkRequestsToAdd.add(((SymlinkData)e.getValue()).getWatchRequest());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestsToRemove";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveRootsToAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatRootsToAdd";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWatchedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SymlinkData {
        final int id;
        @NotNull
        final @SystemIndependent String path;
        @Nullable
        final @SystemIndependent String target;
        private WatchSymlinkRequest myWatchRequest;

        SymlinkData(int id2, String path, @Nullable String target2) {
            this.id = id2;
            this.path = FileUtil.toSystemIndependentName((String)path);
            this.target = target2 != null ? FileUtil.toSystemIndependentName((String)target2) : null;
        }

        @NotNull
        WatchSymlinkRequest getWatchRequest() {
            assert (this.hasValidTarget());
            if (this.myWatchRequest == null) {
                this.myWatchRequest = new WatchSymlinkRequest(this, true);
            }
            WatchSymlinkRequest watchSymlinkRequest = this.myWatchRequest;
            if (watchSymlinkRequest == null) {
                SymlinkData.$$$reportNull$$$0(0);
            }
            return watchSymlinkRequest;
        }

        boolean hasValidTarget() {
            return this.target != null;
        }

        void removeRequest(WatchRootsManager manager) {
            if (this.myWatchRequest != null) {
                manager.removeWatchSymlinkRequest(this.myWatchRequest);
                this.myWatchRequest = null;
            }
        }

        void clear() {
            this.myWatchRequest = null;
        }

        public String toString() {
            return "SymlinkData{" + this.id + ", " + this.path + " -> " + this.target + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/WatchRootsManager$SymlinkData", "getWatchRequest"));
        }
    }

    private static class WatchSymlinkRequest
    implements LocalFileSystem.WatchRequest {
        private final SymlinkData mySymlinkData;
        private final boolean myWatchRecursively;
        private boolean myRegistered = false;

        WatchSymlinkRequest(SymlinkData data2, boolean watchRecursively) {
            this.mySymlinkData = data2;
            assert (this.mySymlinkData.hasValidTarget());
            this.myWatchRecursively = watchRecursively;
        }

        boolean isRegistered() {
            return this.myRegistered;
        }

        boolean setRegistered(boolean registered) {
            if (this.myRegistered != registered) {
                this.myRegistered = registered;
                return true;
            }
            return false;
        }

        @NotNull
        public @SystemIndependent String getRootPath() {
            String string = Objects.requireNonNull(this.mySymlinkData.target);
            if (string == null) {
                WatchSymlinkRequest.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        String getOriginalPath() {
            return this.mySymlinkData.path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchSymlinkRequest", "getRootPath"));
        }
    }

    private static class WatchRequestImpl
    implements LocalFileSystem.WatchRequest {
        private final String myFSRootPath;
        private final boolean myWatchRecursively;

        WatchRequestImpl(String rootPath, boolean watchRecursively) {
            this.myFSRootPath = rootPath;
            this.myWatchRecursively = watchRecursively;
        }

        @NotNull
        public @SystemIndependent String getRootPath() {
            String string = this.myFSRootPath;
            if (string == null) {
                WatchRequestImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        public String toString() {
            return this.getRootPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchRequestImpl", "getRootPath"));
        }
    }
}

