/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.local.SymbolicLinkRefresher;
import com.intellij.openapi.vfs.impl.local.WatchRootsManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalFileSystemImpl
extends LocalFileSystemBase
implements Disposable,
VirtualFilePointerCapableFileSystem {
    private static final int STATUS_UPDATE_PERIOD = 1000;
    private final ManagingFS myManagingFS = ManagingFS.getInstance();
    private final FileWatcher myWatcher = new FileWatcher(this.myManagingFS);
    private final WatchRootsManager myWatchRootsManager;
    private volatile boolean myDisposed;

    public LocalFileSystemImpl() {
        if (this.myWatcher.isOperational()) {
            AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
                if (!ApplicationManager.getApplication().isDisposed()) {
                    this.storeRefreshStatusToFiles();
                }
            }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
        this.myWatchRootsManager = new WatchRootsManager(this.myWatcher, this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
        new SymbolicLinkRefresher(this);
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        FileWatcher fileWatcher = this.myWatcher;
        if (fileWatcher == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(0);
        }
        return fileWatcher;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myWatcher.dispose();
    }

    private void storeRefreshStatusToFiles() {
        if (this.myWatcher.isOperational()) {
            FileWatcher.DirtyPaths dirtyPaths = this.myWatcher.getDirtyPaths();
            this.markPathsDirty(dirtyPaths.dirtyPaths);
            this.markFlatDirsDirty(dirtyPaths.dirtyDirectories);
            this.markRecursiveDirsDirty(dirtyPaths.dirtyPathsRecursive);
        }
    }

    private void markPathsDirty(@NotNull Iterable<String> dirtyPaths) {
        if (dirtyPaths == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(1);
        }
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file2 = this.findFileByPathIfCached(dirtyPath);
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markDirty();
        }
    }

    private void markFlatDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        if (dirtyPaths == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(2);
        }
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirty();
                for (VirtualFile child2 : ((NewVirtualFile)pair.first).getCachedChildren()) {
                    ((NewVirtualFile)child2).markDirty();
                }
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    private void markRecursiveDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        if (dirtyPaths == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(3);
        }
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirtyRecursively();
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    public void markSuspiciousFilesDirty(@NotNull List<? extends VirtualFile> files2) {
        if (files2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(4);
        }
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String string : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspiciousRoot = this.findFileByPathIfCached(string);
                if (suspiciousRoot == null) continue;
                ((NewVirtualFile)suspiciousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile virtualFile : files2) {
                if (virtualFile.getFileSystem() != this) continue;
                ((NewVirtualFile)virtualFile).markDirtyRecursively();
            }
        }
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequestsToRemove, @Nullable Collection<String> recursiveRootsToAdd, @Nullable Collection<String> flatRootsToAdd) {
        if (watchRequestsToRemove == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(5);
        }
        if (this.myDisposed) {
            Set<LocalFileSystem.WatchRequest> set = Collections.emptySet();
            if (set == null) {
                LocalFileSystemImpl.$$$reportNull$$$0(6);
            }
            return set;
        }
        List nonNullWatchRequestsToRemove = ContainerUtil.skipNulls(watchRequestsToRemove);
        LOG.assertTrue(nonNullWatchRequestsToRemove.size() == watchRequestsToRemove.size(), (Object)"watch requests collection should not contain `null` elements");
        Set<LocalFileSystem.WatchRequest> set = this.myWatchRootsManager.replaceWatchedRoots(nonNullWatchRequestsToRemove, (Collection)ObjectUtils.notNull(recursiveRootsToAdd, Collections.emptyList()), (Collection)ObjectUtils.notNull(flatRootsToAdd, Collections.emptyList()));
        if (set == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        Runnable heavyRefresh = () -> {
            for (VirtualFile root : this.myManagingFS.getRoots((NewVirtualFileSystem)this)) {
                ((NewVirtualFile)root).markDirtyRecursively();
            }
            this.refresh(asynchronous);
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, this.myManagingFS.getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    @ApiStatus.Internal
    public final void symlinkUpdated(int fileId, @Nullable VirtualFile parent, @NotNull String linkPath, @Nullable String linkTarget) {
        if (linkPath == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(8);
        }
        if (linkTarget == null || !LocalFileSystemImpl.isRecursiveOrCircularSymlink(linkPath, linkTarget, parent)) {
            this.myWatchRootsManager.updateSymlink(fileId, linkPath, linkTarget);
        }
    }

    @ApiStatus.Internal
    public final void symlinkRemoved(int fileId) {
        this.myWatchRootsManager.removeSymlink(fileId);
    }

    public String toString() {
        return "LocalFileSystem";
    }

    public void cleanupForNextTest() {
        FileDocumentManager.getInstance().saveAllDocuments();
        PersistentFS.getInstance().clearIdCache();
        this.myWatchRootsManager.clear();
    }

    private static boolean isRecursiveOrCircularSymlink(@NotNull String linkPath, @NotNull String symlinkTarget, @Nullable VirtualFile parent) {
        if (linkPath == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(9);
        }
        if (symlinkTarget == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(10);
        }
        if (FileUtil.startsWith((String)linkPath, (String)symlinkTarget)) {
            return true;
        }
        if (!(parent instanceof VirtualFileSystemEntry)) {
            return false;
        }
        for (VirtualFileSystemEntry p = (VirtualFileSystemEntry)parent; p != null; p = p.getParent()) {
            String parentResolved;
            if (!p.hasSymlink()) {
                return false;
            }
            if (!p.is(VFileProperty.SYMLINK) || (parentResolved = p.getCanonicalPath()) == null || !symlinkTarget.equals(parentResolved)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyPaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequestsToRemove";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symlinkTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileWatcher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWatchedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "markPathsDirty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markFlatDirsDirty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markRecursiveDirsDirty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markSuspiciousFilesDirty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "symlinkUpdated";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveOrCircularSymlink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

