/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginRepositoryRequests;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginsAdvertiser {
    static final Logger LOG = Logger.getInstance(PluginsAdvertiser.class);
    private static final String CASHED_EXTENSIONS = "extensions.xml";
    public static final String IGNORE_ULTIMATE_EDITION = "ignoreUltimateEdition";
    public static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Plugins Suggestion", NotificationDisplayType.STICKY_BALLOON, true);
    public static final String FUS_GROUP_ID = "plugins.advertiser";
    private static SoftReference<KnownExtensions> ourKnownExtensions = new SoftReference(null);

    @Nullable
    public static List<Plugin> retrieve(@NotNull UnknownFeature unknownFeature) throws IOException {
        if (unknownFeature == null) {
            PluginsAdvertiser.$$$reportNull$$$0(0);
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("featureType", unknownFeature.getFeatureType());
        map2.put("implementationName", unknownFeature.getImplementationName());
        map2.put("build", PluginRepositoryRequests.getBuildForPluginRepositoryRequests());
        return (List)PluginsAdvertiser.processFeatureRequest(map2, request2 -> {
            JsonReader jsonReader = new JsonReader((Reader)request2.getReader());
            jsonReader.setLenient(true);
            JsonElement jsonRootElement = JsonParser.parseReader((JsonReader)jsonReader);
            ArrayList<Plugin> result2 = new ArrayList<Plugin>();
            for (JsonElement jsonElement : jsonRootElement.getAsJsonArray()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                JsonElement pluginId = jsonObject.get("pluginId");
                JsonElement pluginName = jsonObject.get("pluginName");
                JsonElement bundled = jsonObject.get("bundled");
                result2.add(new Plugin(StringUtil.unquoteString((String)pluginId.toString()), pluginName != null ? StringUtil.unquoteString((String)pluginName.toString()) : null, Boolean.parseBoolean(StringUtil.unquoteString((String)bundled.toString()))));
            }
            return result2;
        });
    }

    static void loadSupportedExtensions(@NotNull List<? extends IdeaPluginDescriptor> allPlugins) throws IOException {
        if (allPlugins == null) {
            PluginsAdvertiser.$$$reportNull$$$0(1);
        }
        HashMap<String, IdeaPluginDescriptor> availableIds = new HashMap<String, IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : allPlugins) {
            availableIds.put(ideaPluginDescriptor.getPluginId().getIdString(), ideaPluginDescriptor);
        }
        Map<String, String> params = Collections.singletonMap("featureType", FileTypeFactory.FILE_TYPE_FACTORY_EP.getName());
        PluginsAdvertiser.processFeatureRequest(params, request2 -> {
            JsonReader jsonReader = new JsonReader((Reader)request2.getReader());
            jsonReader.setLenient(true);
            JsonElement jsonRootElement = JsonParser.parseReader((JsonReader)jsonReader);
            HashMap<String, Set<Plugin>> result2 = new HashMap<String, Set<Plugin>>();
            for (JsonElement jsonElement : jsonRootElement.getAsJsonArray()) {
                JsonElement pluginNameElement;
                IdeaPluginDescriptor loadedPlugin;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String pluginId = StringUtil.unquoteString((String)jsonObject.get("pluginId").toString());
                JsonElement bundledExt = jsonObject.get("bundled");
                boolean isBundled = Boolean.parseBoolean(bundledExt.toString());
                IdeaPluginDescriptor fromServerPluginDescription = (IdeaPluginDescriptor)availableIds.get(pluginId);
                if (fromServerPluginDescription == null && !isBundled || (loadedPlugin = PluginManagerCore.getPlugin(PluginId.getId((String)pluginId))) != null && loadedPlugin.isEnabled() || loadedPlugin != null && fromServerPluginDescription != null && StringUtil.compareVersionNumbers((String)loadedPlugin.getVersion(), (String)fromServerPluginDescription.getVersion()) >= 0 || fromServerPluginDescription != null && PluginManagerCore.isBrokenPlugin(fromServerPluginDescription)) continue;
                JsonElement ext = jsonObject.get("implementationName");
                String extension = StringUtil.unquoteString((String)ext.toString());
                HashSet<Plugin> pluginIds = (HashSet<Plugin>)result2.get(extension);
                if (pluginIds == null) {
                    pluginIds = new HashSet<Plugin>();
                    result2.put(extension, pluginIds);
                }
                String pluginName = (pluginNameElement = jsonObject.get("pluginName")) != null ? StringUtil.unquoteString((String)pluginNameElement.toString()) : null;
                pluginIds.add(new Plugin(pluginId, pluginName, isBundled));
            }
            PluginsAdvertiser.saveExtensions(result2);
            return result2;
        });
    }

    private static <K> K processFeatureRequest(@NotNull Map<String, String> params, @NotNull HttpRequests.RequestProcessor<K> requestProcessor) throws IOException {
        String baseUrl;
        Url url;
        if (params == null) {
            PluginsAdvertiser.$$$reportNull$$$0(2);
        }
        if (requestProcessor == null) {
            PluginsAdvertiser.$$$reportNull$$$0(3);
        }
        if ((url = Urls.parseEncoded((String)(baseUrl = ApplicationInfoImpl.getShadowInstance().getPluginManagerUrl() + "/feature/getImplementations?"))) == null) {
            LOG.error("Cannot parse URL: " + baseUrl);
            return null;
        }
        return (K)HttpRequests.request((Url)url.addParameters(params)).productNameAsUserAgent().connect(requestProcessor);
    }

    static void ensureDeleted() {
        FileUtil.delete((File)PluginsAdvertiser.getExtensionsFile());
    }

    @Nullable
    public static KnownExtensions loadExtensions() {
        KnownExtensions knownExtensions = (KnownExtensions)ourKnownExtensions.get();
        if (knownExtensions != null) {
            return knownExtensions;
        }
        try {
            File file2 = PluginsAdvertiser.getExtensionsFile();
            if (file2.isFile()) {
                knownExtensions = (KnownExtensions)XmlSerializer.deserialize((Element)JDOMUtil.load((File)file2), KnownExtensions.class);
                ourKnownExtensions = new SoftReference((Object)knownExtensions);
                return knownExtensions;
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    private static File getExtensionsFile() {
        return new File(PathManager.getPluginsPath(), CASHED_EXTENSIONS);
    }

    static void saveExtensions(Map<String, Set<Plugin>> extensions2) throws IOException {
        File plugins2 = PluginsAdvertiser.getExtensionsFile();
        if (!plugins2.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins2);
        }
        JDOMUtil.write((Element)XmlSerializer.serialize((Object)new KnownExtensions(extensions2)), (File)plugins2);
    }

    public static void openDownloadPage() {
        BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl("https://www.jetbrains.com/idea/download/"));
    }

    static void enablePlugins(Project project, Collection<IdeaPluginDescriptor> disabledPlugins) {
        PluginManagerConfigurable.showPluginConfigurableAndEnable(project, disabledPlugins.toArray(new IdeaPluginDescriptor[0]));
    }

    @Nullable
    static IdeaPluginDescriptor getDisabledPlugin(Set<? extends Plugin> plugins2) {
        for (Plugin plugin : plugins2) {
            PluginId pluginId = PluginId.getId((String)plugin.myPluginId);
            if (!PluginManagerCore.isDisabled(pluginId)) continue;
            return PluginManagerCore.getPlugin(pluginId);
        }
        return null;
    }

    @Nullable
    static List<String> hasBundledPluginToInstall(Collection<? extends Plugin> plugins2) {
        if (PlatformUtils.isIdeaUltimate()) {
            return null;
        }
        ArrayList<String> bundled = new ArrayList<String>();
        for (Plugin plugin : plugins2) {
            if (!plugin.myBundled || PluginManagerCore.getPlugin(PluginId.getId((String)plugin.myPluginId)) != null) continue;
            bundled.add(plugin.myPluginName != null ? plugin.myPluginName : plugin.myPluginId);
        }
        return bundled.isEmpty() ? null : bundled;
    }

    @Deprecated
    public static void installAndEnablePlugins(@NotNull Set<String> pluginIds, @NotNull Runnable onSuccess2) {
        if (pluginIds == null) {
            PluginsAdvertiser.$$$reportNull$$$0(4);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(5);
        }
        PluginsAdvertiser.installAndEnable(new LinkedHashSet<PluginId>(ContainerUtil.map(pluginIds, it -> PluginId.getId((String)it))), onSuccess2);
    }

    public static void installAndEnable(@NotNull Set<PluginId> pluginIds, @NotNull Runnable onSuccess2) {
        if (pluginIds == null) {
            PluginsAdvertiser.$$$reportNull$$$0(6);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(7);
        }
        PluginsAdvertiser.installAndEnable(null, pluginIds, true, onSuccess2);
    }

    public static void installAndEnable(@Nullable Project project, final @NotNull Set<PluginId> pluginIds, final boolean showDialog, final @NotNull Runnable onSuccess2) {
        if (pluginIds == null) {
            PluginsAdvertiser.$$$reportNull$$$0(8);
        }
        if (onSuccess2 == null) {
            PluginsAdvertiser.$$$reportNull$$$0(9);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, IdeBundle.message((String)"plugins.advertiser.task.searching.for.plugins", (Object[])new Object[0]), true){
            private final Set<PluginDownloader> myPlugins;
            private List<IdeaPluginDescriptor> myAllPlugins;
            {
                super(arg0, arg1, arg2);
                this.myPlugins = new HashSet<PluginDownloader>();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    this.myAllPlugins = RepositoryHelper.loadPluginsFromAllRepositories(indicator);
                    for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                        if (descriptor2.isEnabled() || !pluginIds.contains(descriptor2.getPluginId())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(descriptor2));
                    }
                    for (IdeaPluginDescriptor loadedPlugin : this.myAllPlugins) {
                        if (!pluginIds.contains(loadedPlugin.getPluginId())) continue;
                        this.myPlugins.add(PluginDownloader.createDownloader(loadedPlugin));
                    }
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }

            public void onSuccess() {
                if (this.myAllPlugins == null) {
                    return;
                }
                PluginsAdvertiserDialog advertiserDialog = new PluginsAdvertiserDialog(null, this.myPlugins.toArray(new PluginDownloader[0]), this.myAllPlugins);
                if (showDialog) {
                    if (advertiserDialog.showAndGet()) {
                        onSuccess2.run();
                    }
                } else if (advertiserDialog.doInstallPlugins()) {
                    onSuccess2.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$1", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownFeature";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "retrieve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSupportedExtensions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processFeatureRequest";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "installAndEnablePlugins";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "installAndEnable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="plugin")
    public static class Plugin
    implements Comparable<Plugin> {
        public String myPluginId;
        public String myPluginName;
        public boolean myBundled;

        @Deprecated
        public Plugin(PluginId pluginId, String pluginName, boolean bundled) {
            this(pluginId.getIdString(), pluginName, bundled);
        }

        public Plugin(String pluginId, String pluginName, boolean bundled) {
            this.myPluginId = pluginId;
            this.myBundled = bundled;
            this.myPluginName = pluginName;
        }

        public Plugin() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugin plugin = (Plugin)o;
            if (this.myBundled != plugin.myBundled) {
                return false;
            }
            if (!this.myPluginId.equals(plugin.myPluginId)) {
                return false;
            }
            return this.myPluginName == null || this.myPluginName.equals(plugin.myPluginName);
        }

        public int hashCode() {
            int result2 = this.myPluginId.hashCode();
            result2 = 31 * result2 + (this.myBundled ? 1 : 0);
            result2 = 31 * result2 + (this.myPluginName != null ? this.myPluginName.hashCode() : 0);
            return result2;
        }

        @Override
        public int compareTo(@NotNull Plugin other) {
            if (other == null) {
                Plugin.$$$reportNull$$$0(0);
            }
            if (this.myBundled && !other.myBundled) {
                return -1;
            }
            if (!this.myBundled && other.myBundled) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)this.myPluginId), (Comparable)((Object)other.myPluginId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$Plugin", "compareTo"));
        }
    }

    @Tag(value="plugins")
    public static final class PluginSet {
        public final Set<Plugin> myPlugins = new HashSet<Plugin>();

        public PluginSet() {
        }

        public PluginSet(Set<? extends Plugin> plugins2) {
            this.myPlugins.addAll(plugins2);
        }
    }

    @Tag(value="exts")
    public static final class KnownExtensions {
        @OptionTag
        @XMap
        public final Map<String, PluginSet> myExtensions;

        public KnownExtensions() {
            this.myExtensions = new HashMap<String, PluginSet>();
        }

        public KnownExtensions(@NotNull Map<String, Set<Plugin>> extensions2) {
            if (extensions2 == null) {
                KnownExtensions.$$$reportNull$$$0(0);
            }
            this.myExtensions = new HashMap<String, PluginSet>();
            for (String ext : extensions2.keySet()) {
                this.myExtensions.put(ext, new PluginSet(extensions2.get(ext)));
            }
        }

        @Nullable
        public Set<Plugin> find(@NotNull String extension) {
            PluginSet pluginSet;
            if (extension == null) {
                KnownExtensions.$$$reportNull$$$0(1);
            }
            return (pluginSet = this.myExtensions.get(extension)) != null ? pluginSet.myPlugins : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiser$KnownExtensions";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

