/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBalloonNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkEditorNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import com.intellij.util.TripleFunction;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownSdkTracker {
    private static final Logger LOG = Logger.getInstance(UnknownSdkTracker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private UnknownSdkSnapshot myPreviousRequestCache;

    @NotNull
    public static UnknownSdkTracker getInstance(@NotNull Project project) {
        if (project == null) {
            UnknownSdkTracker.$$$reportNull$$$0(0);
        }
        UnknownSdkTracker unknownSdkTracker = (UnknownSdkTracker)project.getService(UnknownSdkTracker.class);
        if (unknownSdkTracker == null) {
            UnknownSdkTracker.$$$reportNull$$$0(1);
        }
        return unknownSdkTracker;
    }

    public UnknownSdkTracker(@NotNull Project project) {
        if (project == null) {
            UnknownSdkTracker.$$$reportNull$$$0(2);
        }
        this.myPreviousRequestCache = null;
        this.myProject = project;
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass().getSimpleName(), 700, true, null, (Disposable)this.myProject, null, false).usePassThroughInUnitTestMode();
    }

    public void updateUnknownSdks() {
        this.myUpdateQueue.queue(new Update("update"){

            public void run() {
                if (!Registry.is((String)"unknown.sdk") || !UnknownSdkResolver.EP_NAME.hasAnyExtensions()) {
                    UnknownSdkTracker.this.showStatus(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
                    return;
                }
                new UnknownSdkCollector(UnknownSdkTracker.this.myProject).collectSdksPromise(snapshot -> {
                    if (snapshot.equals(UnknownSdkTracker.this.myPreviousRequestCache)) {
                        return;
                    }
                    UnknownSdkTracker.this.myPreviousRequestCache = snapshot;
                    UnknownSdkTracker.this.onFixableAndMissingSdksCollected(UnknownSdkTracker.filterOnlyAllowedEntries(snapshot.getResolvableSdks()));
                });
            }
        });
    }

    private static boolean allowFixesFor(@NotNull SdkTypeId type) {
        if (type == null) {
            UnknownSdkTracker.$$$reportNull$$$0(3);
        }
        return UnknownSdkResolver.EP_NAME.findFirstSafe(it -> it.supportsResolution(type)) != null;
    }

    @NotNull
    private static <E extends UnknownSdk> List<E> filterOnlyAllowedEntries(@NotNull List<? extends E> input) {
        if (input == null) {
            UnknownSdkTracker.$$$reportNull$$$0(4);
        }
        ArrayList<UnknownSdk> copy2 = new ArrayList<UnknownSdk>();
        for (UnknownSdk item : input) {
            SdkType type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor((SdkTypeId)type)) continue;
            copy2.add(item);
        }
        ArrayList<UnknownSdk> arrayList = copy2;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void onFixableAndMissingSdksCollected(final @NotNull List<UnknownSdk> fixable) {
        if (fixable == null) {
            UnknownSdkTracker.$$$reportNull$$$0(6);
        }
        if (fixable.isEmpty()) {
            this.showStatus(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(ProjectBundle.message((String)"progress.text.resolving.missing.sdks", (Object[])new Object[0]));
                List lookups = UnknownSdkTracker.this.collectSdkLookups(indicator);
                indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.local.sdks", (Object[])new Object[0]));
                Map localFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeLocalFix);
                indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.downloadable.sdks", (Object[])new Object[0]));
                Map downloadFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeDownload);
                if (!localFixes.isEmpty()) {
                    indicator.setText(ProjectBundle.message((String)"progress.text.configuring.sdks", (Object[])new Object[0]));
                    UnknownSdkTracker.this.configureLocalSdks(localFixes);
                }
                UnknownSdkTracker.this.showStatus(fixable, localFixes, downloadFixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$2", "run"));
            }
        });
    }

    private void showStatus(@NotNull List<UnknownSdk> unknownSdksWithoutFix, @NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes, @NotNull Map<UnknownSdk, UnknownSdkDownloadableSdkFix> downloadFixes) {
        if (unknownSdksWithoutFix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(7);
        }
        if (localFixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(8);
        }
        if (downloadFixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(9);
        }
        UnknownSdkBalloonNotification.getInstance(this.myProject).notifyFixedSdks(localFixes);
        UnknownSdkEditorNotification.getInstance(this.myProject).showNotifications(unknownSdksWithoutFix, downloadFixes);
    }

    @NotNull
    private List<UnknownSdkResolver.UnknownSdkLookup> collectSdkLookups(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(10);
        }
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> lookups = new ArrayList<UnknownSdkResolver.UnknownSdkLookup>();
        UnknownSdkResolver.EP_NAME.forEachExtensionSafe(ext -> {
            UnknownSdkResolver.UnknownSdkLookup resolver = ext.createResolver(this.myProject, indicator);
            if (resolver != null) {
                lookups.add(resolver);
            }
        });
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> arrayList = lookups;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void applyDownloadableFix(@NotNull UnknownSdk info, @NotNull UnknownSdkDownloadableSdkFix fix) {
        if (info == null) {
            UnknownSdkTracker.$$$reportNull$$$0(12);
        }
        if (fix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(13);
        }
        UnknownSdkTracker.downloadFix(this.myProject, info, fix, (Consumer<? super Sdk>)((Consumer)sdk2 -> {}), (Consumer<? super Sdk>)((Consumer)sdk2 -> {
            if (sdk2 != null) {
                this.updateUnknownSdks();
            }
        }));
    }

    @ApiStatus.Internal
    public static void downloadFix(@Nullable Project project, @NotNull UnknownSdk info, final @NotNull UnknownSdkDownloadableSdkFix fix, @NotNull Consumer<? super Sdk> onSdkNameReady, @NotNull Consumer<? super Sdk> onCompleted) {
        SdkDownloadTask task2;
        if (info == null) {
            UnknownSdkTracker.$$$reportNull$$$0(14);
        }
        if (fix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(15);
        }
        if (onSdkNameReady == null) {
            UnknownSdkTracker.$$$reportNull$$$0(16);
        }
        if (onCompleted == null) {
            UnknownSdkTracker.$$$reportNull$$$0(17);
        }
        String title = ProjectBundle.message((String)"progress.title.downloading.sdk", (Object[])new Object[0]);
        try {
            task2 = (SdkDownloadTask)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<SdkDownloadTask, RuntimeException>(project, title, true){

                protected SdkDownloadTask compute(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return fix.createTask(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$3", "compute"));
                }
            });
        }
        catch (ProcessCanceledException e) {
            onCompleted.consume(null);
            throw e;
        }
        catch (Exception error) {
            LOG.warn("Failed to download " + info.getSdkType().getPresentableName() + " " + fix.getDownloadDescription() + " for " + info + ". " + error.getMessage(), (Throwable)error);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)ProjectBundle.message((String)"dialog.message.failed.to.download.0.1", (Object[])new Object[]{fix.getDownloadDescription(), error.getMessage()}), (String)title));
            onCompleted.consume(null);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                Disposable lifetime = Disposer.newDisposable();
                String actualSdkName = info.getSdkName();
                if (actualSdkName == null) {
                    actualSdkName = task2.getSuggestedSdkName();
                }
                Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(actualSdkName, (SdkTypeId)info.getSdkType());
                SdkDownloadTracker downloadTracker = SdkDownloadTracker.getInstance();
                downloadTracker.registerSdkDownload(sdk2, task2);
                String targetSdkName = actualSdkName;
                downloadTracker.tryRegisterDownloadingListener(sdk2, lifetime, new ProgressIndicatorBase(), (Consumer<Boolean>)((Consumer)success -> {
                    Disposer.dispose((Disposable)lifetime);
                    UnknownSdkTracker.registerNewSdkInJdkTable(targetSdkName, sdk2);
                    onCompleted.consume(success != false ? sdk2 : null);
                }));
                onSdkNameReady.consume((Object)sdk2);
                downloadTracker.startSdkDownloadIfNeeded(sdk2);
            }
            catch (Exception error) {
                LOG.warn("Failed to download " + info.getSdkType().getPresentableName() + " " + fix.getDownloadDescription() + " for " + info + ". " + error.getMessage(), (Throwable)error);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)ProjectBundle.message((String)"dialog.message.failed.to.download.0.1", (Object[])new Object[]{fix.getDownloadDescription(), error.getMessage()}), (String)title));
                onCompleted.consume(null);
            }
        });
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler createSdkSelectionPopup(@Nullable String sdkName, @Nullable SdkType sdkType) {
        EditorNotificationPanel.ActionHandler actionHandler = SdkPopupFactory.newBuilder().withProject(this.myProject).withSdkTypeFilter((Condition<SdkTypeId>)((Condition)type -> sdkType == null || Objects.equals(type, sdkType))).onSdkSelected(sdk2 -> {
            UnknownSdkTracker.registerNewSdkInJdkTable(sdkName, sdk2);
            this.updateUnknownSdks();
        }).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            UnknownSdkTracker.$$$reportNull$$$0(18);
        }
        return actionHandler;
    }

    private void configureLocalSdks(@NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes) {
        if (localFixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(19);
        }
        if (localFixes.isEmpty()) {
            return;
        }
        for (Map.Entry<UnknownSdk, UnknownSdkLocalSdkFix> e : localFixes.entrySet()) {
            UnknownSdk info = e.getKey();
            UnknownSdkLocalSdkFix fix = e.getValue();
            UnknownSdkTracker.configureLocalSdk(info, fix, (Consumer<? super Sdk>)((Consumer)sdk2 -> {}));
        }
        this.updateUnknownSdks();
    }

    @ApiStatus.Internal
    public static void configureLocalSdk(@NotNull UnknownSdk info, @NotNull UnknownSdkLocalSdkFix fix, @NotNull Consumer<? super Sdk> onCompleted) {
        if (info == null) {
            UnknownSdkTracker.$$$reportNull$$$0(20);
        }
        if (fix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(21);
        }
        if (onCompleted == null) {
            UnknownSdkTracker.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                String actualSdkName = info.getSdkName();
                if (actualSdkName == null) {
                    actualSdkName = fix.getSuggestedSdkName();
                }
                Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(actualSdkName, (SdkTypeId)info.getSdkType());
                SdkModificator mod = sdk2.getSdkModificator();
                mod.setHomePath(FileUtil.toSystemIndependentName((String)fix.getExistingSdkHome()));
                mod.setVersionString(fix.getVersionString());
                mod.commitChanges();
                try {
                    info.getSdkType().setupSdkPaths(sdk2);
                }
                catch (Exception error) {
                    LOG.warn("Failed to setupPaths for " + sdk2 + ". " + error.getMessage(), (Throwable)error);
                }
                UnknownSdkTracker.registerNewSdkInJdkTable(actualSdkName, sdk2);
                LOG.info("Automatically set Sdk " + info + " to " + fix.getExistingSdkHome());
                onCompleted.consume((Object)sdk2);
            }
            catch (Exception error) {
                LOG.warn("Failed to configure " + info.getSdkType().getPresentableName() + "  for " + info + " for path " + fix + ". " + error.getMessage(), (Throwable)error);
                onCompleted.consume(null);
            }
        });
    }

    @NotNull
    private static <R> Map<UnknownSdk, R> findFixesAndRemoveFixable(@NotNull ProgressIndicator indicator, @NotNull List<UnknownSdk> infos, @NotNull List<UnknownSdkResolver.UnknownSdkLookup> lookups, @NotNull TripleFunction<UnknownSdkResolver.UnknownSdkLookup, UnknownSdk, ProgressIndicator, R> fun) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(23);
        }
        if (infos == null) {
            UnknownSdkTracker.$$$reportNull$$$0(24);
        }
        if (lookups == null) {
            UnknownSdkTracker.$$$reportNull$$$0(25);
        }
        if (fun == null) {
            UnknownSdkTracker.$$$reportNull$$$0(26);
        }
        indicator.pushState();
        LinkedHashMap<UnknownSdk, Object> result2 = new LinkedHashMap<UnknownSdk, Object>();
        Iterator<UnknownSdk> iterator2 = infos.iterator();
        block0: while (iterator2.hasNext()) {
            UnknownSdk info = iterator2.next();
            for (UnknownSdkResolver.UnknownSdkLookup lookup2 : lookups) {
                indicator.pushState();
                Object fix = fun.fun((Object)lookup2, (Object)info, (Object)indicator);
                indicator.popState();
                if (fix == null) continue;
                result2.put(info, fix);
                iterator2.remove();
                continue block0;
            }
        }
        indicator.popState();
        LinkedHashMap<UnknownSdk, Object> linkedHashMap = result2;
        if (linkedHashMap == null) {
            UnknownSdkTracker.$$$reportNull$$$0(27);
        }
        return linkedHashMap;
    }

    private static void registerNewSdkInJdkTable(@Nullable String sdkName, @NotNull Sdk sdk2) {
        if (sdk2 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(28);
        }
        WriteAction.run(() -> {
            ProjectJdkTable table = ProjectJdkTable.getInstance();
            if (sdkName != null) {
                Sdk clash = table.findJdk(sdkName);
                if (clash != null) {
                    LOG.warn("SDK with name " + sdkName + " already exists: clash=" + clash + ", new=" + sdk2);
                    return;
                }
                SdkModificator mod = sdk2.getSdkModificator();
                mod.setName(sdkName);
                mod.commitChanges();
            }
            table.addJdk(sdk2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 18: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 18: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownSdksWithoutFix";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFixes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadFixes";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkNameReady";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCompleted";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookups";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOnlyAllowedEntries";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdkLookups";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkSelectionPopup";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findFixesAndRemoveFixable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 18: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allowFixesFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterOnlyAllowedEntries";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onFixableAndMissingSdksCollected";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectSdkLookups";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyDownloadableFix";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "downloadFix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configureLocalSdks";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureLocalSdk";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findFixesAndRemoveFixable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerNewSdkInJdkTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 18: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

