/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.KeymapManagerImplKt;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeymapSchemeManager
extends AbstractSchemeActions<KeymapScheme>
implements SchemesModel<KeymapScheme> {
    public static final Predicate<Keymap> FILTER = keymap2 -> !SystemInfo.isMac || !"$default".equals(keymap2.getName());
    private final List<KeymapScheme> list = new ArrayList<KeymapScheme>();
    private final KeymapSelector selector;
    private static final Comparator<KeymapScheme> SCHEME_COMPARATOR = (scheme1, scheme2) -> {
        if (scheme1 == scheme2) {
            return 0;
        }
        if (scheme1 == null) {
            return -1;
        }
        if (scheme2 == null) {
            return 1;
        }
        return KeymapManagerImplKt.getKeymapComparator().compare(scheme1.getCurrent(), scheme2.getCurrent());
    };

    KeymapSchemeManager(KeymapSelector selector) {
        super(selector);
        this.selector = selector;
    }

    Keymap getSelectedKeymap() {
        KeymapScheme scheme = (KeymapScheme)this.selector.getSelectedScheme();
        return scheme == null ? null : scheme.getCurrent();
    }

    Keymap getMutableKeymap(Keymap keymap2) {
        KeymapScheme scheme = this.find(keymap2);
        if (scheme == null) {
            return null;
        }
        if (scheme.isMutable()) {
            return scheme.getMutable();
        }
        String name = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{keymap2.getPresentableName()});
        int i = 1;
        while (this.containsScheme(name, false)) {
            name = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{keymap2.getPresentableName(), i});
            ++i;
        }
        return this.copyScheme(scheme, name).getMutable();
    }

    void visitMutableKeymaps(Consumer<? super Keymap> consumer) {
        for (KeymapScheme scheme : this.list) {
            if (!scheme.isMutable()) continue;
            consumer.accept(scheme.getMutable());
        }
    }

    @Override
    @NotNull
    protected Class<KeymapScheme> getSchemeType() {
        return KeymapScheme.class;
    }

    @Override
    protected void onSchemeChanged(@Nullable KeymapScheme scheme) {
        this.selector.notifyConsumer(scheme);
    }

    @Override
    public boolean isProjectScheme(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    protected void duplicateScheme(@NotNull KeymapScheme parent, @NotNull String name) {
        if (parent == null) {
            KeymapSchemeManager.$$$reportNull$$$0(2);
        }
        if (name == null) {
            KeymapSchemeManager.$$$reportNull$$$0(3);
        }
        this.copyScheme(parent, name);
    }

    @NotNull
    private KeymapScheme copyScheme(@NotNull KeymapScheme parent, @NotNull String name) {
        if (parent == null) {
            KeymapSchemeManager.$$$reportNull$$$0(4);
        }
        if (name == null) {
            KeymapSchemeManager.$$$reportNull$$$0(5);
        }
        KeymapScheme scheme = parent.copy(name);
        this.list.add(scheme);
        this.selector.selectKeymap(scheme, true);
        KeymapScheme keymapScheme = scheme;
        if (keymapScheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(6);
        }
        return keymapScheme;
    }

    @Override
    public boolean canDeleteScheme(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(7);
        }
        return scheme.isMutable();
    }

    @Override
    public void removeScheme(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(8);
        }
        this.list.remove(scheme);
        this.selector.selectKeymap(this.getSchemeToSelect(scheme.getParent()), true);
    }

    @Override
    public boolean canRenameScheme(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(9);
        }
        return scheme.isMutable();
    }

    @Override
    protected void renameScheme(@NotNull KeymapScheme scheme, @NotNull String name) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(10);
        }
        if (name == null) {
            KeymapSchemeManager.$$$reportNull$$$0(11);
        }
        scheme.setName(name);
        this.selector.selectKeymap(scheme, true);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean projectScheme) {
        if (name == null) {
            KeymapSchemeManager.$$$reportNull$$$0(12);
        }
        return null != this.find((? super KeymapScheme scheme) -> scheme.contains(name));
    }

    @Override
    public boolean differsFromDefault(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(13);
        }
        return scheme.canReset();
    }

    @Override
    public boolean canResetScheme(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(14);
        }
        return scheme.isMutable();
    }

    @Override
    protected void resetScheme(@NotNull KeymapScheme scheme) {
        if (scheme == null) {
            KeymapSchemeManager.$$$reportNull$$$0(15);
        }
        scheme.reset();
        this.selector.selectKeymap(scheme, true);
    }

    boolean canResetActionInKeymap(Keymap mutable, String actionId) {
        KeymapScheme scheme = this.find(mutable);
        return scheme != null && scheme.canReset(actionId);
    }

    void resetActionInKeymap(Keymap mutable, String actionId) {
        KeymapScheme scheme = this.find(mutable);
        if (scheme == null) {
            return;
        }
        scheme.reset(actionId);
        this.selector.selectKeymap(scheme, false);
    }

    private KeymapScheme find(Keymap keymap2) {
        return keymap2 == null ? null : this.find((? super KeymapScheme scheme) -> scheme.contains(keymap2));
    }

    private KeymapScheme find(@NotNull Predicate<? super KeymapScheme> predicate) {
        if (predicate == null) {
            KeymapSchemeManager.$$$reportNull$$$0(16);
        }
        for (KeymapScheme scheme : this.list) {
            if (!predicate.test(scheme)) continue;
            return scheme;
        }
        return null;
    }

    void reset() {
        this.list.clear();
        KeymapSchemeManager.getKeymaps().forEach(keymap2 -> this.list.add(new KeymapScheme((Keymap)keymap2)));
        this.selector.selectKeymap(this.getSchemeToSelect(null), true);
    }

    void handleKeymapAdded(Keymap keymap2) {
        this.list.add(new KeymapScheme(keymap2));
    }

    void handleKeymapRemoved(Keymap keymap2) {
        this.list.removeIf(scheme -> scheme.contains(keymap2));
    }

    void handleActiveKeymapChanged(Keymap keymap2) {
        KeymapScheme scheme = this.find(keymap2);
        if (scheme != null) {
            this.selector.selectKeymap(scheme, false);
        }
    }

    String apply() {
        HashSet<String> set = new HashSet<String>();
        for (KeymapScheme scheme2 : this.list) {
            String name = scheme2.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return KeyMapBundle.message((String)"configuration.all.keymaps.should.have.non.empty.names.error.message", (Object[])new Object[0]);
            }
            if (set.add(name)) continue;
            return KeyMapBundle.message((String)"configuration.all.keymaps.should.have.unique.names.error.message", (Object[])new Object[0]);
        }
        KeymapScheme selected2 = (KeymapScheme)this.selector.getSelectedScheme();
        Keymap active = selected2 == null ? null : selected2.getOriginal();
        List keymaps = ContainerUtil.map(this.list, scheme -> scheme.apply());
        KeymapManagerImpl manager = (KeymapManagerImpl)KeymapManager.getInstance();
        manager.setKeymaps(keymaps, active, FILTER);
        this.selector.notifyConsumer(selected2);
        return null;
    }

    @NotNull
    private static List<Keymap> getKeymaps() {
        List<Keymap> list2 = ((KeymapManagerImpl)KeymapManager.getInstance()).getKeymaps(FILTER);
        if (list2 == null) {
            KeymapSchemeManager.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private KeymapScheme getSchemeToSelect(Keymap active) {
        if (active == null) {
            active = KeymapManager.getInstance().getActiveKeymap();
        }
        KeymapScheme found = null;
        for (KeymapScheme scheme : this.list) {
            Keymap keymap2 = scheme.getOriginal();
            if (keymap2 == active) {
                return scheme;
            }
            if (found != null && !"Mac OS X 10.5+".equals(keymap2.getName())) continue;
            found = scheme;
        }
        return found;
    }

    boolean isModified() {
        Keymap active;
        KeymapScheme selected2 = (KeymapScheme)this.selector.getSelectedScheme();
        Keymap keymap2 = active = selected2 == null ? null : selected2.getOriginal();
        if (!Objects.equals(active, KeymapManager.getInstance().getActiveKeymap())) {
            return true;
        }
        Iterator keymaps = KeymapSchemeManager.getKeymaps().stream().sorted(KeymapManagerImplKt.getKeymapComparator()).iterator();
        Iterator<KeymapScheme> schemes = this.list.iterator();
        while (keymaps.hasNext() && schemes.hasNext()) {
            if (Objects.equals(keymaps.next(), schemes.next().getCurrent())) continue;
            return true;
        }
        return keymaps.hasNext() || schemes.hasNext();
    }

    List<KeymapScheme> getSchemes() {
        this.list.sort(SCHEME_COMPARATOR);
        return this.list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapSchemeManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapSchemeManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyScheme";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeymaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "duplicateScheme";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyScheme";
                break;
            }
            case 6: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renameScheme";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resetScheme";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

