/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.OpenProjectProvider;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.util.io.PathKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\b'\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H$J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH$J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0016J$\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J$\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/OpenProjectProvider;", "()V", "canOpenPlatformProject", "", "projectDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "canOpenProject", "file", "createProject", "Lcom/intellij/openapi/project/Project;", "focusOnOpenedSameProject", "", "getProjectDirectory", "isChildExistUsingIo", "parent", "name", "isProjectFile", "linkAndRefreshProject", "", "project", "linkToExistingProject", "projectFile", "openPlatformProject", "projectToClose", "forceOpenInNewFrame", "openProject", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public abstract class AbstractOpenProjectProvider
implements OpenProjectProvider {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    protected abstract boolean isProjectFile(@NotNull VirtualFile var1);

    protected abstract void linkAndRefreshProject(@NotNull String var1, @NotNull Project var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canOpenProject(@NotNull VirtualFile file2) {
        boolean bl;
        block2: {
            void $this$any$iv;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            if (!file2.isDirectory()) {
                return this.isProjectFile(file2);
            }
            VirtualFile[] virtualFileArray = file2.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"file.children");
            VirtualFile[] virtualFileArray2 = virtualFileArray;
            AbstractOpenProjectProvider abstractOpenProjectProvider = this;
            boolean $i$f$any = false;
            void var5_5 = $this$any$iv;
            int n = ((void)var5_5).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void p1 = element$iv = var5_5[i];
                boolean bl2 = false;
                if (!abstractOpenProjectProvider.isProjectFile((VirtualFile)p1)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public Project openProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        LOG.debug("Open project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        String string = projectDirectory.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectDirectory.path");
        if (this.focusOnOpenedSameProject(string)) {
            return null;
        }
        if (this.canOpenPlatformProject(projectDirectory)) {
            return this.openPlatformProject(projectDirectory, projectToClose, forceOpenInNewFrame);
        }
        Project project = this.createProject(projectDirectory);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        String string2 = projectDirectory.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"projectDirectory.path");
        this.linkAndRefreshProject(string2, project2);
        ProjectUtil.updateLastProjectLocation(projectDirectory.getPath());
        Path path2 = path = Paths.get(projectDirectory.getPath(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        PlatformProjectOpenProcessor.Companion.openExistingProject(path2, path, new OpenProjectTask(forceOpenInNewFrame, projectToClose, false, false, project2, null, false, false, false, null, null, null, 0, 0, 16364, null));
        return project2;
    }

    @Override
    public void linkToExistingProject(@NotNull VirtualFile projectFile, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        LOG.debug("Import project from " + projectFile);
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        String string = projectDirectory.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectDirectory.path");
        this.linkAndRefreshProject(string, project);
    }

    private final boolean canOpenPlatformProject(VirtualFile projectDirectory) {
        if (!PlatformProjectOpenProcessor.Companion.getInstance().canOpenProject(projectDirectory)) {
            return false;
        }
        if (this.isChildExistUsingIo(projectDirectory, ".idea")) {
            return true;
        }
        return this.isChildExistUsingIo(projectDirectory, projectDirectory.getName() + ".ipr");
    }

    private final boolean isChildExistUsingIo(VirtualFile parent, String name) {
        boolean bl;
        try {
            Path path = Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), name);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(FileUtil.toSys\u2026tName(parent.path), name)");
            bl = PathKt.exists((Path)path);
        }
        catch (InvalidPathException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean focusOnOpenedSameProject(String projectDirectory) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        for (Project project : projectManager.getOpenProjects()) {
            if (!ProjectUtil.isSameProject(projectDirectory, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return true;
        }
        return false;
    }

    private final Project openPlatformProject(VirtualFile projectDirectory, Project projectToClose, boolean forceOpenInNewFrame) {
        PlatformProjectOpenProcessor openProcessor = PlatformProjectOpenProcessor.Companion.getInstance();
        Project project = openProcessor.doOpenProject(projectDirectory, projectToClose, forceOpenInNewFrame);
        if (project == null) {
            return null;
        }
        return project;
    }

    private final VirtualFile getProjectDirectory(VirtualFile file2) {
        if (!file2.isDirectory()) {
            VirtualFile virtualFile = file2.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file.parent");
            return virtualFile;
        }
        return file2;
    }

    private final Project createProject(VirtualFile projectDirectory) {
        Project project;
        block0: {
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            Project project2 = project = projectManager.createProject(projectDirectory.getName(), projectDirectory.getPath());
            if (project2 == null) break block0;
            project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
        }
        return project;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(AbstractOpenProjectProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Abstr\u2026jectProvider::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

