/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.AsyncFileChangeListenerBase;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/VirtualFilesChangesProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase;", "()V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "processRecursively", "", "getProcessRecursively", "()Z", "apply", "", "init", "isRelevant", "path", "", "subscribe", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "updateFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.platform.externalSystem.impl"})
public final class VirtualFilesChangesProvider
extends AsyncFileChangeListenerBase
implements FilesChangesProvider {
    private final EventDispatcher<FilesChangesListener> eventDispatcher;
    private final boolean processRecursively = false;

    @Override
    public void subscribe(@NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    protected boolean getProcessRecursively() {
        return this.processRecursively;
    }

    @Override
    protected void init() {
        ((FilesChangesListener)this.eventDispatcher.getMulticaster()).init();
    }

    @Override
    protected void apply() {
        ((FilesChangesListener)this.eventDispatcher.getMulticaster()).apply();
    }

    @Override
    protected boolean isRelevant(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return true;
    }

    @Override
    protected void updateFile(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.isFromSave()) {
            return;
        }
        ProjectStatus.ModificationType modificationType = event.isFromRefresh() ? ProjectStatus.ModificationType.EXTERNAL : ProjectStatus.ModificationType.INTERNAL;
        FilesChangesListener filesChangesListener = (FilesChangesListener)this.eventDispatcher.getMulticaster();
        String string = file2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        filesChangesListener.onFileChange(string, file2.getModificationStamp(), modificationType);
    }

    public VirtualFilesChangesProvider() {
        EventDispatcher eventDispatcher = EventDispatcher.create(FilesChangesListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(F\u2026ngesListener::class.java)");
        this.eventDispatcher = eventDispatcher;
    }
}

