/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker$sam$java_util_function_BinaryOperator$0;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectRefreshListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ProjectBatchFileChangeListener;
import com.intellij.openapi.externalSystem.autoimport.ProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.observable.operations.AnonymousParallelOperationTrace;
import com.intellij.openapi.observable.operations.CompoundParallelOperationTrace;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.BooleanProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalSystemProjectTracker", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u000214\b\u0007\u0018\u0000 Q2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0003QRSB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0016J\r\u00100\u001a\u000201H\u0002\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u0002042\u0006\u00105\u001a\u00020&H\u0002\u00a2\u0006\u0002\u00106J\u0006\u00107\u001a\u00020.J\f\u00108\u001a\b\u0012\u0004\u0012\u00020%09J\n\u0010:\u001a\u0004\u0018\u00010;H\u0002J\b\u0010<\u001a\u00020\u0003H\u0016J\b\u0010=\u001a\u00020.H\u0016J\u0010\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0018\u0010>\u001a\u00020.2\u0006\u0010@\u001a\u00020%2\u0006\u00105\u001a\u00020&H\u0002J\u0010\u0010A\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0016J?\u0010#\u001a\u0004\u0018\u00010&2\u0006\u0010/\u001a\u00020%2+\u0010B\u001a'\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0D\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010&0C\u00a2\u0006\u0002\bEH\u0002J\u0010\u0010F\u001a\u00020.2\u0006\u0010G\u001a\u00020\u0019H\u0002J\u0010\u0010H\u001a\u00020.2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0016J\u0006\u0010L\u001a\u00020.J\b\u0010M\u001a\u00020.H\u0016J\b\u0010N\u001a\u00020.H\u0016J\b\u0010O\u001a\u00020.H\u0002J\f\u0010<\u001a\u00020,*\u00020&H\u0002J\f\u0010<\u001a\u00020+*\u00020%H\u0002J\u0011\u0010<\u001a\u00070)\u00a2\u0006\u0002\b\r*\u00020PH\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010 \u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectTracker;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "AUTO_REPARSE_DELAY", "", "getAUTO_REPARSE_DELAY", "()I", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "autoReloadExternalChangesProperty", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "debugThrowable", "", "debugThrowable$annotations", "()V", "dispatcher", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "<set-?>", "", "isAutoReloadExternalChanges", "()Z", "setAutoReloadExternalChanges", "(Z)V", "isAutoReloadExternalChanges$delegate", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "isDisabled", "projectChangeOperation", "Lcom/intellij/openapi/observable/operations/AnonymousParallelOperationTrace;", "projectDataMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectData;", "projectRefreshOperation", "Lcom/intellij/openapi/observable/operations/CompoundParallelOperationTrace;", "", "projectStates", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State$Id;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State$Project;", "activate", "", "id", "createProjectChangesListener", "com/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectChangesListener$1", "()Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectChangesListener$1;", "createProjectRefreshListener", "com/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectRefreshListener$1", "projectData", "(Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectData;)Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$createProjectRefreshListener$1;", "enableAutoImportInTests", "getActivatedProjects", "", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "getState", "initializeComponent", "loadState", "state", "projectId", "markDirty", "action", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "refreshProject", "doImportDeactivatedProjects", "register", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "remove", "scheduleChangeProcessing", "scheduleProjectNotificationUpdate", "scheduleProjectRefresh", "updateProjectNotification", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Companion", "ProjectData", "State", "intellij.platform.externalSystem.impl"})
public final class AutoImportProjectTracker
implements ExternalSystemProjectTracker,
PersistentStateComponent<State> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Throwable debugThrowable;
    private final Logger LOG;
    private final ConcurrentHashMap<State.Id, State.Project> projectStates;
    private final ConcurrentHashMap<ExternalSystemProjectId, ProjectData> projectDataMap;
    private final AtomicBooleanProperty isDisabled;
    private final AtomicBooleanProperty autoReloadExternalChangesProperty;
    private final AnonymousParallelOperationTrace projectChangeOperation;
    private final CompoundParallelOperationTrace<String> projectRefreshOperation;
    private final MergingUpdateQueue dispatcher;
    private final ExecutorService backgroundExecutor;
    @NotNull
    private final AtomicBooleanProperty isAutoReloadExternalChanges$delegate;
    private final Project project;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AutoImportProjectTracker.class), "isAutoReloadExternalChanges", "isAutoReloadExternalChanges()Z"))};
        Companion = new Companion(null);
    }

    private static /* synthetic */ void debugThrowable$annotations() {
    }

    private final int getAUTO_REPARSE_DELAY() {
        DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings = DaemonCodeAnalyzerSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)daemonCodeAnalyzerSettings, (String)"DaemonCodeAnalyzerSettings.getInstance()");
        return daemonCodeAnalyzerSettings.getAutoReparseDelay();
    }

    public boolean isAutoReloadExternalChanges() {
        return (Boolean)this.isAutoReloadExternalChanges$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void setAutoReloadExternalChanges(boolean bl) {
        this.isAutoReloadExternalChanges$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    private final createProjectChangesListener.1 createProjectChangesListener() {
        return new ProjectBatchFileChangeListener(this, this.project){
            final /* synthetic */ AutoImportProjectTracker this$0;

            public void batchChangeStarted(@Nullable String activityName) {
                AutoImportProjectTracker.access$getProjectChangeOperation$p(this.this$0).startTask();
            }

            public void batchChangeCompleted() {
                AutoImportProjectTracker.access$getProjectChangeOperation$p(this.this$0).finishTask();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
    }

    private final createProjectRefreshListener.1 createProjectRefreshListener(ProjectData projectData2) {
        return new ExternalSystemProjectRefreshListener(this, projectData2){
            @NotNull
            private final String id;
            final /* synthetic */ AutoImportProjectTracker this$0;
            final /* synthetic */ ProjectData $projectData;

            @NotNull
            public final String getId() {
                return this.id;
            }

            public void beforeProjectRefresh() {
                AutoImportProjectTracker.access$getProjectRefreshOperation$p(this.this$0).startTask(this.id);
                this.$projectData.getStatus().markSynchronized(LocalTimeCounter.currentTime());
                this.$projectData.setActivated(true);
            }

            public void afterProjectRefresh(@NotNull ExternalSystemRefreshStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                if (status != ExternalSystemRefreshStatus.SUCCESS) {
                    ProjectStatus.markDirty$default(this.$projectData.getStatus(), LocalTimeCounter.currentTime(), null, 2, null);
                }
                AutoImportProjectTracker.access$getProjectRefreshOperation$p(this.this$0).finishTask(this.id);
            }
            {
                this.this$0 = $outer;
                this.$projectData = $captured_local_variable$1;
                this.id = "ProjectTracker: " + $captured_local_variable$1.getProjectAware().getProjectId().getReadableName();
            }
        };
    }

    public void scheduleProjectRefresh() {
        this.LOG.debug("Schedule project refresh");
        this.dispatcher.queue(new Update(this, "update"){
            final /* synthetic */ AutoImportProjectTracker this$0;

            public void run() {
                AutoImportProjectTracker.access$refreshProject(this.this$0, true);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    public void scheduleProjectNotificationUpdate() {
        this.LOG.debug("Schedule notification status update");
        this.dispatcher.queue(new Update(this, "notify"){
            final /* synthetic */ AutoImportProjectTracker this$0;

            public void run() {
                AutoImportProjectTracker.access$updateProjectNotification(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    public final void scheduleChangeProcessing() {
        this.LOG.debug("Schedule change processing");
        this.dispatcher.queue(new Update(this, "notify"){
            final /* synthetic */ AutoImportProjectTracker this$0;

            public void run() {
                if (AutoImportProjectTracker.access$getModificationType(this.this$0) == ProjectStatus.ModificationType.EXTERNAL && this.this$0.isAutoReloadExternalChanges()) {
                    AutoImportProjectTracker.access$refreshProject(this.this$0, false);
                } else {
                    AutoImportProjectTracker.access$updateProjectNotification(this.this$0);
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    private final void refreshProject(boolean doImportDeactivatedProjects) {
        this.LOG.debug("Incremental project refresh");
        if (this.isDisabled.get().booleanValue() || Registry.is((String)"external.system.auto.import.disabled")) {
            return;
        }
        if (!this.projectChangeOperation.isOperationCompleted()) {
            return;
        }
        boolean isSkippedProjectRefresh = true;
        for (ProjectData projectData2 : this.projectDataMap.values()) {
            boolean isAllowAutoReload;
            String projectId = projectData2.getProjectAware().getProjectId().getReadableName();
            boolean bl = isAllowAutoReload = doImportDeactivatedProjects || projectData2.isActivated();
            if (isAllowAutoReload && !projectData2.isUpToDate()) {
                isSkippedProjectRefresh = false;
                this.LOG.debug(projectId + ": Project refresh");
                projectData2.getProjectAware().refreshProject();
                continue;
            }
            this.LOG.debug(projectId + ": Skip project refresh");
        }
        if (isSkippedProjectRefresh) {
            this.updateProjectNotification();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProjectNotification() {
        this.LOG.debug("Notification status update");
        if (this.isDisabled.get().booleanValue() || Registry.is((String)"external.system.auto.import.disabled")) {
            return;
        }
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(this.project);
        Map map2 = this.projectDataMap;
        boolean bl = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl2 = false;
            map2 = (ExternalSystemProjectId)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ProjectData data2 = (ProjectData)entry2.getValue();
            boolean bl3 = data2.isUpToDate();
            if (bl3) {
                void projectId;
                notificationAware.notificationExpire((ExternalSystemProjectId)projectId);
                continue;
            }
            notificationAware.notificationNotify(data2.getProjectAware());
        }
    }

    private final ProjectStatus.ModificationType getModificationType() {
        Collection<ProjectData> collection = this.projectDataMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"projectDataMap.values");
        Stream stream = StreamsKt.asStream((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)getModificationType.1.INSTANCE));
        Object object = getModificationType.2.INSTANCE;
        if (object != null) {
            Function2 function2 = object;
            object = new AutoImportProjectTracker$sam$java_util_function_BinaryOperator$0(function2);
        }
        return stream.reduce((BinaryOperator)object).orElse(null);
    }

    public void register(@NotNull ExternalSystemProjectAware projectAware) {
        Intrinsics.checkParameterIsNotNull((Object)projectAware, (String)"projectAware");
        ExternalSystemProjectId projectId = projectAware.getProjectId();
        AtomicBooleanProperty activationProperty = new AtomicBooleanProperty(false);
        ProjectStatus projectStatus = new ProjectStatus(projectId.getReadableName());
        Disposable disposable2 = Disposer.newDisposable((String)projectId.getReadableName());
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable2, (String)"Disposer.newDisposable(projectId.readableName)");
        Disposable parentDisposable = disposable2;
        ProjectSettingsTracker settingsTracker = new ProjectSettingsTracker(this.project, this, this.backgroundExecutor, projectAware, parentDisposable);
        ProjectData projectData2 = new ProjectData(projectStatus, activationProperty, projectAware, settingsTracker, parentDisposable);
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(this.project);
        ((Map)this.projectDataMap).put(projectId, projectData2);
        String id2 = "ProjectSettingsTracker: " + projectData2.getProjectAware().getProjectId().getReadableName();
        settingsTracker.beforeApplyChanges((Function0<Unit>)((Function0)new Function0<Unit>(this, id2){
            final /* synthetic */ AutoImportProjectTracker this$0;
            final /* synthetic */ String $id;

            public final void invoke() {
                AutoImportProjectTracker.access$getProjectRefreshOperation$p(this.this$0).startTask(this.$id);
            }
            {
                this.this$0 = autoImportProjectTracker;
                this.$id = string;
                super(0);
            }
        }));
        settingsTracker.afterApplyChanges((Function0<Unit>)((Function0)new Function0<Unit>(this, id2){
            final /* synthetic */ AutoImportProjectTracker this$0;
            final /* synthetic */ String $id;

            public final void invoke() {
                AutoImportProjectTracker.access$getProjectRefreshOperation$p(this.this$0).finishTask(this.$id);
            }
            {
                this.this$0 = autoImportProjectTracker;
                this.$id = string;
                super(0);
            }
        }));
        activationProperty.afterSet((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AutoImportProjectTracker this$0;

            public final void invoke() {
                this.this$0.scheduleChangeProcessing();
            }
            {
                this.this$0 = autoImportProjectTracker;
                super(0);
            }
        }), parentDisposable);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)parentDisposable);
        projectAware.subscribe((ExternalSystemProjectRefreshListener)this.createProjectRefreshListener(projectData2), parentDisposable);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(notificationAware, projectId){
            final /* synthetic */ ProjectNotificationAware $notificationAware;
            final /* synthetic */ ExternalSystemProjectId $projectId;

            public final void dispose() {
                this.$notificationAware.notificationExpire(this.$projectId);
            }
            {
                this.$notificationAware = projectNotificationAware;
                this.$projectId = externalSystemProjectId;
            }
        });
        this.loadState(projectId, projectData2);
    }

    public void activate(@NotNull ExternalSystemProjectId id2) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        ProjectData projectData2 = this.projectDataMap(id2, (Function2<? super Map<ExternalSystemProjectId, ProjectData>, ? super ExternalSystemProjectId, ProjectData>)((Function2)activate.projectData.1.INSTANCE));
        if (projectData2 == null) {
            return;
        }
        ProjectData projectData3 = projectData2;
        projectData3.setActivated(true);
    }

    public void remove(@NotNull ExternalSystemProjectId id2) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        ProjectData projectData2 = this.projectDataMap(id2, (Function2<? super Map<ExternalSystemProjectId, ProjectData>, ? super ExternalSystemProjectId, ProjectData>)((Function2)remove.projectData.1.INSTANCE));
        if (projectData2 == null) {
            return;
        }
        ProjectData projectData3 = projectData2;
        Disposer.dispose((Disposable)projectData3.getParentDisposable());
    }

    public void markDirty(@NotNull ExternalSystemProjectId id2) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        ProjectData projectData2 = this.projectDataMap(id2, (Function2<? super Map<ExternalSystemProjectId, ProjectData>, ? super ExternalSystemProjectId, ProjectData>)((Function2)markDirty.projectData.1.INSTANCE));
        if (projectData2 == null) {
            return;
        }
        ProjectData projectData3 = projectData2;
        ProjectStatus.markDirty$default(projectData3.getStatus(), LocalTimeCounter.currentTime(), null, 2, null);
    }

    private final ProjectData projectDataMap(ExternalSystemProjectId id2, Function2<? super Map<ExternalSystemProjectId, ProjectData>, ? super ExternalSystemProjectId, ProjectData> action2) {
        ProjectData projectData2 = (ProjectData)action2.invoke(this.projectDataMap, (Object)id2);
        if (projectData2 == null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Project isn't registered by id=%s";
            Object[] objectArray = new Object[]{id2};
            Logger logger = this.LOG;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            logger.warn(string3);
        }
        return projectData2;
    }

    @NotNull
    public State getState() {
        Map projectSettingsTrackerStates2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence((Map)this.projectDataMap), (Function1)((Function1)new Function1<Map.Entry<? extends ExternalSystemProjectId, ? extends ProjectData>, Pair<? extends State.Id, ? extends State.Project>>(this){
            final /* synthetic */ AutoImportProjectTracker this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<State.Id, State.Project> invoke(@NotNull Map.Entry<ExternalSystemProjectId, ProjectData> $dstr$id$data) {
                void id2;
                Intrinsics.checkParameterIsNotNull($dstr$id$data, (String)"<name for destructuring parameter 0>");
                Map.Entry<ExternalSystemProjectId, ProjectData> entry = $dstr$id$data;
                boolean bl = false;
                ExternalSystemProjectId externalSystemProjectId = entry.getKey();
                entry = $dstr$id$data;
                bl = false;
                ProjectData data2 = entry.getValue();
                return TuplesKt.to((Object)AutoImportProjectTracker.access$getState(this.this$0, (ExternalSystemProjectId)id2), (Object)AutoImportProjectTracker.access$getState(this.this$0, data2));
            }
            {
                this.this$0 = autoImportProjectTracker;
                super(1);
            }
        })));
        return new State(this.isAutoReloadExternalChanges(), projectSettingsTrackerStates2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.setAutoReloadExternalChanges(state.isAutoReloadExternalChanges());
        this.projectStates.putAll(state.getProjectSettingsTrackerStates());
        Map $this$forEach$iv = this.projectDataMap;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void id2;
            Map.Entry element$iv;
            Map.Entry $dstr$id$data = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$id$data;
            boolean bl3 = false;
            ExternalSystemProjectId externalSystemProjectId = (ExternalSystemProjectId)entry.getKey();
            entry = $dstr$id$data;
            bl3 = false;
            ProjectData data2 = (ProjectData)entry.getValue();
            this.loadState((ExternalSystemProjectId)id2, data2);
        }
    }

    private final void loadState(ExternalSystemProjectId projectId, ProjectData projectData2) {
        ProjectSettingsTracker.State settingsTrackerState;
        State.Project projectState;
        State.Project project = projectState = this.projectStates.remove(this.getState(projectId));
        ProjectSettingsTracker.State state = settingsTrackerState = project != null ? project.getSettingsTracker() : null;
        if (settingsTrackerState == null || projectState.isDirty()) {
            projectData2.getStatus().markDirty(LocalTimeCounter.currentTime(), ProjectStatus.ModificationType.EXTERNAL);
            this.scheduleChangeProcessing();
            return;
        }
        projectData2.getSettingsTracker().loadState(settingsTrackerState);
        projectData2.getSettingsTracker().refreshChanges();
    }

    public void initializeComponent() {
        this.LOG.debug("Project tracker initialization");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"ApplicationManager.getAp\u2026ssageBus.connect(project)");
        MessageBusConnection connections = messageBusConnection;
        connections.subscribe(BatchFileChangeListener.TOPIC, (Object)this.createProjectChangesListener());
        this.dispatcher.usePassThroughInUnitTestMode();
        this.dispatcher.activate();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ExternalSystemProjectId> getActivatedProjects() {
        void $this$mapTo$iv$iv;
        ProjectData it;
        Iterable $this$filterTo$iv$iv;
        Collection<ProjectData> collection = this.projectDataMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"projectDataMap.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProjectData)element$iv$iv;
            boolean bl = false;
            if (!it.isActivated()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProjectData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            ExternalSystemProjectId externalSystemProjectId = it.getProjectAware().getProjectId();
            collection2.add(externalSystemProjectId);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void enableAutoImportInTests() {
        this.isDisabled.set(false);
    }

    private final State.Project getState(@NotNull ProjectData $this$getState) {
        return new State.Project($this$getState.getStatus().isDirty(), $this$getState.getSettingsTracker().getState());
    }

    private final String getState(@NotNull ProjectSystemId $this$getState) {
        String string = $this$getState.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
        return string;
    }

    private final State.Id getState(@NotNull ExternalSystemProjectId $this$getState) {
        return new State.Id(this.getState($this$getState.getSystemId()), $this$getState.getExternalProjectPath());
    }

    public AutoImportProjectTracker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.debugThrowable = new Throwable("Initialized with project=(" + this.project.isDisposed() + ", " + Disposer.isDisposed((Disposable)((Disposable)this.project)) + ", " + this.project + ')');
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026ternalSystem.autoimport\")");
        this.LOG = logger;
        this.projectStates = new ConcurrentHashMap();
        this.projectDataMap = new ConcurrentHashMap();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        this.isDisabled = new AtomicBooleanProperty(application.isUnitTestMode());
        this.autoReloadExternalChangesProperty = new AtomicBooleanProperty(true);
        this.projectChangeOperation = new AnonymousParallelOperationTrace("Project change operation");
        this.projectRefreshOperation = new CompoundParallelOperationTrace("Project refresh operation");
        this.dispatcher = new MergingUpdateQueue("AutoImportProjectTracker.dispatcher", this.getAUTO_REPARSE_DELAY(), false, null, (Disposable)this.project);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AutoImportProjectTracker.backgroundExecutor", (int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"AppExecutorUtil.createBo\u2026r.backgroundExecutor\", 1)");
        this.backgroundExecutor = executorService;
        this.isAutoReloadExternalChanges$delegate = this.autoReloadExternalChangesProperty;
        final ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(this.project);
        this.projectRefreshOperation.beforeOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                LOG.debug("Project refresh started");
            }
        }));
        this.projectRefreshOperation.beforeOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                notificationAware.notificationExpire();
            }
        }));
        this.projectRefreshOperation.afterOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.scheduleProjectNotificationUpdate();
            }
        }));
        this.projectRefreshOperation.afterOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                LOG.debug("Project refresh finished");
            }
        }));
        this.projectChangeOperation.beforeOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                LOG.debug("Project change started");
            }
        }));
        this.projectChangeOperation.beforeOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                notificationAware.notificationExpire();
            }
        }));
        this.projectChangeOperation.afterOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.scheduleChangeProcessing();
            }
        }));
        this.projectChangeOperation.afterOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                LOG.debug("Project change finished");
            }
        }));
        this.autoReloadExternalChangesProperty.afterSet((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.scheduleProjectRefresh();
            }
        }));
    }

    public static final /* synthetic */ AnonymousParallelOperationTrace access$getProjectChangeOperation$p(AutoImportProjectTracker $this) {
        return $this.projectChangeOperation;
    }

    public static final /* synthetic */ CompoundParallelOperationTrace access$getProjectRefreshOperation$p(AutoImportProjectTracker $this) {
        return $this.projectRefreshOperation;
    }

    public static final /* synthetic */ void access$refreshProject(AutoImportProjectTracker $this, boolean doImportDeactivatedProjects) {
        $this.refreshProject(doImportDeactivatedProjects);
    }

    public static final /* synthetic */ void access$updateProjectNotification(AutoImportProjectTracker $this) {
        $this.updateProjectNotification();
    }

    public static final /* synthetic */ ProjectStatus.ModificationType access$getModificationType(AutoImportProjectTracker $this) {
        return $this.getModificationType();
    }

    public static final /* synthetic */ State.Id access$getState(AutoImportProjectTracker $this, ExternalSystemProjectId $this$access_u24getState) {
        return $this.getState($this$access_u24getState);
    }

    public static final /* synthetic */ State.Project access$getState(AutoImportProjectTracker $this, ProjectData $this$access_u24getState) {
        return $this.getState($this$access_u24getState);
    }

    @JvmStatic
    @NotNull
    public static final AutoImportProjectTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003J;\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u0010'\u001a\u0004\u0018\u00010(J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0006\u0010+\u001a\u00020\u0010J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$ProjectData;", "", "status", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "activationProperty", "Lcom/intellij/openapi/observable/properties/BooleanProperty;", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "settingsTracker", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;Lcom/intellij/openapi/observable/properties/BooleanProperty;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;Lcom/intellij/openapi/Disposable;)V", "getActivationProperty", "()Lcom/intellij/openapi/observable/properties/BooleanProperty;", "<set-?>", "", "isActivated", "()Z", "setActivated", "(Z)V", "isActivated$delegate", "Lcom/intellij/openapi/observable/properties/BooleanProperty;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "getProjectAware", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "getSettingsTracker", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;", "getStatus", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "hashCode", "", "isUpToDate", "toString", "", "intellij.platform.externalSystem.impl"})
    private static final class ProjectData {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final BooleanProperty isActivated$delegate;
        @NotNull
        private final ProjectStatus status;
        @NotNull
        private final BooleanProperty activationProperty;
        @NotNull
        private final ExternalSystemProjectAware projectAware;
        @NotNull
        private final ProjectSettingsTracker settingsTracker;
        @NotNull
        private final Disposable parentDisposable;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ProjectData.class), "isActivated", "isActivated()Z"))};
        }

        public final boolean isActivated() {
            return (Boolean)this.isActivated$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setActivated(boolean bl) {
            this.isActivated$delegate.setValue(this, $$delegatedProperties[0], bl);
        }

        public final boolean isUpToDate() {
            return this.status.isUpToDate() && this.settingsTracker.isUpToDate();
        }

        @Nullable
        public final ProjectStatus.ModificationType getModificationType() {
            ProjectStatus.ModificationType trackerModificationType = this.status.getModificationType();
            ProjectStatus.ModificationType settingsTrackerModificationType = this.settingsTracker.getModificationType();
            return trackerModificationType == null ? settingsTrackerModificationType : (settingsTrackerModificationType == null ? trackerModificationType : settingsTrackerModificationType.merge(trackerModificationType));
        }

        @NotNull
        public final ProjectStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final BooleanProperty getActivationProperty() {
            return this.activationProperty;
        }

        @NotNull
        public final ExternalSystemProjectAware getProjectAware() {
            return this.projectAware;
        }

        @NotNull
        public final ProjectSettingsTracker getSettingsTracker() {
            return this.settingsTracker;
        }

        @NotNull
        public final Disposable getParentDisposable() {
            return this.parentDisposable;
        }

        public ProjectData(@NotNull ProjectStatus status, @NotNull BooleanProperty activationProperty, @NotNull ExternalSystemProjectAware projectAware, @NotNull ProjectSettingsTracker settingsTracker, @NotNull Disposable parentDisposable) {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)activationProperty, (String)"activationProperty");
            Intrinsics.checkParameterIsNotNull((Object)projectAware, (String)"projectAware");
            Intrinsics.checkParameterIsNotNull((Object)settingsTracker, (String)"settingsTracker");
            Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
            this.status = status;
            this.activationProperty = activationProperty;
            this.projectAware = projectAware;
            this.settingsTracker = settingsTracker;
            this.parentDisposable = parentDisposable;
            this.isActivated$delegate = this.activationProperty;
        }

        @NotNull
        public final ProjectStatus component1() {
            return this.status;
        }

        @NotNull
        public final BooleanProperty component2() {
            return this.activationProperty;
        }

        @NotNull
        public final ExternalSystemProjectAware component3() {
            return this.projectAware;
        }

        @NotNull
        public final ProjectSettingsTracker component4() {
            return this.settingsTracker;
        }

        @NotNull
        public final Disposable component5() {
            return this.parentDisposable;
        }

        @NotNull
        public final ProjectData copy(@NotNull ProjectStatus status, @NotNull BooleanProperty activationProperty, @NotNull ExternalSystemProjectAware projectAware, @NotNull ProjectSettingsTracker settingsTracker, @NotNull Disposable parentDisposable) {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)activationProperty, (String)"activationProperty");
            Intrinsics.checkParameterIsNotNull((Object)projectAware, (String)"projectAware");
            Intrinsics.checkParameterIsNotNull((Object)settingsTracker, (String)"settingsTracker");
            Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
            return new ProjectData(status, activationProperty, projectAware, settingsTracker, parentDisposable);
        }

        public static /* synthetic */ ProjectData copy$default(ProjectData projectData2, ProjectStatus projectStatus, BooleanProperty booleanProperty, ExternalSystemProjectAware externalSystemProjectAware, ProjectSettingsTracker projectSettingsTracker, Disposable disposable2, int n, Object object) {
            if ((n & 1) != 0) {
                projectStatus = projectData2.status;
            }
            if ((n & 2) != 0) {
                booleanProperty = projectData2.activationProperty;
            }
            if ((n & 4) != 0) {
                externalSystemProjectAware = projectData2.projectAware;
            }
            if ((n & 8) != 0) {
                projectSettingsTracker = projectData2.settingsTracker;
            }
            if ((n & 0x10) != 0) {
                disposable2 = projectData2.parentDisposable;
            }
            return projectData2.copy(projectStatus, booleanProperty, externalSystemProjectAware, projectSettingsTracker, disposable2);
        }

        @NotNull
        public String toString() {
            return "ProjectData(status=" + this.status + ", activationProperty=" + this.activationProperty + ", projectAware=" + this.projectAware + ", settingsTracker=" + this.settingsTracker + ", parentDisposable=" + this.parentDisposable + ")";
        }

        public int hashCode() {
            ProjectStatus projectStatus = this.status;
            BooleanProperty booleanProperty = this.activationProperty;
            ExternalSystemProjectAware externalSystemProjectAware = this.projectAware;
            ProjectSettingsTracker projectSettingsTracker = this.settingsTracker;
            Disposable disposable2 = this.parentDisposable;
            return ((((projectStatus != null ? projectStatus.hashCode() : 0) * 31 + (booleanProperty != null ? booleanProperty.hashCode() : 0)) * 31 + (externalSystemProjectAware != null ? externalSystemProjectAware.hashCode() : 0)) * 31 + (projectSettingsTracker != null ? projectSettingsTracker.hashCode() : 0)) * 31 + (disposable2 != null ? disposable2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ProjectData)) break block3;
                    ProjectData projectData2 = (ProjectData)object;
                    if (!Intrinsics.areEqual((Object)this.status, (Object)projectData2.status) || !Intrinsics.areEqual((Object)this.activationProperty, (Object)projectData2.activationProperty) || !Intrinsics.areEqual((Object)this.projectAware, (Object)projectData2.projectAware) || !Intrinsics.areEqual((Object)this.settingsTracker, (Object)projectData2.settingsTracker) || !Intrinsics.areEqual((Object)this.parentDisposable, (Object)projectData2.parentDisposable)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State;", "", "isAutoReloadExternalChanges", "", "projectSettingsTrackerStates", "", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State$Id;", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State$Project;", "(ZLjava/util/Map;)V", "()Z", "setAutoReloadExternalChanges", "(Z)V", "getProjectSettingsTrackerStates", "()Ljava/util/Map;", "setProjectSettingsTrackerStates", "(Ljava/util/Map;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Id", "Project", "intellij.platform.externalSystem.impl"})
    public static final class State {
        private boolean isAutoReloadExternalChanges;
        @NotNull
        private Map<Id, Project> projectSettingsTrackerStates;

        public final boolean isAutoReloadExternalChanges() {
            return this.isAutoReloadExternalChanges;
        }

        public final void setAutoReloadExternalChanges(boolean bl) {
            this.isAutoReloadExternalChanges = bl;
        }

        @NotNull
        public final Map<Id, Project> getProjectSettingsTrackerStates() {
            return this.projectSettingsTrackerStates;
        }

        public final void setProjectSettingsTrackerStates(@NotNull Map<Id, Project> map2) {
            Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
            this.projectSettingsTrackerStates = map2;
        }

        public State(boolean isAutoReloadExternalChanges, @NotNull Map<Id, Project> projectSettingsTrackerStates2) {
            Intrinsics.checkParameterIsNotNull(projectSettingsTrackerStates2, (String)"projectSettingsTrackerStates");
            this.isAutoReloadExternalChanges = isAutoReloadExternalChanges;
            this.projectSettingsTrackerStates = projectSettingsTrackerStates2;
        }

        public /* synthetic */ State(boolean bl, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(bl, map2);
        }

        public State() {
            this(false, null, 3, null);
        }

        public final boolean component1() {
            return this.isAutoReloadExternalChanges;
        }

        @NotNull
        public final Map<Id, Project> component2() {
            return this.projectSettingsTrackerStates;
        }

        @NotNull
        public final State copy(boolean isAutoReloadExternalChanges, @NotNull Map<Id, Project> projectSettingsTrackerStates2) {
            Intrinsics.checkParameterIsNotNull(projectSettingsTrackerStates2, (String)"projectSettingsTrackerStates");
            return new State(isAutoReloadExternalChanges, projectSettingsTrackerStates2);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isAutoReloadExternalChanges;
            }
            if ((n & 2) != 0) {
                map2 = state.projectSettingsTrackerStates;
            }
            return state.copy(bl, map2);
        }

        @NotNull
        public String toString() {
            return "State(isAutoReloadExternalChanges=" + this.isAutoReloadExternalChanges + ", projectSettingsTrackerStates=" + this.projectSettingsTrackerStates + ")";
        }

        public int hashCode() {
            int n = this.isAutoReloadExternalChanges ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            Map<Id, Project> map2 = this.projectSettingsTrackerStates;
            return n * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (this.isAutoReloadExternalChanges != state.isAutoReloadExternalChanges || !Intrinsics.areEqual(this.projectSettingsTrackerStates, state.projectSettingsTrackerStates)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State$Id;", "", "systemId", "", "externalProjectPath", "(Ljava/lang/String;Ljava/lang/String;)V", "getExternalProjectPath", "()Ljava/lang/String;", "setExternalProjectPath", "(Ljava/lang/String;)V", "getSystemId", "setSystemId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
        public static final class Id {
            @Nullable
            private String systemId;
            @Nullable
            private String externalProjectPath;

            @Nullable
            public final String getSystemId() {
                return this.systemId;
            }

            public final void setSystemId(@Nullable String string) {
                this.systemId = string;
            }

            @Nullable
            public final String getExternalProjectPath() {
                return this.externalProjectPath;
            }

            public final void setExternalProjectPath(@Nullable String string) {
                this.externalProjectPath = string;
            }

            public Id(@Nullable String systemId, @Nullable String externalProjectPath) {
                this.systemId = systemId;
                this.externalProjectPath = externalProjectPath;
            }

            public /* synthetic */ Id(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            public Id() {
                this(null, null, 3, null);
            }

            @Nullable
            public final String component1() {
                return this.systemId;
            }

            @Nullable
            public final String component2() {
                return this.externalProjectPath;
            }

            @NotNull
            public final Id copy(@Nullable String systemId, @Nullable String externalProjectPath) {
                return new Id(systemId, externalProjectPath);
            }

            public static /* synthetic */ Id copy$default(Id id2, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = id2.systemId;
                }
                if ((n & 2) != 0) {
                    string2 = id2.externalProjectPath;
                }
                return id2.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Id(systemId=" + this.systemId + ", externalProjectPath=" + this.externalProjectPath + ")";
            }

            public int hashCode() {
                String string = this.systemId;
                String string2 = this.externalProjectPath;
                return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Id)) break block3;
                        Id id2 = (Id)object;
                        if (!Intrinsics.areEqual((Object)this.systemId, (Object)id2.systemId) || !Intrinsics.areEqual((Object)this.externalProjectPath, (Object)id2.externalProjectPath)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$State$Project;", "", "isDirty", "", "settingsTracker", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "(ZLcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;)V", "()Z", "setDirty", "(Z)V", "getSettingsTracker", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "setSettingsTracker", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
        public static final class Project {
            private boolean isDirty;
            @Nullable
            private ProjectSettingsTracker.State settingsTracker;

            public final boolean isDirty() {
                return this.isDirty;
            }

            public final void setDirty(boolean bl) {
                this.isDirty = bl;
            }

            @Nullable
            public final ProjectSettingsTracker.State getSettingsTracker() {
                return this.settingsTracker;
            }

            public final void setSettingsTracker(@Nullable ProjectSettingsTracker.State state) {
                this.settingsTracker = state;
            }

            public Project(boolean isDirty, @Nullable ProjectSettingsTracker.State settingsTracker) {
                this.isDirty = isDirty;
                this.settingsTracker = settingsTracker;
            }

            public /* synthetic */ Project(boolean bl, ProjectSettingsTracker.State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    state = null;
                }
                this(bl, state);
            }

            public Project() {
                this(false, null, 3, null);
            }

            public final boolean component1() {
                return this.isDirty;
            }

            @Nullable
            public final ProjectSettingsTracker.State component2() {
                return this.settingsTracker;
            }

            @NotNull
            public final Project copy(boolean isDirty, @Nullable ProjectSettingsTracker.State settingsTracker) {
                return new Project(isDirty, settingsTracker);
            }

            public static /* synthetic */ Project copy$default(Project project, boolean bl, ProjectSettingsTracker.State state, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = project.isDirty;
                }
                if ((n & 2) != 0) {
                    state = project.settingsTracker;
                }
                return project.copy(bl, state);
            }

            @NotNull
            public String toString() {
                return "Project(isDirty=" + this.isDirty + ", settingsTracker=" + this.settingsTracker + ")";
            }

            public int hashCode() {
                int n = this.isDirty ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                ProjectSettingsTracker.State state = this.settingsTracker;
                return n * 31 + (state != null ? ((Object)state).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Project)) break block3;
                        Project project = (Project)object;
                        if (this.isDirty != project.isDirty || !Intrinsics.areEqual((Object)this.settingsTracker, (Object)project.settingsTracker)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AutoImportProjectTracker getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ExternalSystemProjectTracker externalSystemProjectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
            if (externalSystemProjectTracker == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker");
            }
            return (AutoImportProjectTracker)externalSystemProjectTracker;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

